/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.nio.ByteOrder;
import org.apache.hbase.thirdparty.io.netty.buffer.AbstractByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.SwappedByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    AbstractUnsafeSwappedByteBuf(AbstractByteBuf buf) {
        super(buf);
        assert (PlatformDependent.isUnaligned());
        this.wrapped = buf;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (this.order() == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final long getLong(int index2) {
        this.wrapped.checkIndex(index2, 8);
        long v = this._getLong(this.wrapped, index2);
        return this.nativeByteOrder ? v : Long.reverseBytes(v);
    }

    @Override
    public final float getFloat(int index2) {
        return Float.intBitsToFloat(this.getInt(index2));
    }

    @Override
    public final double getDouble(int index2) {
        return Double.longBitsToDouble(this.getLong(index2));
    }

    @Override
    public final char getChar(int index2) {
        return (char)this.getShort(index2);
    }

    @Override
    public final long getUnsignedInt(int index2) {
        return (long)this.getInt(index2) & 0xFFFFFFFFL;
    }

    @Override
    public final int getInt(int index2) {
        this.wrapped.checkIndex(index2, 4);
        int v = this._getInt(this.wrapped, index2);
        return this.nativeByteOrder ? v : Integer.reverseBytes(v);
    }

    @Override
    public final int getUnsignedShort(int index2) {
        return this.getShort(index2) & 0xFFFF;
    }

    @Override
    public final short getShort(int index2) {
        this.wrapped.checkIndex(index2, 2);
        short v = this._getShort(this.wrapped, index2);
        return this.nativeByteOrder ? v : Short.reverseBytes(v);
    }

    @Override
    public final ByteBuf setShort(int index2, int value2) {
        this.wrapped.checkIndex(index2, 2);
        this._setShort(this.wrapped, index2, this.nativeByteOrder ? (short)value2 : Short.reverseBytes((short)value2));
        return this;
    }

    @Override
    public final ByteBuf setInt(int index2, int value2) {
        this.wrapped.checkIndex(index2, 4);
        this._setInt(this.wrapped, index2, this.nativeByteOrder ? value2 : Integer.reverseBytes(value2));
        return this;
    }

    @Override
    public final ByteBuf setLong(int index2, long value2) {
        this.wrapped.checkIndex(index2, 8);
        this._setLong(this.wrapped, index2, this.nativeByteOrder ? value2 : Long.reverseBytes(value2));
        return this;
    }

    @Override
    public final ByteBuf setChar(int index2, int value2) {
        this.setShort(index2, value2);
        return this;
    }

    @Override
    public final ByteBuf setFloat(int index2, float value2) {
        this.setInt(index2, Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public final ByteBuf setDouble(int index2, double value2) {
        this.setLong(index2, Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public final ByteBuf writeShort(int value2) {
        this.wrapped.ensureWritable0(2);
        this._setShort(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)value2 : Short.reverseBytes((short)value2));
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public final ByteBuf writeInt(int value2) {
        this.wrapped.ensureWritable0(4);
        this._setInt(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? value2 : Integer.reverseBytes(value2));
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public final ByteBuf writeLong(long value2) {
        this.wrapped.ensureWritable0(8);
        this._setLong(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? value2 : Long.reverseBytes(value2));
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public final ByteBuf writeChar(int value2) {
        this.writeShort(value2);
        return this;
    }

    @Override
    public final ByteBuf writeFloat(float value2) {
        this.writeInt(Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public final ByteBuf writeDouble(double value2) {
        this.writeLong(Double.doubleToRawLongBits(value2));
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

