/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

final class LongLongHashMap {
    private static final int MASK_TEMPLATE = -2;
    private int mask;
    private long[] array;
    private int maxProbe;
    private long zeroVal;
    private final long emptyVal;

    LongLongHashMap(long emptyVal) {
        this.emptyVal = emptyVal;
        this.zeroVal = emptyVal;
        int initialSize = 32;
        this.array = new long[initialSize];
        this.mask = initialSize - 1;
        this.computeMaskAndProbe();
    }

    public long put(long key2, long value2) {
        if (key2 == 0L) {
            long prev = this.zeroVal;
            this.zeroVal = value2;
            return prev;
        }
        while (true) {
            int index2 = this.index(key2);
            for (int i2 = 0; i2 < this.maxProbe; ++i2) {
                long existing = this.array[index2];
                if (existing == key2 || existing == 0L) {
                    long prev = existing == 0L ? this.emptyVal : this.array[index2 + 1];
                    this.array[index2] = key2;
                    this.array[index2 + 1] = value2;
                    while (i2 < this.maxProbe) {
                        if (this.array[index2 = index2 + 2 & this.mask] == key2) {
                            this.array[index2] = 0L;
                            prev = this.array[index2 + 1];
                            break;
                        }
                        ++i2;
                    }
                    return prev;
                }
                index2 = index2 + 2 & this.mask;
            }
            this.expand();
        }
    }

    public void remove(long key2) {
        if (key2 == 0L) {
            this.zeroVal = this.emptyVal;
            return;
        }
        int index2 = this.index(key2);
        for (int i2 = 0; i2 < this.maxProbe; ++i2) {
            long existing = this.array[index2];
            if (existing == key2) {
                this.array[index2] = 0L;
                break;
            }
            index2 = index2 + 2 & this.mask;
        }
    }

    public long get(long key2) {
        if (key2 == 0L) {
            return this.zeroVal;
        }
        int index2 = this.index(key2);
        for (int i2 = 0; i2 < this.maxProbe; ++i2) {
            long existing = this.array[index2];
            if (existing == key2) {
                return this.array[index2 + 1];
            }
            index2 = index2 + 2 & this.mask;
        }
        return this.emptyVal;
    }

    private int index(long key2) {
        key2 ^= key2 >>> 33;
        key2 *= -49064778989728563L;
        key2 ^= key2 >>> 33;
        key2 *= -4265267296055464877L;
        key2 ^= key2 >>> 33;
        return (int)key2 & this.mask;
    }

    private void expand() {
        long[] prev = this.array;
        this.array = new long[prev.length * 2];
        this.computeMaskAndProbe();
        for (int i2 = 0; i2 < prev.length; i2 += 2) {
            long key2 = prev[i2];
            if (key2 == 0L) continue;
            long val = prev[i2 + 1];
            this.put(key2, val);
        }
    }

    private void computeMaskAndProbe() {
        int length2 = this.array.length;
        this.mask = length2 - 1 & 0xFFFFFFFE;
        this.maxProbe = (int)Math.log(length2);
    }
}

