/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import org.apache.hbase.thirdparty.io.netty.buffer.PoolThreadCache;
import org.apache.hbase.thirdparty.io.netty.buffer.SizeClassesMetric;

abstract class SizeClasses
implements SizeClassesMetric {
    static final int LOG2_QUANTUM = 4;
    private static final int LOG2_SIZE_CLASS_GROUP = 2;
    private static final int LOG2_MAX_LOOKUP_SIZE = 12;
    private static final int INDEX_IDX = 0;
    private static final int LOG2GROUP_IDX = 1;
    private static final int LOG2DELTA_IDX = 2;
    private static final int NDELTA_IDX = 3;
    private static final int PAGESIZE_IDX = 4;
    private static final int SUBPAGE_IDX = 5;
    private static final int LOG2_DELTA_LOOKUP_IDX = 6;
    private static final byte no = 0;
    private static final byte yes = 1;
    protected final int pageSize;
    protected final int pageShifts;
    protected final int chunkSize;
    protected final int directMemoryCacheAlignment;
    final int nSizes;
    int nSubpages;
    int nPSizes;
    int smallMaxSizeIdx;
    private int lookupMaxSize;
    private final short[][] sizeClasses;
    private final int[] pageIdx2sizeTab;
    private final int[] sizeIdx2sizeTab;
    private final int[] size2idxTab;

    protected SizeClasses(int pageSize, int pageShifts, int chunkSize, int directMemoryCacheAlignment) {
        this.pageSize = pageSize;
        this.pageShifts = pageShifts;
        this.chunkSize = chunkSize;
        this.directMemoryCacheAlignment = directMemoryCacheAlignment;
        int group2 = PoolThreadCache.log2(chunkSize) + 1 - 4;
        this.sizeClasses = new short[group2 << 2][7];
        this.nSizes = this.sizeClasses();
        this.sizeIdx2sizeTab = new int[this.nSizes];
        this.pageIdx2sizeTab = new int[this.nPSizes];
        this.idx2SizeTab(this.sizeIdx2sizeTab, this.pageIdx2sizeTab);
        this.size2idxTab = new int[this.lookupMaxSize >> 4];
        this.size2idxTab(this.size2idxTab);
    }

    private int sizeClasses() {
        int normalMaxSize = -1;
        int index2 = 0;
        int size2 = 0;
        int log2Group = 4;
        int log2Delta = 4;
        int ndeltaLimit = 4;
        int nDelta = 0;
        while (nDelta < ndeltaLimit) {
            size2 = this.sizeClass(index2++, log2Group, log2Delta, nDelta++);
        }
        log2Group += 2;
        while (size2 < this.chunkSize) {
            nDelta = 1;
            while (nDelta <= ndeltaLimit && size2 < this.chunkSize) {
                normalMaxSize = size2 = this.sizeClass(index2++, log2Group, log2Delta, nDelta++);
            }
            ++log2Group;
            ++log2Delta;
        }
        assert (this.chunkSize == normalMaxSize);
        return index2;
    }

    private int sizeClass(int index2, int log2Group, int log2Delta, int nDelta) {
        int log2Size;
        int pageSize;
        int size2;
        short isMultiPageSize = log2Delta >= this.pageShifts ? (short)1 : ((size2 = (1 << log2Group) + (1 << log2Delta) * nDelta) == size2 / (pageSize = 1 << this.pageShifts) * pageSize ? (short)1 : 0);
        int log2Ndelta = nDelta == 0 ? 0 : PoolThreadCache.log2(nDelta);
        boolean remove = 1 << log2Ndelta < nDelta;
        int n = log2Size = log2Delta + log2Ndelta == log2Group ? log2Group + 1 : log2Group;
        if (log2Size == log2Group) {
            remove = true;
        }
        short isSubpage = log2Size < this.pageShifts + 2 ? (short)1 : 0;
        int log2DeltaLookup = log2Size < 12 || log2Size == 12 && !remove ? log2Delta : 0;
        short[] sz = new short[]{(short)index2, (short)log2Group, (short)log2Delta, (short)nDelta, isMultiPageSize, isSubpage, (short)log2DeltaLookup};
        this.sizeClasses[index2] = sz;
        int size3 = (1 << log2Group) + (nDelta << log2Delta);
        if (sz[4] == 1) {
            ++this.nPSizes;
        }
        if (sz[5] == 1) {
            ++this.nSubpages;
            this.smallMaxSizeIdx = index2;
        }
        if (sz[6] != 0) {
            this.lookupMaxSize = size3;
        }
        return size3;
    }

    private void idx2SizeTab(int[] sizeIdx2sizeTab, int[] pageIdx2sizeTab) {
        int pageIdx = 0;
        for (int i2 = 0; i2 < this.nSizes; ++i2) {
            int size2;
            short[] sizeClass = this.sizeClasses[i2];
            short log2Group = sizeClass[1];
            short log2Delta = sizeClass[2];
            short nDelta = sizeClass[3];
            sizeIdx2sizeTab[i2] = size2 = (1 << log2Group) + (nDelta << log2Delta);
            if (sizeClass[4] != 1) continue;
            pageIdx2sizeTab[pageIdx++] = size2;
        }
    }

    private void size2idxTab(int[] size2idxTab) {
        int idx = 0;
        int size2 = 0;
        int i2 = 0;
        while (size2 <= this.lookupMaxSize) {
            short log2Delta = this.sizeClasses[i2][2];
            int times2 = 1 << log2Delta - 4;
            while (size2 <= this.lookupMaxSize && times2-- > 0) {
                size2idxTab[idx++] = i2;
                size2 = idx + 1 << 4;
            }
            ++i2;
        }
    }

    @Override
    public int sizeIdx2size(int sizeIdx) {
        return this.sizeIdx2sizeTab[sizeIdx];
    }

    @Override
    public int sizeIdx2sizeCompute(int sizeIdx) {
        int group2 = sizeIdx >> 2;
        int mod = sizeIdx & 3;
        int groupSize = group2 == 0 ? 0 : 32 << group2;
        int shift2 = group2 == 0 ? 1 : group2;
        int lgDelta = shift2 + 4 - 1;
        int modSize = mod + 1 << lgDelta;
        return groupSize + modSize;
    }

    @Override
    public long pageIdx2size(int pageIdx) {
        return this.pageIdx2sizeTab[pageIdx];
    }

    @Override
    public long pageIdx2sizeCompute(int pageIdx) {
        int group2 = pageIdx >> 2;
        int mod = pageIdx & 3;
        long groupSize = group2 == 0 ? 0L : 1L << this.pageShifts + 2 - 1 << group2;
        int shift2 = group2 == 0 ? 1 : group2;
        int log2Delta = shift2 + this.pageShifts - 1;
        int modSize = mod + 1 << log2Delta;
        return groupSize + (long)modSize;
    }

    @Override
    public int size2SizeIdx(int size2) {
        if (size2 == 0) {
            return 0;
        }
        if (size2 > this.chunkSize) {
            return this.nSizes;
        }
        if (this.directMemoryCacheAlignment > 0) {
            size2 = this.alignSize(size2);
        }
        if (size2 <= this.lookupMaxSize) {
            return this.size2idxTab[size2 - 1 >> 4];
        }
        int x = PoolThreadCache.log2((size2 << 1) - 1);
        int shift2 = x < 7 ? 0 : x - 6;
        int group2 = shift2 << 2;
        int log2Delta = x < 7 ? 4 : x - 2 - 1;
        int deltaInverseMask = -1 << log2Delta;
        int mod = (size2 - 1 & deltaInverseMask) >> log2Delta & 3;
        return group2 + mod;
    }

    @Override
    public int pages2pageIdx(int pages) {
        return this.pages2pageIdxCompute(pages, false);
    }

    @Override
    public int pages2pageIdxFloor(int pages) {
        return this.pages2pageIdxCompute(pages, true);
    }

    private int pages2pageIdxCompute(int pages, boolean floor2) {
        int pageSize = pages << this.pageShifts;
        if (pageSize > this.chunkSize) {
            return this.nPSizes;
        }
        int x = PoolThreadCache.log2((pageSize << 1) - 1);
        int shift2 = x < 2 + this.pageShifts ? 0 : x - (2 + this.pageShifts);
        int group2 = shift2 << 2;
        int log2Delta = x < 2 + this.pageShifts + 1 ? this.pageShifts : x - 2 - 1;
        int deltaInverseMask = -1 << log2Delta;
        int mod = (pageSize - 1 & deltaInverseMask) >> log2Delta & 3;
        int pageIdx = group2 + mod;
        if (floor2 && this.pageIdx2sizeTab[pageIdx] > pages << this.pageShifts) {
            --pageIdx;
        }
        return pageIdx;
    }

    private int alignSize(int size2) {
        int delta = size2 & this.directMemoryCacheAlignment - 1;
        return delta == 0 ? size2 : size2 + this.directMemoryCacheAlignment - delta;
    }

    @Override
    public int normalizeSize(int size2) {
        if (size2 == 0) {
            return this.sizeIdx2sizeTab[0];
        }
        if (this.directMemoryCacheAlignment > 0) {
            size2 = this.alignSize(size2);
        }
        if (size2 <= this.lookupMaxSize) {
            int ret = this.sizeIdx2sizeTab[this.size2idxTab[size2 - 1 >> 4]];
            assert (ret == SizeClasses.normalizeSizeCompute(size2));
            return ret;
        }
        return SizeClasses.normalizeSizeCompute(size2);
    }

    private static int normalizeSizeCompute(int size2) {
        int x = PoolThreadCache.log2((size2 << 1) - 1);
        int log2Delta = x < 7 ? 4 : x - 2 - 1;
        int delta = 1 << log2Delta;
        int delta_mask = delta - 1;
        return size2 + delta_mask & ~delta_mask;
    }
}

