/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.channel;

import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.channel.PendingBytesTracker;
import org.apache.hbase.thirdparty.io.netty.channel.VoidChannelPromise;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.EventExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.PromiseCombiner;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectPool;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.SystemPropertyUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("org.apache.hbase.thirdparty.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelOutboundInvoker invoker;
    private final EventExecutor executor;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext ctx) {
        this.tracker = PendingBytesTracker.newTracker(ctx.channel());
        this.invoker = ctx;
        this.executor = ctx.executor();
    }

    public PendingWriteQueue(Channel channel) {
        this.tracker = PendingBytesTracker.newTracker(channel);
        this.invoker = channel;
        this.executor = channel.eventLoop();
    }

    public boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.executor.inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.executor.inEventLoop());
        return this.bytes;
    }

    private int size(Object msg) {
        int messageSize = this.tracker.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        return messageSize + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object msg, ChannelPromise promise) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(msg, "msg");
        ObjectUtil.checkNotNull(promise, "promise");
        int messageSize = this.size(msg);
        PendingWrite write2 = PendingWrite.newInstance(msg, messageSize, promise);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            this.tail = this.head = write2;
        } else {
            currentTail.next = write2;
            this.tail = write2;
        }
        ++this.size;
        this.bytes += (long)messageSize;
        this.tracker.incrementPendingOutboundBytes(write2.size);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise p2 = this.invoker.newPromise();
        PromiseCombiner combiner = new PromiseCombiner(this.executor);
        try {
            PendingWrite write2 = this.head;
            while (write2 != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (write2 != null) {
                    PendingWrite next2 = write2.next;
                    Object msg = write2.msg;
                    ChannelPromise promise = write2.promise;
                    this.recycle(write2, false);
                    if (!(promise instanceof VoidChannelPromise)) {
                        combiner.add(promise);
                    }
                    this.invoker.write(msg, promise);
                    write2 = next2;
                }
                write2 = this.head;
            }
            combiner.finish(p2);
        }
        catch (Throwable cause2) {
            p2.setFailure(cause2);
        }
        this.assertEmpty();
        return p2;
    }

    public void removeAndFailAll(Throwable cause2) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(cause2, "cause");
        PendingWrite write2 = this.head;
        while (write2 != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (write2 != null) {
                PendingWrite next2 = write2.next;
                ReferenceCountUtil.safeRelease(write2.msg);
                ChannelPromise promise = write2.promise;
                this.recycle(write2, false);
                PendingWriteQueue.safeFail(promise, cause2);
                write2 = next2;
            }
            write2 = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable cause2) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(cause2, "cause");
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(write2.msg);
        ChannelPromise promise = write2.promise;
        PendingWriteQueue.safeFail(promise, cause2);
        this.recycle(write2, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.executor.inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        Object msg = write2.msg;
        ChannelPromise promise = write2.promise;
        this.recycle(write2, true);
        return this.invoker.write(msg, promise);
    }

    public ChannelPromise remove() {
        assert (this.executor.inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        ChannelPromise promise = write2.promise;
        ReferenceCountUtil.safeRelease(write2.msg);
        this.recycle(write2, true);
        return promise;
    }

    public Object current() {
        assert (this.executor.inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        return write2.msg;
    }

    private void recycle(PendingWrite write2, boolean update2) {
        PendingWrite next2 = write2.next;
        long writeSize = write2.size;
        if (update2) {
            if (next2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = next2;
                --this.size;
                this.bytes -= writeSize;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        write2.recycle();
        this.tracker.decrementPendingOutboundBytes(writeSize);
    }

    private static void safeFail(ChannelPromise promise, Throwable cause2) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause2)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause2);
        }
    }

    static final class PendingWrite {
        private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PendingWrite>(){

            @Override
            public PendingWrite newObject(ObjectPool.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        });
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object msg, int size2, ChannelPromise promise) {
            PendingWrite write2 = RECYCLER.get();
            write2.size = size2;
            write2.msg = msg;
            write2.promise = promise;
            return write2;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

