/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.spdy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hbase.thirdparty.io.netty.handler.codec.CharSequenceValueConverter;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DefaultHeaders;
import org.apache.hbase.thirdparty.io.netty.handler.codec.HeadersUtils;
import org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyCodecUtil;
import org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyHeaders;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;

public class DefaultSpdyHeaders
extends DefaultHeaders<CharSequence, CharSequence, SpdyHeaders>
implements SpdyHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> SpdyNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence name2) {
            SpdyCodecUtil.validateHeaderName(name2);
        }
    };

    public DefaultSpdyHeaders() {
        this(true);
    }

    public DefaultSpdyHeaders(boolean validate) {
        super(AsciiString.CASE_INSENSITIVE_HASHER, validate ? HeaderValueConverterAndValidator.INSTANCE : CharSequenceValueConverter.INSTANCE, validate ? SpdyNameValidator : DefaultHeaders.NameValidator.NOT_NULL);
    }

    @Override
    public String getAsString(CharSequence name2) {
        return HeadersUtils.getAsString(this, name2);
    }

    @Override
    public List<String> getAllAsString(CharSequence name2) {
        return HeadersUtils.getAllAsString(this, name2);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iteratorAsString() {
        return HeadersUtils.iteratorAsString(this);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value2) {
        return this.contains(name2, value2, false);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        return this.contains(name2, value2, ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    private static final class HeaderValueConverterAndValidator
    extends CharSequenceValueConverter {
        public static final HeaderValueConverterAndValidator INSTANCE = new HeaderValueConverterAndValidator();

        private HeaderValueConverterAndValidator() {
        }

        @Override
        public CharSequence convertObject(Object value2) {
            CharSequence seq = super.convertObject(value2);
            SpdyCodecUtil.validateHeaderValue(seq);
            return seq;
        }
    }
}

