/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.ssl;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hbase.thirdparty.io.netty.util.internal.EmptyArrays;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

final class PseudoRandomFunction {
    private PseudoRandomFunction() {
    }

    static byte[] hash(byte[] secret, byte[] label, byte[] seed2, int length2, String algo) {
        ObjectUtil.checkPositiveOrZero(length2, "length");
        try {
            byte[] data;
            Mac hmac = Mac.getInstance(algo);
            hmac.init(new SecretKeySpec(secret, algo));
            int iterations = (int)Math.ceil((double)length2 / (double)hmac.getMacLength());
            byte[] expansion = EmptyArrays.EMPTY_BYTES;
            byte[] A = data = PseudoRandomFunction.concat(label, seed2);
            for (int i2 = 0; i2 < iterations; ++i2) {
                A = hmac.doFinal(A);
                expansion = PseudoRandomFunction.concat(expansion, hmac.doFinal(PseudoRandomFunction.concat(A, data)));
            }
            return Arrays.copyOf(expansion, length2);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Could not find algo: " + algo, e);
        }
    }

    private static byte[] concat(byte[] first2, byte[] second) {
        byte[] result2 = Arrays.copyOf(first2, first2.length + second.length);
        System.arraycopy(second, 0, result2, first2.length, second.length);
        return result2;
    }
}

