/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hbase.thirdparty.io.netty.util.collection.ByteObjectMap;
import org.apache.hbase.thirdparty.io.netty.util.internal.MathUtil;

public class ByteObjectHashMap<V>
implements ByteObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private byte[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Byte> keySet = new KeySet();
    private final Set<Map.Entry<Byte, V>> entrySet = new EntrySet();
    private final Iterable<ByteObjectMap.PrimitiveEntry<V>> entries = new Iterable<ByteObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<ByteObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public ByteObjectHashMap() {
        this(8, 0.5f);
    }

    public ByteObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public ByteObjectHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = MathUtil.safeFindNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new byte[capacity];
        Object[] temp = new Object[capacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(capacity);
    }

    private static <T> T toExternal(T value2) {
        assert (value2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return value2 == NULL_VALUE ? null : (T)value2;
    }

    private static <T> T toInternal(T value2) {
        return (T)(value2 == null ? NULL_VALUE : value2);
    }

    @Override
    public V get(byte key2) {
        int index2 = this.indexOf(key2);
        return index2 == -1 ? null : (V)ByteObjectHashMap.toExternal(this.values[index2]);
    }

    @Override
    public V put(byte key2, V value2) {
        int startIndex;
        int index2 = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index2] == null) {
                this.keys[index2] = key2;
                this.values[index2] = ByteObjectHashMap.toInternal(value2);
                this.growSize();
                return null;
            }
            if (this.keys[index2] != key2) continue;
            V previousValue = this.values[index2];
            this.values[index2] = ByteObjectHashMap.toInternal(value2);
            return ByteObjectHashMap.toExternal(previousValue);
        } while ((index2 = this.probeNext(index2)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends V> sourceMap) {
        if (sourceMap instanceof ByteObjectHashMap) {
            ByteObjectHashMap source2 = (ByteObjectHashMap)sourceMap;
            for (int i2 = 0; i2 < source2.values.length; ++i2) {
                V sourceValue = source2.values[i2];
                if (sourceValue == null) continue;
                this.put(source2.keys[i2], sourceValue);
            }
            return;
        }
        for (Map.Entry<Byte, V> entry : sourceMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(byte key2) {
        int index2 = this.indexOf(key2);
        if (index2 == -1) {
            return null;
        }
        V prev = this.values[index2];
        this.removeAt(index2);
        return ByteObjectHashMap.toExternal(prev);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(byte key2) {
        return this.indexOf(key2) >= 0;
    }

    @Override
    public boolean containsValue(Object value2) {
        Object v1 = ByteObjectHashMap.toInternal(value2);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ByteObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ByteObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash2 = this.size;
        for (byte key2 : this.keys) {
            hash2 ^= ByteObjectHashMap.hashCode(key2);
        }
        return hash2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap other = (ByteObjectMap)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V value2 = this.values[i2];
            if (value2 == null) continue;
            byte key2 = this.keys[i2];
            Object otherValue = other.get(key2);
            if (!(value2 == NULL_VALUE ? otherValue != null : !value2.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.containsKey(this.objectToKey(key2));
    }

    @Override
    public V get(Object key2) {
        return this.get(this.objectToKey(key2));
    }

    @Override
    public V put(Byte key2, V value2) {
        return this.put(this.objectToKey(key2), value2);
    }

    @Override
    public V remove(Object key2) {
        return this.remove(this.objectToKey(key2));
    }

    @Override
    public Set<Byte> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        return this.entrySet;
    }

    private byte objectToKey(Object key2) {
        return (Byte)key2;
    }

    private int indexOf(byte key2) {
        int startIndex;
        int index2 = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index2] == null) {
                return -1;
            }
            if (key2 != this.keys[index2]) continue;
            return index2;
        } while ((index2 = this.probeNext(index2)) != startIndex);
        return -1;
    }

    private int hashIndex(byte key2) {
        return ByteObjectHashMap.hashCode(key2) & this.mask;
    }

    private static int hashCode(byte key2) {
        return key2;
    }

    private int probeNext(int index2) {
        return index2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int index2) {
        --this.size;
        this.keys[index2] = 0;
        this.values[index2] = null;
        int nextFree = index2;
        int i2 = this.probeNext(index2);
        V value2 = this.values[i2];
        while (value2 != null) {
            byte key2 = this.keys[i2];
            int bucket = this.hashIndex(key2);
            if (i2 < bucket && (bucket <= nextFree || nextFree <= i2) || bucket <= nextFree && nextFree <= i2) {
                this.keys[nextFree] = key2;
                this.values[nextFree] = value2;
                this.keys[i2] = 0;
                this.values[i2] = null;
                nextFree = i2;
            }
            i2 = this.probeNext(i2);
            value2 = this.values[i2];
        }
        return nextFree != index2;
    }

    private int calcMaxSize(int capacity) {
        int upperBound = capacity - 1;
        return Math.min(upperBound, (int)((float)capacity * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        byte[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new byte[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i2 = 0; i2 < oldVals.length; ++i2) {
            V oldVal = oldVals[i2];
            if (oldVal == null) continue;
            byte oldKey = oldKeys[i2];
            int index2 = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index2] == null) {
                    this.keys[index2] = oldKey;
                    this.values[index2] = oldVal;
                    continue block0;
                }
                index2 = this.probeNext(index2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V value2 = this.values[i2];
            if (value2 == null) continue;
            if (!first2) {
                sb.append(", ");
            }
            sb.append(this.keyToString(this.keys[i2])).append('=').append((Object)(value2 == this ? "(this Map)" : ByteObjectHashMap.toExternal(value2)));
            first2 = false;
        }
        return sb.append('}').toString();
    }

    protected String keyToString(byte key2) {
        return Byte.toString(key2);
    }

    final class MapEntry
    implements Map.Entry<Byte, V> {
        private final int entryIndex;

        MapEntry(int entryIndex) {
            this.entryIndex = entryIndex;
        }

        @Override
        public Byte getKey() {
            this.verifyExists();
            return ByteObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V getValue() {
            this.verifyExists();
            return ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public V setValue(V value2) {
            this.verifyExists();
            Object prevValue = ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
            ((ByteObjectHashMap)ByteObjectHashMap.this).values[this.entryIndex] = ByteObjectHashMap.toInternal(value2);
            return prevValue;
        }

        private void verifyExists() {
            if (ByteObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Byte, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<Byte, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements Iterator<ByteObjectMap.PrimitiveEntry<V>>,
    ByteObjectMap.PrimitiveEntry<V> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != ByteObjectHashMap.this.values.length && ByteObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != ByteObjectHashMap.this.values.length;
        }

        @Override
        public ByteObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (ByteObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public byte key() {
            return ByteObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V value() {
            return ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public void setValue(V value2) {
            ((ByteObjectHashMap)ByteObjectHashMap.this).values[this.entryIndex] = ByteObjectHashMap.toInternal(value2);
        }
    }

    private final class KeySet
    extends AbstractSet<Byte> {
        private KeySet() {
        }

        @Override
        public int size() {
            return ByteObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ByteObjectHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ByteObjectHashMap.this.remove(o) != null;
        }

        @Override
        public boolean retainAll(Collection<?> retainedKeys) {
            boolean changed = false;
            Iterator iter = ByteObjectHashMap.this.entries().iterator();
            while (iter.hasNext()) {
                ByteObjectMap.PrimitiveEntry entry = iter.next();
                if (retainedKeys.contains(entry.key())) continue;
                changed = true;
                iter.remove();
            }
            return changed;
        }

        @Override
        public void clear() {
            ByteObjectHashMap.this.clear();
        }

        @Override
        public Iterator<Byte> iterator() {
            return new Iterator<Byte>(){
                private final Iterator<Map.Entry<Byte, V>> iter;
                {
                    this.iter = ByteObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Byte next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Byte, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Byte, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return ByteObjectHashMap.this.size();
        }
    }
}

