/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.concurrent;

import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocalRunnable;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocalThread;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    public DefaultThreadFactory(Class<?> poolType) {
        this(poolType, false, 5);
    }

    public DefaultThreadFactory(String poolName) {
        this(poolName, false, 5);
    }

    public DefaultThreadFactory(Class<?> poolType, boolean daemon) {
        this(poolType, daemon, 5);
    }

    public DefaultThreadFactory(String poolName, boolean daemon) {
        this(poolName, daemon, 5);
    }

    public DefaultThreadFactory(Class<?> poolType, int priority2) {
        this(poolType, false, priority2);
    }

    public DefaultThreadFactory(String poolName, int priority2) {
        this(poolName, false, priority2);
    }

    public DefaultThreadFactory(Class<?> poolType, boolean daemon, int priority2) {
        this(DefaultThreadFactory.toPoolName(poolType), daemon, priority2);
    }

    public static String toPoolName(Class<?> poolType) {
        ObjectUtil.checkNotNull(poolType, "poolType");
        String poolName = StringUtil.simpleClassName(poolType);
        switch (poolName.length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return poolName.toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(poolName.charAt(0)) && Character.isLowerCase(poolName.charAt(1))) {
            return Character.toLowerCase(poolName.charAt(0)) + poolName.substring(1);
        }
        return poolName;
    }

    public DefaultThreadFactory(String poolName, boolean daemon, int priority2, ThreadGroup threadGroup) {
        ObjectUtil.checkNotNull(poolName, "poolName");
        if (priority2 < 1 || priority2 > 10) {
            throw new IllegalArgumentException("priority: " + priority2 + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = poolName + '-' + poolId.incrementAndGet() + '-';
        this.daemon = daemon;
        this.priority = priority2;
        this.threadGroup = threadGroup;
    }

    public DefaultThreadFactory(String poolName, boolean daemon, int priority2) {
        this(poolName, daemon, priority2, null);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.newThread(FastThreadLocalRunnable.wrap(r), this.prefix + this.nextId.incrementAndGet());
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return t;
    }

    protected Thread newThread(Runnable r, String name2) {
        return new FastThreadLocalThread(this.threadGroup, r, name2);
    }
}

