/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public final class JavaPropertyConfiguration
extends HTraceConfiguration {
    private static final Log LOG = LogFactory.getLog(JavaPropertyConfiguration.class);
    private final String[] prefixes;

    private JavaPropertyConfiguration(LinkedList<String> prefixes) {
        this.prefixes = new String[prefixes.size()];
        int i2 = 0;
        Iterator<String> it = prefixes.descendingIterator();
        while (it.hasNext()) {
            this.prefixes[i2++] = it.next();
        }
    }

    @Override
    public String get(String key2) {
        for (String prefix : this.prefixes) {
            String val = System.getProperty(prefix + key2);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public String get(String key2, String defaultValue) {
        String val = this.get(key2);
        return val != null ? val : defaultValue;
    }

    public static class Builder {
        final LinkedList<String> prefixes = new LinkedList();

        public Builder() {
            this.prefixes.add("htrace.");
        }

        public Builder clearPrefixes() {
            this.prefixes.clear();
            return this;
        }

        public Builder addPrefix(String prefix) {
            this.prefixes.add(prefix);
            return this;
        }

        JavaPropertyConfiguration build() {
            return new JavaPropertyConfiguration(this.prefixes);
        }
    }
}

