/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.util.UUID;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.TokenBuffer;

public class UUIDSerializer
extends StdScalarSerializer<UUID> {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public UUIDSerializer() {
        super(UUID.class);
    }

    @Override
    public boolean isEmpty(UUID value2) {
        if (value2 == null) {
            return true;
        }
        return value2.getLeastSignificantBits() == 0L && value2.getMostSignificantBits() == 0L;
    }

    @Override
    public void serialize(UUID value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (jgen.canWriteBinaryNatively() && !(jgen instanceof TokenBuffer)) {
            jgen.writeBinary(UUIDSerializer._asBytes(value2));
            return;
        }
        char[] ch = new char[36];
        long msb = value2.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(msb >> 32), ch, 0);
        ch[8] = 45;
        int i2 = (int)msb;
        UUIDSerializer._appendShort(i2 >>> 16, ch, 9);
        ch[13] = 45;
        UUIDSerializer._appendShort(i2, ch, 14);
        ch[18] = 45;
        long lsb = value2.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(lsb >>> 48), ch, 19);
        ch[23] = 45;
        UUIDSerializer._appendShort((int)(lsb >>> 32), ch, 24);
        UUIDSerializer._appendInt((int)lsb, ch, 28);
        jgen.writeString(ch, 0, 36);
    }

    private static void _appendInt(int bits, char[] ch, int offset2) {
        UUIDSerializer._appendShort(bits >> 16, ch, offset2);
        UUIDSerializer._appendShort(bits, ch, offset2 + 4);
    }

    private static void _appendShort(int bits, char[] ch, int offset2) {
        ch[offset2] = HEX_CHARS[bits >> 12 & 0xF];
        ch[++offset2] = HEX_CHARS[bits >> 8 & 0xF];
        ch[++offset2] = HEX_CHARS[bits >> 4 & 0xF];
        ch[++offset2] = HEX_CHARS[bits & 0xF];
    }

    private static final byte[] _asBytes(UUID uuid) {
        byte[] buffer = new byte[16];
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        UUIDSerializer._appendInt((int)(hi >> 32), buffer, 0);
        UUIDSerializer._appendInt((int)hi, buffer, 4);
        UUIDSerializer._appendInt((int)(lo >> 32), buffer, 8);
        UUIDSerializer._appendInt((int)lo, buffer, 12);
        return buffer;
    }

    private static final void _appendInt(int value2, byte[] buffer, int offset2) {
        buffer[offset2] = (byte)(value2 >> 24);
        buffer[++offset2] = (byte)(value2 >> 16);
        buffer[++offset2] = (byte)(value2 >> 8);
        buffer[++offset2] = (byte)value2;
    }
}

