/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String GMT_ID = "GMT";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");

    public static TimeZone timeZoneGMT() {
        return TIMEZONE_GMT;
    }

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean millis, TimeZone tz) {
        int offset2;
        GregorianCalendar calendar = new GregorianCalendar(tz, Locale.US);
        calendar.setTime(date);
        int capacity = "yyyy-MM-ddThh:mm:ss".length();
        capacity += millis ? ".sss".length() : 0;
        StringBuilder formatted = new StringBuilder(capacity += tz.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        ISO8601Utils.padInt(formatted, calendar.get(1), "yyyy".length());
        formatted.append('-');
        ISO8601Utils.padInt(formatted, calendar.get(2) + 1, "MM".length());
        formatted.append('-');
        ISO8601Utils.padInt(formatted, calendar.get(5), "dd".length());
        formatted.append('T');
        ISO8601Utils.padInt(formatted, calendar.get(11), "hh".length());
        formatted.append(':');
        ISO8601Utils.padInt(formatted, calendar.get(12), "mm".length());
        formatted.append(':');
        ISO8601Utils.padInt(formatted, calendar.get(13), "ss".length());
        if (millis) {
            formatted.append('.');
            ISO8601Utils.padInt(formatted, calendar.get(14), "sss".length());
        }
        if ((offset2 = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset2 / 60000 / 60);
            int minutes = Math.abs(offset2 / 60000 % 60);
            formatted.append(offset2 < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(formatted, hours, "hh".length());
            formatted.append(':');
            ISO8601Utils.padInt(formatted, minutes, "mm".length());
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    public static Date parse(String date) {
        RuntimeException fail = null;
        try {
            String timezoneId;
            char timezoneIndicator;
            int offset2 = 0;
            int year2 = ISO8601Utils.parseInt(date, offset2, offset2 += 4);
            ISO8601Utils.checkOffset(date, offset2, '-');
            int month2 = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            ISO8601Utils.checkOffset(date, offset2, '-');
            int day = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            ISO8601Utils.checkOffset(date, offset2, 'T');
            int hour2 = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            ISO8601Utils.checkOffset(date, offset2, ':');
            int minutes = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            ISO8601Utils.checkOffset(date, offset2, ':');
            int seconds = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            int milliseconds = 0;
            if (date.charAt(offset2) == '.') {
                ISO8601Utils.checkOffset(date, offset2, '.');
                milliseconds = ISO8601Utils.parseInt(date, ++offset2, offset2 += 3);
            }
            if ((timezoneIndicator = date.charAt(offset2)) == '+' || timezoneIndicator == '-') {
                timezoneId = GMT_ID + date.substring(offset2);
            } else if (timezoneIndicator == 'Z') {
                timezoneId = GMT_ID;
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator " + timezoneIndicator);
            }
            TimeZone timezone = TimeZone.getTimeZone(timezoneId);
            if (!timezone.getID().equals(timezoneId)) {
                throw new IndexOutOfBoundsException();
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year2);
            calendar.set(2, month2 - 1);
            calendar.set(5, day);
            calendar.set(11, hour2);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException e) {
            fail = e;
        }
        catch (NumberFormatException e) {
            fail = e;
        }
        catch (IllegalArgumentException e) {
            fail = e;
        }
        String input = date == null ? null : '\"' + date + "'";
        throw new IllegalArgumentException("Failed to parse date [" + input + "]: " + fail.getMessage(), fail);
    }

    private static void checkOffset(String value2, int offset2, char expected) throws IndexOutOfBoundsException {
        char found = value2.charAt(offset2);
        if (found != expected) {
            throw new IndexOutOfBoundsException("Expected '" + expected + "' character but found '" + found + "'");
        }
    }

    private static int parseInt(String value2, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value2.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value2);
        }
        int i2 = beginIndex;
        int result2 = 0;
        if (i2 < endIndex) {
            if ((digit = Character.digit(value2.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value2);
            }
            result2 = -digit;
        }
        while (i2 < endIndex) {
            if ((digit = Character.digit(value2.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value2);
            }
            result2 *= 10;
            result2 -= digit;
        }
        return -result2;
    }

    private static void padInt(StringBuilder buffer, int value2, int length2) {
        String strValue = Integer.toString(value2);
        for (int i2 = length2 - strValue.length(); i2 > 0; --i2) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }
}

