/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    static final TimeZone UTC;
    private static final BitSet DELIMS;
    private static final Map<String, Integer> MONTHS;
    private static final Pattern TIME_PATTERN;
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern YEAR_PATTERN;

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value2)) {
            return;
        }
        ParserCursor cursor = new ParserCursor(0, value2.length());
        StringBuilder content = new StringBuilder();
        int second = 0;
        int minute = 0;
        int hour2 = 0;
        int day = 0;
        int month2 = 0;
        int year2 = 0;
        boolean foundTime = false;
        boolean foundDayOfMonth = false;
        boolean foundMonth = false;
        boolean foundYear = false;
        try {
            while (!cursor.atEnd()) {
                this.skipDelims(value2, cursor);
                content.setLength(0);
                this.copyContent(value2, cursor, content);
                if (content.length() != 0) {
                    Matcher matcher;
                    if (!foundTime && (matcher = TIME_PATTERN.matcher(content)).matches()) {
                        foundTime = true;
                        hour2 = Integer.parseInt(matcher.group(1));
                        minute = Integer.parseInt(matcher.group(2));
                        second = Integer.parseInt(matcher.group(3));
                        continue;
                    }
                    if (!foundDayOfMonth && (matcher = DAY_OF_MONTH_PATTERN.matcher(content)).matches()) {
                        foundDayOfMonth = true;
                        day = Integer.parseInt(matcher.group(1));
                        continue;
                    }
                    if (!foundMonth && (matcher = MONTH_PATTERN.matcher(content)).matches()) {
                        foundMonth = true;
                        month2 = MONTHS.get(matcher.group(1).toLowerCase(Locale.ROOT));
                        continue;
                    }
                    if (foundYear || !(matcher = YEAR_PATTERN.matcher(content)).matches()) continue;
                    foundYear = true;
                    year2 = Integer.parseInt(matcher.group(1));
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException ignore) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        if (!(foundTime && foundDayOfMonth && foundMonth && foundYear)) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        if (year2 >= 70 && year2 <= 99) {
            year2 = 1900 + year2;
        }
        if (year2 >= 0 && year2 <= 69) {
            year2 = 2000 + year2;
        }
        if (day < 1 || day > 31 || year2 < 1601 || hour2 > 23 || minute > 59 || second > 59) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC);
        c.setTimeInMillis(0L);
        c.set(13, second);
        c.set(12, minute);
        c.set(11, hour2);
        c.set(5, day);
        c.set(2, month2);
        c.set(1, year2);
        cookie.setExpiryDate(c.getTime());
    }

    private void skipDelims(CharSequence buf, ParserCursor cursor) {
        char current2;
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo && DELIMS.get(current2 = buf.charAt(i2)); ++i2) {
            ++pos2;
        }
        cursor.updatePos(pos2);
    }

    private void copyContent(CharSequence buf, ParserCursor cursor, StringBuilder dst) {
        char current2;
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo && !DELIMS.get(current2 = buf.charAt(i2)); ++i2) {
            ++pos2;
            dst.append(current2);
        }
        cursor.updatePos(pos2);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }

    static {
        int b;
        UTC = TimeZone.getTimeZone("UTC");
        BitSet bitSet = new BitSet();
        bitSet.set(9);
        for (b = 32; b <= 47; ++b) {
            bitSet.set(b);
        }
        for (b = 59; b <= 64; ++b) {
            bitSet.set(b);
        }
        for (b = 91; b <= 96; ++b) {
            bitSet.set(b);
        }
        for (b = 123; b <= 126; ++b) {
            bitSet.set(b);
        }
        DELIMS = bitSet;
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>(12);
        map.put("jan", 0);
        map.put("feb", 1);
        map.put("mar", 2);
        map.put("apr", 3);
        map.put("may", 4);
        map.put("jun", 5);
        map.put("jul", 6);
        map.put("aug", 7);
        map.put("sep", 8);
        map.put("oct", 9);
        map.put("nov", 10);
        map.put("dec", 11);
        MONTHS = map;
        TIME_PATTERN = Pattern.compile("^([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})([^0-9].*)?$");
        DAY_OF_MONTH_PATTERN = Pattern.compile("^([0-9]{1,2})([^0-9].*)?$");
        MONTH_PATTERN = Pattern.compile("^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)(.*)?$", 2);
        YEAR_PATTERN = Pattern.compile("^([0-9]{2,4})([^0-9].*)?$");
    }
}

