/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jute.Index;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;

public class BinaryInputArchive
implements InputArchive {
    public static final String UNREASONBLE_LENGTH = "Unreasonable length = ";
    public static final int maxBuffer = Integer.getInteger("jute.maxbuffer", 1048575);
    private static final int extraMaxBuffer;
    private DataInput in;
    private int maxBufferSize;
    private int extraMaxBufferSize;

    public static BinaryInputArchive getArchive(InputStream strm) {
        return new BinaryInputArchive(new DataInputStream(strm));
    }

    public BinaryInputArchive(DataInput in) {
        this(in, maxBuffer, extraMaxBuffer);
    }

    public BinaryInputArchive(DataInput in, int maxBufferSize, int extraMaxBufferSize) {
        this.in = in;
        this.maxBufferSize = maxBufferSize;
        this.extraMaxBufferSize = extraMaxBufferSize;
    }

    @Override
    public byte readByte(String tag2) throws IOException {
        return this.in.readByte();
    }

    @Override
    public boolean readBool(String tag2) throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public int readInt(String tag2) throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong(String tag2) throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat(String tag2) throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble(String tag2) throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readString(String tag2) throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] b = new byte[len];
        this.in.readFully(b);
        return new String(b, "UTF8");
    }

    @Override
    public byte[] readBuffer(String tag2) throws IOException {
        int len = this.readInt(tag2);
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] arr = new byte[len];
        this.in.readFully(arr);
        return arr;
    }

    @Override
    public void readRecord(Record r, String tag2) throws IOException {
        r.deserialize(this, tag2);
    }

    @Override
    public void startRecord(String tag2) throws IOException {
    }

    @Override
    public void endRecord(String tag2) throws IOException {
    }

    @Override
    public Index startVector(String tag2) throws IOException {
        int len = this.readInt(tag2);
        if (len == -1) {
            return null;
        }
        return new BinaryIndex(len);
    }

    @Override
    public void endVector(String tag2) throws IOException {
    }

    @Override
    public Index startMap(String tag2) throws IOException {
        return new BinaryIndex(this.readInt(tag2));
    }

    @Override
    public void endMap(String tag2) throws IOException {
    }

    private void checkLength(int len) throws IOException {
        if (len < 0 || len > this.maxBufferSize + this.extraMaxBufferSize) {
            throw new IOException(UNREASONBLE_LENGTH + len);
        }
    }

    static {
        Integer configuredExtraMaxBuffer = Integer.getInteger("zookeeper.jute.maxbuffer.extrasize", maxBuffer);
        extraMaxBuffer = configuredExtraMaxBuffer < 1024 ? 1024 : configuredExtraMaxBuffer;
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        @Override
        public boolean done() {
            return this.nelems <= 0;
        }

        @Override
        public void incr() {
            --this.nelems;
        }
    }
}

