/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);

    public static void deleteRecursive(ZooKeeper zk, String pathRoot) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i2 = tree.size() - 1; i2 >= 0; --i2) {
            zk.delete(tree.get(i2), -1);
        }
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot, AsyncCallback.VoidCallback cb, Object ctx) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i2 = tree.size() - 1; i2 >= 0; --i2) {
            zk.delete(tree.get(i2), -1, cb, ctx);
        }
    }

    public static List<String> listSubTreeBFS(ZooKeeper zk, String pathRoot) throws KeeperException, InterruptedException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = zk.getChildren(node, false);
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    public static void visitSubTreeDFS(ZooKeeper zk, String path2, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        PathUtils.validatePath(path2);
        zk.getData(path2, watch, null);
        cb.processResult(KeeperException.Code.OK.intValue(), path2, null, path2);
        ZKUtil.visitSubTreeDFSHelper(zk, path2, watch, cb);
    }

    private static void visitSubTreeDFSHelper(ZooKeeper zk, String path2, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        boolean isRoot = path2.length() == 1;
        try {
            String childPath;
            List<String> children = zk.getChildren(path2, watch, null);
            Collections.sort(children);
            for (String child : children) {
                childPath = (isRoot ? path2 : path2 + "/") + child;
                cb.processResult(KeeperException.Code.OK.intValue(), childPath, null, child);
            }
            for (String child : children) {
                childPath = (isRoot ? path2 : path2 + "/") + child;
                ZKUtil.visitSubTreeDFSHelper(zk, childPath, watch, cb);
            }
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
    }
}

