/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.common.PathTrie;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.server.ReferenceCountedACLCache;
import org.apache.zookeeper.server.WatchManager;
import org.apache.zookeeper.server.WatchesPathReport;
import org.apache.zookeeper.server.WatchesReport;
import org.apache.zookeeper.server.WatchesSummary;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.txn.CheckVersionTxn;
import org.apache.zookeeper.txn.CreateContainerTxn;
import org.apache.zookeeper.txn.CreateTTLTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.MultiTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.Txn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTree {
    private static final Logger LOG = LoggerFactory.getLogger(DataTree.class);
    private final ConcurrentHashMap<String, DataNode> nodes = new ConcurrentHashMap();
    private final WatchManager dataWatches = new WatchManager();
    private final WatchManager childWatches = new WatchManager();
    private static final String rootZookeeper = "/";
    private static final String procZookeeper = "/zookeeper";
    private static final String procChildZookeeper = "/zookeeper".substring(1);
    private static final String quotaZookeeper = "/zookeeper/quota";
    private static final String quotaChildZookeeper = "/zookeeper/quota".substring("/zookeeper".length() + 1);
    private static final String configZookeeper = "/zookeeper/config";
    private static final String configChildZookeeper = "/zookeeper/config".substring("/zookeeper".length() + 1);
    private final PathTrie pTrie = new PathTrie();
    private final Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private final Set<String> containers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> ttls = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceCountedACLCache aclCache = new ReferenceCountedACLCache();
    private DataNode root = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode procDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode quotaDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Set<String> getContainers() {
        return new HashSet<String>(this.containers);
    }

    public Set<String> getTtls() {
        return new HashSet<String>(this.ttls);
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public DataNode getNode(String path2) {
        return this.nodes.get(path2);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public int getEphemeralsCount() {
        int result2 = 0;
        for (HashSet<String> set : this.ephemerals.values()) {
            result2 += set.size();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approximateDataSize() {
        long result2 = 0L;
        for (Map.Entry<String, DataNode> entry : this.nodes.entrySet()) {
            DataNode value2;
            DataNode dataNode = value2 = entry.getValue();
            synchronized (dataNode) {
                result2 += (long)entry.getKey().length();
                result2 += value2.getApproximateDataSize();
            }
        }
        return result2;
    }

    public DataTree() {
        this.nodes.put("", this.root);
        this.nodes.put(rootZookeeper, this.root);
        this.root.addChild(procChildZookeeper);
        this.nodes.put(procZookeeper, this.procDataNode);
        this.procDataNode.addChild(quotaChildZookeeper);
        this.nodes.put(quotaZookeeper, this.quotaDataNode);
        this.addConfigNode();
    }

    public void addConfigNode() {
        block5: {
            DataNode zookeeperZnode = this.nodes.get(procZookeeper);
            if (zookeeperZnode != null) {
                zookeeperZnode.addChild(configChildZookeeper);
            } else assert (false) : "There's no /zookeeper znode - this should never happen.";
            this.nodes.put(configZookeeper, new DataNode(new byte[0], -1L, new StatPersisted()));
            try {
                this.setACL(configZookeeper, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            }
            catch (KeeperException.NoNodeException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"There's no /zookeeper/config znode - this should never happen.");
            }
        }
    }

    boolean isSpecialPath(String path2) {
        return rootZookeeper.equals(path2) || procZookeeper.equals(path2) || quotaZookeeper.equals(path2) || configZookeeper.equals(path2);
    }

    public static void copyStatPersisted(StatPersisted from, StatPersisted to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCount(String lastPrefix, int diff) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node = this.nodes.get(statNode);
        StatsTrack updatedStat = null;
        if (node == null) {
            LOG.error("Missing count node for stat " + statNode);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node.data));
            updatedStat.setCount(updatedStat.getCount() + diff);
            node.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node = this.nodes.get(quotaNode);
        StatsTrack thisStats = null;
        if (node == null) {
            LOG.error("Missing count node for quota " + quotaNode);
            return;
        }
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node.data));
        }
        if (thisStats.getCount() > -1 && thisStats.getCount() < updatedStat.getCount()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " count=" + updatedStat.getCount() + " limit=" + thisStats.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(String lastPrefix, long diff) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node = this.nodes.get(statNode);
        if (node == null) {
            LOG.error("Missing stat node for bytes " + statNode);
            return;
        }
        StatsTrack updatedStat = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node.data));
            updatedStat.setBytes(updatedStat.getBytes() + diff);
            node.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node = this.nodes.get(quotaNode);
        if (node == null) {
            LOG.error("Missing quota node for bytes " + quotaNode);
            return;
        }
        StatsTrack thisStats = null;
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node.data));
        }
        if (thisStats.getBytes() > -1L && thisStats.getBytes() < updatedStat.getBytes()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " bytes=" + updatedStat.getBytes() + " limit=" + thisStats.getBytes());
        }
    }

    public void createNode(String path2, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        this.createNode(path2, data, acl, ephemeralOwner, parentCVersion, zxid, time, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNode(String path2, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time, Stat outputStat) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        String lastPrefix;
        int lastSlash = path2.lastIndexOf(47);
        String parentName = path2.substring(0, lastSlash);
        String childName = path2.substring(lastSlash + 1);
        StatPersisted stat2 = new StatPersisted();
        stat2.setCtime(time);
        stat2.setMtime(time);
        stat2.setCzxid(zxid);
        stat2.setMzxid(zxid);
        stat2.setPzxid(zxid);
        stat2.setVersion(0);
        stat2.setAversion(0);
        stat2.setEphemeralOwner(ephemeralOwner);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            Set<String> children = parent.getChildren();
            if (children.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            if (parentCVersion == -1) {
                parentCVersion = parent.stat.getCversion();
                ++parentCVersion;
            }
            parent.stat.setCversion(parentCVersion);
            parent.stat.setPzxid(zxid);
            Long longval = this.aclCache.convertAcls(acl);
            DataNode child = new DataNode(data, longval, stat2);
            parent.addChild(childName);
            this.nodes.put(path2, child);
            EphemeralType ephemeralType = EphemeralType.get(ephemeralOwner);
            if (ephemeralType == EphemeralType.CONTAINER) {
                this.containers.add(path2);
            } else if (ephemeralType == EphemeralType.TTL) {
                this.ttls.add(path2);
            } else if (ephemeralOwner != 0L) {
                HashSet<String> list2 = this.ephemerals.get(ephemeralOwner);
                if (list2 == null) {
                    list2 = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list2);
                }
                HashSet<String> hashSet = list2;
                synchronized (hashSet) {
                    list2.add(path2);
                }
            }
            if (outputStat != null) {
                child.copyStat(outputStat);
            }
        }
        if (parentName.startsWith(quotaZookeeper)) {
            if ("zookeeper_limits".equals(childName)) {
                this.pTrie.addPath(parentName.substring(quotaZookeeper.length()));
            }
            if ("zookeeper_stats".equals(childName)) {
                this.updateQuotaForPath(parentName.substring(quotaZookeeper.length()));
            }
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path2)) != null) {
            this.updateCount(lastPrefix, 1);
            this.updateBytes(lastPrefix, data == null ? 0L : (long)data.length);
        }
        this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path2, long zxid) throws KeeperException.NoNodeException {
        String lastPrefix;
        int lastSlash = path2.lastIndexOf(47);
        String parentName = path2.substring(0, lastSlash);
        String childName = path2.substring(lastSlash + 1);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            parent.removeChild(childName);
            if (zxid > parent.stat.getPzxid()) {
                parent.stat.setPzxid(zxid);
            }
        }
        DataNode node = this.nodes.get(path2);
        if (node == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path2);
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            this.aclCache.removeUsage(node.acl);
        }
        dataNode2 = parent;
        synchronized (dataNode2) {
            HashSet<String> nodes;
            long eowner = node.stat.getEphemeralOwner();
            EphemeralType ephemeralType = EphemeralType.get(eowner);
            if (ephemeralType == EphemeralType.CONTAINER) {
                this.containers.remove(path2);
            } else if (ephemeralType == EphemeralType.TTL) {
                this.ttls.remove(path2);
            } else if (eowner != 0L && (nodes = this.ephemerals.get(eowner)) != null) {
                HashSet<String> hashSet = nodes;
                synchronized (hashSet) {
                    nodes.remove(path2);
                }
            }
        }
        if (parentName.startsWith(procZookeeper) && "zookeeper_limits".equals(childName)) {
            this.pTrie.deletePath(parentName.substring(quotaZookeeper.length()));
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path2)) != null) {
            this.updateCount(lastPrefix, -1);
            int bytes2 = 0;
            DataNode dataNode3 = node;
            synchronized (dataNode3) {
                bytes2 = node.data == null ? 0 : -node.data.length;
            }
            this.updateBytes(lastPrefix, bytes2);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + path2);
            ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + parentName);
        }
        Set<Watcher> processed = this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch("".equals(parentName) ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path2, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
        Stat s2 = new Stat();
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        byte[] lastdata = null;
        DataNode dataNode = n;
        synchronized (dataNode) {
            lastdata = n.data;
            n.data = data;
            n.stat.setMtime(time);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s2);
        }
        String lastPrefix = this.getMaxPrefixWithQuota(path2);
        if (lastPrefix != null) {
            this.updateBytes(lastPrefix, (data == null ? 0 : data.length) - (lastdata == null ? 0 : lastdata.length));
        }
        this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDataChanged);
        return s2;
    }

    public String getMaxPrefixWithQuota(String path2) {
        String lastPrefix = this.pTrie.findMaxPrefix(path2);
        if (rootZookeeper.equals(lastPrefix) || "".equals(lastPrefix)) {
            return null;
        }
        return lastPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path2, Stat stat2, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat2);
            if (watcher != null) {
                this.dataWatches.addWatch(path2, watcher);
            }
            return n.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path2, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat2 = new Stat();
        DataNode n = this.nodes.get(path2);
        if (watcher != null) {
            this.dataWatches.addWatch(path2, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat2);
            return stat2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path2, Stat stat2, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            if (stat2 != null) {
                n.copyStat(stat2);
            }
            ArrayList<String> children = new ArrayList<String>(n.getChildren());
            if (watcher != null) {
                this.childWatches.addWatch(path2, watcher);
            }
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path2, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat2 = new Stat();
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            this.aclCache.removeUsage(n.acl);
            n.stat.setAversion(version);
            n.acl = this.aclCache.convertAcls(acl);
            n.copyStat(stat2);
            return stat2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path2, Stat stat2) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat2);
            return new ArrayList<ACL>(this.aclCache.convertLong(n.acl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(DataNode node) {
        DataNode dataNode = node;
        synchronized (dataNode) {
            return this.aclCache.convertLong(node.acl);
        }
    }

    public int aclCacheSize() {
        return this.aclCache.size();
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        return this.processTxn(header, txn, false);
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn, boolean isSubTxn) {
        ProcessTxnResult rc;
        block37: {
            rc = new ProcessTxnResult();
            try {
                rc.clientId = header.getClientId();
                rc.cxid = header.getCxid();
                rc.zxid = header.getZxid();
                rc.type = header.getType();
                rc.err = 0;
                rc.multiResult = null;
                switch (header.getType()) {
                    case 1: {
                        CreateTxn createTxn = (CreateTxn)txn;
                        rc.path = createTxn.getPath();
                        this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, createTxn.getParentCVersion(), header.getZxid(), header.getTime(), null);
                        break;
                    }
                    case 15: {
                        CreateTxn create2Txn = (CreateTxn)txn;
                        rc.path = create2Txn.getPath();
                        Stat stat2 = new Stat();
                        this.createNode(create2Txn.getPath(), create2Txn.getData(), create2Txn.getAcl(), create2Txn.getEphemeral() ? header.getClientId() : 0L, create2Txn.getParentCVersion(), header.getZxid(), header.getTime(), stat2);
                        rc.stat = stat2;
                        break;
                    }
                    case 21: {
                        CreateTTLTxn createTtlTxn = (CreateTTLTxn)txn;
                        rc.path = createTtlTxn.getPath();
                        Stat stat2 = new Stat();
                        this.createNode(createTtlTxn.getPath(), createTtlTxn.getData(), createTtlTxn.getAcl(), EphemeralType.TTL.toEphemeralOwner(createTtlTxn.getTtl()), createTtlTxn.getParentCVersion(), header.getZxid(), header.getTime(), stat2);
                        rc.stat = stat2;
                        break;
                    }
                    case 19: {
                        CreateContainerTxn createContainerTxn = (CreateContainerTxn)txn;
                        rc.path = createContainerTxn.getPath();
                        Stat stat2 = new Stat();
                        this.createNode(createContainerTxn.getPath(), createContainerTxn.getData(), createContainerTxn.getAcl(), Long.MIN_VALUE, createContainerTxn.getParentCVersion(), header.getZxid(), header.getTime(), stat2);
                        rc.stat = stat2;
                        break;
                    }
                    case 2: 
                    case 20: {
                        DeleteTxn deleteTxn = (DeleteTxn)txn;
                        rc.path = deleteTxn.getPath();
                        this.deleteNode(deleteTxn.getPath(), header.getZxid());
                        break;
                    }
                    case 5: 
                    case 16: {
                        SetDataTxn setDataTxn = (SetDataTxn)txn;
                        rc.path = setDataTxn.getPath();
                        rc.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 7: {
                        SetACLTxn setACLTxn = (SetACLTxn)txn;
                        rc.path = setACLTxn.getPath();
                        rc.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                        break;
                    }
                    case -11: {
                        this.killSession(header.getClientId(), header.getZxid());
                        break;
                    }
                    case -1: {
                        ErrorTxn errTxn = (ErrorTxn)txn;
                        rc.err = errTxn.getErr();
                        break;
                    }
                    case 13: {
                        CheckVersionTxn checkTxn = (CheckVersionTxn)txn;
                        rc.path = checkTxn.getPath();
                        break;
                    }
                    case 14: {
                        MultiTxn multiTxn = (MultiTxn)txn;
                        List<Txn> txns = multiTxn.getTxns();
                        rc.multiResult = new ArrayList<ProcessTxnResult>();
                        boolean failed2 = false;
                        for (Txn subtxn : txns) {
                            if (subtxn.getType() != -1) continue;
                            failed2 = true;
                            break;
                        }
                        boolean post_failed = false;
                        for (Txn subtxn : txns) {
                            ByteBuffer bb = ByteBuffer.wrap(subtxn.getData());
                            Record record = null;
                            switch (subtxn.getType()) {
                                case 1: {
                                    record = new CreateTxn();
                                    break;
                                }
                                case 21: {
                                    record = new CreateTTLTxn();
                                    break;
                                }
                                case 19: {
                                    record = new CreateContainerTxn();
                                    break;
                                }
                                case 2: 
                                case 20: {
                                    record = new DeleteTxn();
                                    break;
                                }
                                case 5: {
                                    record = new SetDataTxn();
                                    break;
                                }
                                case -1: {
                                    record = new ErrorTxn();
                                    post_failed = true;
                                    break;
                                }
                                case 13: {
                                    record = new CheckVersionTxn();
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of op: " + subtxn.getType());
                                }
                            }
                            assert (record != null);
                            ByteBufferInputStream.byteBuffer2Record(bb, record);
                            if (failed2 && subtxn.getType() != -1) {
                                int ec = post_failed ? KeeperException.Code.RUNTIMEINCONSISTENCY.intValue() : KeeperException.Code.OK.intValue();
                                subtxn.setType(-1);
                                record = new ErrorTxn(ec);
                            }
                            if (failed2) assert (subtxn.getType() == -1);
                            TxnHeader subHdr = new TxnHeader(header.getClientId(), header.getCxid(), header.getZxid(), header.getTime(), subtxn.getType());
                            ProcessTxnResult subRc = this.processTxn(subHdr, record, true);
                            rc.multiResult.add(subRc);
                            if (subRc.err == 0 || rc.err != 0) continue;
                            rc.err = subRc.err;
                        }
                        break;
                    }
                }
            }
            catch (KeeperException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed: " + header + ":" + txn, e);
                }
                rc.err = e.code().intValue();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block37;
                LOG.debug("Failed: " + header + ":" + txn, e);
            }
        }
        if (!isSubTxn && rc.zxid > this.lastProcessedZxid) {
            this.lastProcessedZxid = rc.zxid;
        }
        if (header.getType() == 1 && rc.err == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.debug("Adjusting parent cversion for Txn: " + header.getType() + " path:" + rc.path + " err: " + rc.err);
            int lastSlash = rc.path.lastIndexOf(47);
            String parentName = rc.path.substring(0, lastSlash);
            CreateTxn cTxn = (CreateTxn)txn;
            try {
                this.setCversionPzxid(parentName, cTxn.getParentCVersion(), header.getZxid());
            }
            catch (KeeperException.NoNodeException e) {
                LOG.error("Failed to set parent cversion for: " + parentName, e);
                rc.err = e.code().intValue();
            }
        } else if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr: " + header.getType() + " : error: " + rc.err);
        }
        return rc;
    }

    void killSession(long session, long zxid) {
        HashSet<String> list2 = this.ephemerals.remove(session);
        if (list2 != null) {
            for (String path2 : list2) {
                try {
                    this.deleteNode(path2, zxid);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Deleting ephemeral node " + path2 + " for session 0x" + Long.toHexString(session));
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.warn("Ignoring NoNodeException for path " + path2 + " while removing ephemeral for dead session 0x" + Long.toHexString(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCounts(String path2, Counts counts) {
        String[] node = this.getNode(path2);
        if (node == null) {
            return;
        }
        String[] children = null;
        int len = 0;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
            len = node.data == null ? 0 : node.data.length;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            ++counts.count;
            counts.bytes += (long)len;
            for (String child : children) {
                this.getCounts(path2 + rootZookeeper + child, counts);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuotaForPath(String path2) {
        Counts c = new Counts();
        this.getCounts(path2, c);
        StatsTrack strack = new StatsTrack();
        strack.setBytes(c.bytes);
        strack.setCount(c.count);
        String statPath = quotaZookeeper + path2 + rootZookeeper + "zookeeper_stats";
        DataNode node = this.getNode(statPath);
        if (node == null) {
            LOG.warn("Missing quota stat node " + statPath);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            node.data = strack.toString().getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseNode(String path2) {
        String[] node = this.getNode(path2);
        String[] children = null;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (children.length == 0) {
                String endString = "/zookeeper_limits";
                if (path2.endsWith(endString)) {
                    String realPath = path2.substring(quotaZookeeper.length(), path2.indexOf(endString));
                    this.updateQuotaForPath(realPath);
                    this.pTrie.addPath(realPath);
                }
                return;
            }
            for (String child : children) {
                this.traverseNode(path2 + rootZookeeper + child);
            }
            return;
        }
    }

    private void setupQuota() {
        String quotaPath = quotaZookeeper;
        DataNode node = this.getNode(quotaPath);
        if (node == null) {
            return;
        }
        this.traverseNode(quotaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path2) throws IOException {
        DataNode nodeCopy;
        String pathString = path2.toString();
        DataNode node = this.getNode(pathString);
        if (node == null) {
            return;
        }
        String[] children = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            StatPersisted statCopy = new StatPersisted();
            DataTree.copyStatPersisted(node.stat, statCopy);
            nodeCopy = new DataNode(node.data, node.acl, statCopy);
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
        }
        this.serializeNodeData(oa, pathString, nodeCopy);
        path2.append('/');
        int off = path2.length();
        for (String child : children) {
            path2.delete(off, Integer.MAX_VALUE);
            path2.append(child);
            this.serializeNode(oa, path2);
        }
    }

    public void serializeNodeData(OutputArchive oa, String path2, DataNode node) throws IOException {
        oa.writeString(path2, "path");
        oa.writeRecord(node, "node");
    }

    public void serialize(OutputArchive oa, String tag2) throws IOException {
        this.aclCache.serialize(oa);
        this.serializeNode(oa, new StringBuilder(""));
        if (this.root != null) {
            oa.writeString(rootZookeeper, "path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(InputArchive ia, String tag2) throws IOException {
        this.aclCache.deserialize(ia);
        this.nodes.clear();
        this.pTrie.clear();
        String path2 = ia.readString("path");
        while (!rootZookeeper.equals(path2)) {
            DataNode node = new DataNode();
            ia.readRecord(node, "node");
            this.nodes.put(path2, node);
            DataNode dataNode = node;
            synchronized (dataNode) {
                this.aclCache.addUsage(node.acl);
            }
            int lastSlash = path2.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node;
            } else {
                String parentPath = path2.substring(0, lastSlash);
                DataNode parent = this.nodes.get(parentPath);
                if (parent == null) {
                    throw new IOException("Invalid Datatree, unable to find parent " + parentPath + " of path " + path2);
                }
                parent.addChild(path2.substring(lastSlash + 1));
                long eowner = node.stat.getEphemeralOwner();
                EphemeralType ephemeralType = EphemeralType.get(eowner);
                if (ephemeralType == EphemeralType.CONTAINER) {
                    this.containers.add(path2);
                } else if (ephemeralType == EphemeralType.TTL) {
                    this.ttls.add(path2);
                } else if (eowner != 0L) {
                    HashSet<String> list2 = this.ephemerals.get(eowner);
                    if (list2 == null) {
                        list2 = new HashSet();
                        this.ephemerals.put(eowner, list2);
                    }
                    list2.add(path2);
                }
            }
            path2 = ia.readString("path");
        }
        this.nodes.put(rootZookeeper, this.root);
        this.setupQuota();
        this.aclCache.purgeUnused();
    }

    public synchronized void dumpWatchesSummary(PrintWriter pwriter) {
        pwriter.print(this.dataWatches.toString());
    }

    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        this.dataWatches.dumpWatches(pwriter, byPath);
    }

    public synchronized WatchesReport getWatches() {
        return this.dataWatches.getWatches();
    }

    public synchronized WatchesPathReport getWatchesByPath() {
        return this.dataWatches.getWatchesByPath();
    }

    public synchronized WatchesSummary getWatchesSummary() {
        return this.dataWatches.getWatchesSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEphemerals(PrintWriter pwriter) {
        pwriter.println("Sessions with Ephemerals (" + this.ephemerals.keySet().size() + "):");
        for (Map.Entry<Long, HashSet<String>> entry : this.ephemerals.entrySet()) {
            pwriter.print("0x" + Long.toHexString(entry.getKey()));
            pwriter.println(":");
            HashSet<String> tmp = entry.getValue();
            if (tmp == null) continue;
            HashSet<String> hashSet = tmp;
            synchronized (hashSet) {
                for (String path2 : tmp) {
                    pwriter.println("\t" + path2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Set<String>> getEphemerals() {
        HashMap<Long, Set<String>> ephemeralsCopy = new HashMap<Long, Set<String>>();
        for (Map.Entry<Long, HashSet<String>> e : this.ephemerals.entrySet()) {
            HashSet<String> hashSet = e.getValue();
            synchronized (hashSet) {
                ephemeralsCopy.put(e.getKey(), new HashSet(e.getValue()));
            }
        }
        return ephemeralsCopy;
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        DataNode node;
        for (String path2 : dataWatches) {
            node = this.getNode(path2);
            Object e = null;
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            if (node.stat.getMzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.dataWatches.addWatch(path2, watcher);
        }
        for (String path2 : existWatches) {
            node = this.getNode(path2);
            if (node != null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.dataWatches.addWatch(path2, watcher);
        }
        for (String path2 : childWatches) {
            node = this.getNode(path2);
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            if (node.stat.getPzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.childWatches.addWatch(path2, watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCversionPzxid(String path2, int newCversion, long zxid) throws KeeperException.NoNodeException {
        DataNode node;
        if (path2.endsWith(rootZookeeper)) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        if ((node = this.nodes.get(path2)) == null) {
            throw new KeeperException.NoNodeException(path2);
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            if (newCversion == -1) {
                newCversion = node.stat.getCversion() + 1;
            }
            if (newCversion > node.stat.getCversion()) {
                node.stat.setCversion(newCversion);
                node.stat.setPzxid(zxid);
            }
        }
    }

    public boolean containsWatcher(String path2, Watcher.WatcherType type2, Watcher watcher) {
        boolean containsWatcher = false;
        switch (type2) {
            case Children: {
                containsWatcher = this.childWatches.containsWatcher(path2, watcher);
                break;
            }
            case Data: {
                containsWatcher = this.dataWatches.containsWatcher(path2, watcher);
                break;
            }
            case Any: {
                if (this.childWatches.containsWatcher(path2, watcher)) {
                    containsWatcher = true;
                }
                if (!this.dataWatches.containsWatcher(path2, watcher)) break;
                containsWatcher = true;
            }
        }
        return containsWatcher;
    }

    public boolean removeWatch(String path2, Watcher.WatcherType type2, Watcher watcher) {
        boolean removed = false;
        switch (type2) {
            case Children: {
                removed = this.childWatches.removeWatcher(path2, watcher);
                break;
            }
            case Data: {
                removed = this.dataWatches.removeWatcher(path2, watcher);
                break;
            }
            case Any: {
                if (this.childWatches.removeWatcher(path2, watcher)) {
                    removed = true;
                }
                if (!this.dataWatches.removeWatcher(path2, watcher)) break;
                removed = true;
            }
        }
        return removed;
    }

    public ReferenceCountedACLCache getReferenceCountedAclCache() {
        return this.aclCache;
    }

    private static class Counts {
        long bytes;
        int count;

        private Counts() {
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;
        public List<ProcessTxnResult> multiResult;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

