/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DigestAuthenticationProvider.class);
    private static final String superDigest = System.getProperty("zookeeper.DigestAuthenticationProvider.superDigest");

    @Override
    public String getScheme() {
        return "digest";
    }

    private static final String base64Encode(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < b.length) {
            int pad = 0;
            int v = (b[i2++] & 0xFF) << 16;
            if (i2 < b.length) {
                v |= (b[i2++] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i2 < b.length) {
                v |= b[i2++] & 0xFF;
            } else {
                ++pad;
            }
            sb.append(DigestAuthenticationProvider.encode(v >> 18));
            sb.append(DigestAuthenticationProvider.encode(v >> 12));
            if (pad < 2) {
                sb.append(DigestAuthenticationProvider.encode(v >> 6));
            } else {
                sb.append('=');
            }
            if (pad < 1) {
                sb.append(DigestAuthenticationProvider.encode(v));
                continue;
            }
            sb.append('=');
        }
        return sb.toString();
    }

    private static final char encode(int i2) {
        if ((i2 &= 0x3F) < 26) {
            return (char)(65 + i2);
        }
        if (i2 < 52) {
            return (char)(97 + i2 - 26);
        }
        if (i2 < 62) {
            return (char)(48 + i2 - 52);
        }
        return i2 == 62 ? (char)'+' : '/';
    }

    public static String generateDigest(String idPassword) throws NoSuchAlgorithmException {
        String[] parts = idPassword.split(":", 2);
        byte[] digest2 = MessageDigest.getInstance("SHA1").digest(idPassword.getBytes());
        return parts[0] + ":" + DigestAuthenticationProvider.base64Encode(digest2);
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        String id2 = new String(authData);
        try {
            String digest2 = DigestAuthenticationProvider.generateDigest(id2);
            if (digest2.equals(superDigest)) {
                cnxn.addAuthInfo(new Id("super", ""));
            }
            cnxn.addAuthInfo(new Id(this.getScheme(), digest2));
            return KeeperException.Code.OK;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Missing algorithm", e);
            return KeeperException.Code.AUTHFAILED;
        }
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id2) {
        String[] parts = id2.split(":");
        return parts.length == 2;
    }

    @Override
    public boolean matches(String id2, String aclExpr) {
        return id2.equals(aclExpr);
    }

    public static void main(String[] args2) throws NoSuchAlgorithmException {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            System.out.println(args2[i2] + "->" + DigestAuthenticationProvider.generateDigest(args2[i2]));
        }
    }
}

