/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketImpl;

public class PrependableSocket
extends Socket {
    private PushbackInputStream pushbackInputStream;

    public PrependableSocket(SocketImpl base) throws IOException {
        super(base);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.pushbackInputStream == null) {
            return super.getInputStream();
        }
        return this.pushbackInputStream;
    }

    public void prependToInputStream(byte[] bytes2, int offset2, int length2) throws IOException {
        if (length2 == 0) {
            return;
        }
        if (this.pushbackInputStream != null) {
            throw new IOException("prependToInputStream() called more than once");
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(this.getInputStream(), length2);
        pushbackInputStream.unread(bytes2, offset2, length2);
        this.pushbackInputStream = pushbackInputStream;
    }
}

