/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;

@JRubyClass(name={"Encoding"})
public class RubyEncoding
extends RubyObject {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final ByteList LOCALE = ByteList.create("locale");
    public static final ByteList EXTERNAL = ByteList.create("external");
    private Encoding encoding;
    private final ByteList name;
    private final boolean isDummy;
    private static final ThreadLocal<SoftReference<UTF8Coder>> UTF8_CODER = new ThreadLocal();

    public static RubyClass createEncodingClass(Ruby runtime2) {
        RubyClass encodingc = runtime2.defineClass("Encoding", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setEncoding(encodingc);
        encodingc.index = 22;
        encodingc.setReifiedClass(RubyEncoding.class);
        encodingc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyEncoding;
            }
        };
        encodingc.getSingletonClass().undefineMethod("allocate");
        encodingc.defineAnnotatedMethods(RubyEncoding.class);
        return encodingc;
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        super(runtime2, runtime2.getEncoding());
        this.name = new ByteList(name2, p2, end2);
        this.isDummy = isDummy;
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, boolean isDummy) {
        this(runtime2, name2, 0, name2.length, isDummy);
    }

    private RubyEncoding(Ruby runtime2, Encoding encoding2) {
        super(runtime2, runtime2.getEncoding());
        this.name = new ByteList(encoding2.getName());
        this.isDummy = false;
        this.encoding = encoding2;
    }

    public static RubyEncoding newEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        return new RubyEncoding(runtime2, name2, p2, end2, isDummy);
    }

    public static RubyEncoding newEncoding(Ruby runtime2, byte[] name2, boolean isDummy) {
        return new RubyEncoding(runtime2, name2, isDummy);
    }

    public static RubyEncoding newEncoding(Ruby runtime2, Encoding encoding2) {
        return new RubyEncoding(runtime2, encoding2);
    }

    public final Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getRuntime().getEncodingService().loadEncoding(this.name);
        }
        return this.encoding;
    }

    public static Encoding areCompatible(IRubyObject obj1, IRubyObject obj2) {
        if (obj1 instanceof EncodingCapable && obj2 instanceof EncodingCapable) {
            Encoding enc2;
            Encoding enc1 = ((EncodingCapable)((Object)obj1)).getEncoding();
            if (enc1 == (enc2 = ((EncodingCapable)((Object)obj2)).getEncoding())) {
                return enc1;
            }
            if (obj2 instanceof RubyString && ((RubyString)obj2).getByteList().getRealSize() == 0) {
                return enc1;
            }
            if (obj1 instanceof RubyString && ((RubyString)obj1).getByteList().getRealSize() == 0) {
                return enc2;
            }
            if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
                return null;
            }
            if (!(obj2 instanceof RubyString) && enc2 instanceof USASCIIEncoding) {
                return enc1;
            }
            if (!(obj1 instanceof RubyString) && enc1 instanceof USASCIIEncoding) {
                return enc2;
            }
            if (!(obj1 instanceof RubyString)) {
                IRubyObject objTmp = obj1;
                obj1 = obj2;
                obj1 = objTmp;
                Encoding encTmp = enc1;
                enc1 = enc2;
                enc2 = encTmp;
            }
            if (obj1 instanceof RubyString) {
                int cr1 = ((RubyString)obj1).scanForCodeRange();
                if (obj2 instanceof RubyString) {
                    int cr2 = ((RubyString)obj2).scanForCodeRange();
                    return RubyEncoding.areCompatible(enc1, cr1, enc2, cr2);
                }
                if (cr1 == 32) {
                    return enc2;
                }
            }
        }
        return null;
    }

    static Encoding areCompatible(Encoding enc1, int cr1, Encoding enc2, int cr2) {
        if (cr1 != cr2) {
            if (cr1 == 32) {
                return enc2;
            }
            if (cr2 == 32) {
                return enc1;
            }
        }
        if (cr2 == 32) {
            if (enc1 instanceof ASCIIEncoding) {
                return enc2;
            }
            return enc1;
        }
        if (cr1 == 32) {
            return enc2;
        }
        return null;
    }

    public static byte[] encodeUTF8(CharSequence cs) {
        return RubyEncoding.getUTF8Coder().encode(cs);
    }

    public static byte[] encodeUTF8(String str) {
        return RubyEncoding.getUTF8Coder().encode(str);
    }

    public static byte[] encode(CharSequence cs, Charset charset) {
        ByteBuffer buffer = charset.encode(((Object)cs).toString());
        byte[] bytes2 = new byte[buffer.limit()];
        buffer.get(bytes2);
        return bytes2;
    }

    public static byte[] encode(String str, Charset charset) {
        ByteBuffer buffer = charset.encode(str);
        byte[] bytes2 = new byte[buffer.limit()];
        buffer.get(bytes2);
        return bytes2;
    }

    public static String decodeUTF8(byte[] bytes2, int start2, int length2) {
        return RubyEncoding.getUTF8Coder().decode(bytes2, start2, length2);
    }

    public static String decodeUTF8(byte[] bytes2) {
        return RubyEncoding.getUTF8Coder().decode(bytes2);
    }

    public static String decode(byte[] bytes2, int start2, int length2, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes2, start2, length2)).toString();
    }

    public static String decode(byte[] bytes2, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes2)).toString();
    }

    private static UTF8Coder getUTF8Coder() {
        UTF8Coder coder;
        SoftReference<UTF8Coder> ref = UTF8_CODER.get();
        if (ref == null || (coder = ref.get()) == null) {
            coder = new UTF8Coder();
            ref = new SoftReference<UTF8Coder>(coder);
            UTF8_CODER.set(ref);
        }
        return coder;
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        return RubyArray.newArrayNoCopy(runtime2, runtime2.getEncodingService().getEncodingList(), 0);
    }

    @JRubyMethod(name={"locale_charmap"}, meta=true)
    public static IRubyObject locale_charmap(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        ByteList name2 = new ByteList(service.getLocaleEncoding().getName());
        return RubyString.newUsAsciiStringNoCopy(runtime2, name2);
    }

    @JRubyMethod(name={"name_list"}, meta=true)
    public static IRubyObject name_list(ThreadContext context, IRubyObject recv2) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        RubyArray result2 = runtime2.newArray(service.getEncodings().size() + service.getAliases().size());
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getEncodings().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i2 = service.getAliases().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        result2.append(runtime2.newString(EXTERNAL));
        result2.append(runtime2.newString(LOCALE));
        return result2;
    }

    @JRubyMethod(name={"aliases"}, meta=true)
    public static IRubyObject aliases(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        IRubyObject[] list2 = service.getEncodingList();
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getAliases().entryIterator();
        RubyHash result2 = RubyHash.newHash(runtime2);
        while (i2.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            IRubyObject alias2 = RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context);
            IRubyObject name2 = RubyString.newUsAsciiStringShared(runtime2, ((RubyEncoding)list2[((EncodingDB.Entry)e.value).getIndex()]).name).freeze(context);
            result2.fastASet(alias2, name2);
        }
        result2.fastASet(runtime2.newString(EXTERNAL), runtime2.newString(new ByteList(runtime2.getDefaultExternalEncoding().getName())));
        result2.fastASet(runtime2.newString(LOCALE), runtime2.newString(new ByteList(service.getLocaleEncoding().getName())));
        return result2;
    }

    @JRubyMethod(name={"find"}, meta=true)
    public static IRubyObject find(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (str instanceof RubyEncoding) {
            return str;
        }
        return runtime2.getEncodingService().rubyEncodingFromObject(str);
    }

    @JRubyMethod(name={"_dump"})
    public IRubyObject _dump(ThreadContext context, IRubyObject arg2) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static IRubyObject _load(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyEncoding.find(context, recv2, str);
    }

    @JRubyMethod(name={"ascii_compatible?"})
    public IRubyObject asciiCompatible_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getEncoding().isAsciiCompatible());
    }

    @JRubyMethod(name={"to_s", "name"})
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newUsAsciiStringShared(context.getRuntime(), this.name);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        ByteList bytes2 = new ByteList();
        bytes2.append("#<Encoding:".getBytes());
        bytes2.append(this.name);
        if (this.isDummy) {
            bytes2.append(" (dummy)".getBytes());
        }
        bytes2.append(62);
        return RubyString.newUsAsciiStringNoCopy(context.getRuntime(), bytes2);
    }

    @JRubyMethod(name={"names"})
    public IRubyObject names(ThreadContext context) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        EncodingDB.Entry entry = service.findEncodingOrAliasEntry(this.name);
        RubyArray result2 = runtime2.newArray();
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getEncodings().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            if (e.value != entry) continue;
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i2 = service.getAliases().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            if (e.value != entry) continue;
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        result2.append(runtime2.newString(EXTERNAL));
        result2.append(runtime2.newString(LOCALE));
        return result2;
    }

    @JRubyMethod(name={"dummy?"})
    public IRubyObject dummy_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isDummy);
    }

    @JRubyMethod(name={"compatible?"}, meta=true)
    public static IRubyObject compatible_p(ThreadContext context, IRubyObject self, IRubyObject first2, IRubyObject second) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = RubyEncoding.areCompatible(first2, second);
        return enc == null ? runtime2.getNil() : runtime2.getEncodingService().getEncoding(enc);
    }

    @JRubyMethod(name={"default_external"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject getDefaultExternal(IRubyObject recv2) {
        return recv2.getRuntime().getEncodingService().getDefaultExternal();
    }

    @JRubyMethod(name={"default_external="}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setDefaultExternal(IRubyObject recv2, IRubyObject encoding2) {
        Ruby runtime2 = recv2.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        if (encoding2.isNil()) {
            throw recv2.getRuntime().newArgumentError("default_external can not be nil");
        }
        runtime2.setDefaultExternalEncoding(service.getEncodingFromObject(encoding2));
        return encoding2;
    }

    @JRubyMethod(name={"default_internal"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject getDefaultInternal(IRubyObject recv2) {
        return recv2.getRuntime().getEncodingService().getDefaultInternal();
    }

    @JRubyMethod(name={"default_internal="}, required=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setDefaultInternal(IRubyObject recv2, IRubyObject encoding2) {
        Ruby runtime2 = recv2.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        if (encoding2.isNil()) {
            recv2.getRuntime().newArgumentError("default_internal can not be nil");
        }
        recv2.getRuntime().setDefaultInternalEncoding(service.getEncodingFromObject(encoding2));
        return encoding2;
    }

    @Deprecated
    public static IRubyObject getDefaultExternal(Ruby runtime2) {
        return runtime2.getEncodingService().getDefaultExternal();
    }

    @Deprecated
    public static IRubyObject getDefaultInternal(Ruby runtime2) {
        return runtime2.getEncodingService().getDefaultInternal();
    }

    @Deprecated
    public static IRubyObject convertEncodingToRubyEncoding(Ruby runtime2, Encoding defaultEncoding) {
        return runtime2.getEncodingService().convertEncodingToRubyEncoding(defaultEncoding);
    }

    @Deprecated
    public static Encoding getEncodingFromObject(Ruby runtime2, IRubyObject arg2) {
        return runtime2.getEncodingService().getEncodingFromObject(arg2);
    }

    private static class UTF8Coder {
        private final CharsetEncoder encoder = UTF8.newEncoder();
        private final CharsetDecoder decoder = UTF8.newDecoder();
        private static final int CHAR_THRESHOLD = 1024;
        private static final int BUF_SIZE = 4096;
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        private final CharBuffer charBuffer = CharBuffer.allocate(4096);

        public UTF8Coder() {
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        }

        public byte[] encode(CharSequence cs) {
            ByteBuffer buffer;
            if (cs.length() > 1024) {
                buffer = UTF8.encode(((Object)cs).toString());
            } else {
                buffer = this.byteBuffer;
                CharBuffer cbuffer = this.charBuffer;
                buffer.clear();
                cbuffer.clear();
                cbuffer.put(((Object)cs).toString());
                cbuffer.flip();
                this.encoder.encode(cbuffer, buffer, true);
                buffer.flip();
            }
            byte[] bytes2 = new byte[buffer.limit()];
            buffer.get(bytes2);
            return bytes2;
        }

        public String decode(byte[] bytes2, int start2, int length2) {
            CharBuffer cbuffer;
            if (length2 > 1024) {
                cbuffer = UTF8.decode(ByteBuffer.wrap(bytes2, start2, length2));
            } else {
                cbuffer = this.charBuffer;
                ByteBuffer buffer = this.byteBuffer;
                cbuffer.clear();
                buffer.clear();
                buffer.put(bytes2, start2, length2);
                buffer.flip();
                this.decoder.decode(buffer, cbuffer, true);
                cbuffer.flip();
            }
            return cbuffer.toString();
        }

        public String decode(byte[] bytes2) {
            return this.decode(bytes2, 0, bytes2.length);
        }
    }
}

