/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRLoop;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScopeImpl;
import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReceiveClosureInstr;
import org.jruby.compiler.ir.instructions.RubyInternalCallInstr;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.parser.StaticScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IRExecutionScope
extends IRScopeImpl {
    private List<Instr> instructions;
    private CFG cfg;
    private List<IRClosure> closures;
    private boolean canCaptureCallersBinding;
    private boolean canModifyCode;
    private boolean requiresBinding;
    private Stack<IRLoop> loopStack;
    protected int requiredArgs = 0;
    protected int optionalArgs = 0;
    protected int restArg = -1;

    private void init() {
        this.instructions = new ArrayList<Instr>();
        this.closures = new ArrayList<IRClosure>();
        this.loopStack = new Stack();
        this.canModifyCode = true;
        this.canCaptureCallersBinding = true;
        this.requiresBinding = true;
    }

    public IRExecutionScope(IRScope lexicalParent, Operand container, String name2, StaticScope staticScope) {
        super(lexicalParent, container, name2, staticScope);
        this.init();
    }

    public void addClosure(IRClosure c) {
        this.closures.add(c);
    }

    @Override
    public void addInstr(Instr i2) {
        this.instructions.add(i2);
    }

    public void startLoop(IRLoop l) {
        this.loopStack.push(l);
    }

    public void endLoop(IRLoop l) {
        this.loopStack.pop();
    }

    public IRLoop getCurrentLoop() {
        return this.loopStack.isEmpty() ? null : this.loopStack.peek();
    }

    public List<IRClosure> getClosures() {
        return this.closures;
    }

    @Override
    public List<Instr> getInstrs() {
        return this.instructions;
    }

    public IRMethod getClosestMethodAncestor() {
        IRExecutionScope s2 = this;
        while (!(s2 instanceof IRMethod)) {
            s2 = (IRExecutionScope)s2.getLexicalParent();
        }
        return (IRMethod)s2;
    }

    public void setCodeModificationFlag(boolean f) {
        this.canModifyCode = f;
    }

    public boolean modifiesCode() {
        return this.canModifyCode;
    }

    public boolean requiresBinding() {
        return this.requiresBinding;
    }

    public boolean canCaptureCallersBinding() {
        return this.canCaptureCallersBinding;
    }

    public CFG buildCFG() {
        this.cfg = new CFG(this);
        this.cfg.build(this.instructions);
        return this.cfg;
    }

    public CFG getCFG() {
        return this.cfg;
    }

    @Override
    public void runCompilerPassOnNestedScopes(CompilerPass p2) {
    }

    public void computeExecutionScopeFlags() {
        this.canModifyCode = true;
        this.canCaptureCallersBinding = false;
        this.requiresBinding = false;
        boolean receivesClosureArg = false;
        for (Instr i2 : this.getInstrs()) {
            if (i2 instanceof ReceiveClosureInstr) {
                receivesClosureArg = true;
            }
            if (i2 instanceof RubyInternalCallInstr && ((CallInstr)i2).getMethodAddr() == MethAddr.ZSUPER) {
                this.canCaptureCallersBinding = true;
            }
            if (!(i2 instanceof CallInstr)) continue;
            CallInstr call2 = (CallInstr)i2;
            if (call2.requiresBinding()) {
                this.requiresBinding = true;
            }
            if (!receivesClosureArg || !call2.canBeEval() || call2.getCallArgs().length <= 1) continue;
            this.canCaptureCallersBinding = true;
        }
    }

    @Override
    public String toStringInstrs() {
        StringBuilder b = new StringBuilder();
        int i2 = 0;
        for (Instr instr : this.instructions) {
            if (i2 > 0) {
                b.append("\n");
            }
            b.append("  ").append(i2).append('\t').append(instr);
            ++i2;
        }
        if (!this.closures.isEmpty()) {
            b.append("\n\n------ Closures encountered in this scope ------\n");
            for (IRClosure c : this.closures) {
                b.append(c.toStringBody());
            }
            b.append("------------------------------------------------\n");
        }
        return b.toString();
    }

    @Override
    public String toStringVariables() {
        HashMap<Variable, Integer> ends = new HashMap<Variable, Integer>();
        HashMap<Variable, Integer> starts = new HashMap<Variable, Integer>();
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (int i2 = this.instructions.size() - 1; i2 >= 0; --i2) {
            Instr instr = this.instructions.get(i2);
            Variable var = instr.result;
            if (var != null) {
                variables.add(var);
                starts.put(var, i2);
            }
            for (Operand operand : instr.getOperands()) {
                if (operand == null || !(operand instanceof Variable) || ends.get((Variable)operand) != null) continue;
                ends.put((Variable)operand, i2);
                variables.add((Variable)operand);
            }
        }
        StringBuilder sb = new StringBuilder();
        int i3 = 0;
        for (Variable var : variables) {
            Integer end2 = (Integer)ends.get(var);
            if (end2 == null) continue;
            if (i3 > 0) {
                sb.append("\n");
            }
            ++i3;
            sb.append("    " + var + ": " + starts.get(var) + "-" + end2);
        }
        return sb.toString();
    }

    @Interp
    public Iterator<LocalVariable> getLiveLocalVariables() {
        HashMap<LocalVariable, Integer> ends = new HashMap<LocalVariable, Integer>();
        HashMap<LocalVariable, Integer> starts = new HashMap<LocalVariable, Integer>();
        TreeSet<LocalVariable> variables = new TreeSet<LocalVariable>();
        for (int i2 = this.instructions.size() - 1; i2 >= 0; --i2) {
            Instr instr = this.instructions.get(i2);
            Variable variable = instr.result;
            if (variable != null && variable instanceof LocalVariable) {
                variables.add((LocalVariable)variable);
                starts.put((LocalVariable)variable, i2);
            }
            for (Operand operand : instr.getOperands()) {
                if (!(operand instanceof LocalVariable) || ends.get((LocalVariable)(variable = (LocalVariable)operand)) != null) continue;
                ends.put((LocalVariable)variable, i2);
                variables.add((LocalVariable)variable);
            }
        }
        return variables.iterator();
    }

    @Interp
    public StaticScope allocateStaticScope(StaticScope parent) {
        Iterator<LocalVariable> variables = this.getLiveLocalVariables();
        StaticScope scope = this.constructStaticScope(parent);
        while (variables.hasNext()) {
            LocalVariable variable = variables.next();
            int destination = scope.addVariable(variable.getName());
            System.out.println("Allocating " + variable + " to " + destination);
            variable.setLocation(destination);
        }
        return scope;
    }

    @Interp
    public void calculateParameterCounts() {
        for (int i2 = this.instructions.size() - 1; i2 >= 0; --i2) {
            Instr instr = this.instructions.get(i2);
        }
    }

    @Interp
    protected abstract StaticScope constructStaticScope(StaticScope var1);

    public Variable getSelf() {
        return this.getLocalVariable("%self");
    }

    @Override
    public LocalVariable getLocalVariable(String name2) {
        return this.getClosestMethodAncestor().getLocalVariable(name2);
    }

    public int getLocalVariablesCount() {
        return this.getClosestMethodAncestor().getLocalVariablesCount();
    }
}

