/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -6194634312533310816L;
    private final Token master;
    private final int lineNumber;
    private final int startPosition;
    private Node parent = null;
    private LinkedList<Node> children = new LinkedList();

    public Node(Token master, int lineNumber, int startPosition) {
        this.master = master;
        this.lineNumber = lineNumber;
        this.startPosition = startPosition;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Token getMaster() {
        return this.master;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public LinkedList<Node> getChildren() {
        return this.children;
    }

    public void setChildren(LinkedList<Node> children) {
        this.children = children;
    }

    public String reconstructImage() {
        return this.master.getImage();
    }

    public TokenScannerSymbols getSymbols() {
        return this.master.getSymbols();
    }

    public abstract OutputNode render(JinjavaInterpreter var1);

    public abstract String getName();

    public String toTreeString() {
        return this.toTreeString(0);
    }

    public String toTreeString(int level) {
        String prefix = StringUtils.repeat(" ", level * 4) + " ";
        StringBuilder t2 = new StringBuilder(prefix).append(this.toString()).append('\n');
        for (Node n : this.getChildren()) {
            t2.append(n.toTreeString(level + 1));
        }
        if (this.getChildren().size() > 0) {
            t2.append(prefix).append("end :: ").append(this.toString()).append('\n');
        }
        return t2.toString();
    }
}

