/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.commons;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.submarine.commons.SubmarineUI;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(SubmarineUI.class);

    public static String unifyKey(String key) {
        key = key.replace(".", "_").toUpperCase();
        return key;
    }

    public static String getJobName(String userName, String noteId) throws RuntimeException {
        userName = userName.toLowerCase();
        userName = userName.replace("_", "-");
        userName = userName.replace(".", "-");
        noteId = noteId.toLowerCase();
        noteId = noteId.replace("_", "-");
        noteId = noteId.replace(".", "-");
        String jobName = userName + "-" + noteId;
        String yarnAppPatternString = "[a-z][a-z0-9-]*";
        Pattern pattern = Pattern.compile(yarnAppPatternString);
        Matcher matcher = pattern.matcher(jobName);
        boolean matches = matcher.matches();
        if (!matches) {
            throw new RuntimeException("Job Name(`noteName`-`noteId`) does not matcher the `[a-z][a-z0-9-]*` Pattern!");
        }
        if (jobName.length() > 30) {
            throw new RuntimeException("Job Name can not be greater than 30 characters");
        }
        return jobName;
    }

    public static String getTensorboardName(String user) {
        return user.toLowerCase() + "-tb";
    }

    public static String getAgulObjValue(InterpreterContext context, String name) {
        String value = "";
        AngularObject angularObject = context.getAngularObjectRegistry().get(name, context.getNoteId(), context.getParagraphId());
        if (null != angularObject && null != angularObject.get()) {
            value = angularObject.get().toString();
        }
        return value;
    }

    public static void setAgulObjValue(InterpreterContext context, String name, Object value) {
        AngularObject angularObject = context.getAngularObjectRegistry().add(name, value, context.getNoteId(), context.getParagraphId(), true);
    }

    public static void removeAgulObjValue(InterpreterContext context, String name) {
        context.getAngularObjectRegistry().remove(name, context.getNoteId(), context.getParagraphId(), true);
    }

    private static String getProperty(Properties properties, String key, boolean outputLog, StringBuffer sbMessage) {
        String value = properties.getProperty(key, "");
        if (StringUtils.isEmpty(value) && outputLog) {
            sbMessage.append("EXECUTE_SUBMARINE_ERROR: Please set the submarine interpreter properties : ");
            sbMessage.append(key).append("\n");
        }
        return value;
    }

    public static HashMap propertiesToJinjaParams(Properties properties, SubmarineJob submarineJob, boolean outLog) throws IOException {
        String userTensorboardCheckpoint;
        Path chkpntPath;
        String tensorboardEnable;
        String submarineJar;
        StringBuffer sbMessage = new StringBuffer();
        String noteId = submarineJob.getNoteId();
        String machinelearingDistributed = SubmarineUtils.getProperty(properties, "machinelearning.distributed.enable", outLog, sbMessage);
        String inputPath = SubmarineUtils.getProperty(properties, "INPUT_PATH", outLog, sbMessage);
        String checkPointPath = SubmarineUtils.getProperty(properties, "CHECKPOINT_PATH", outLog, sbMessage);
        String psLaunchCmd = "";
        if (StringUtils.equals(machinelearingDistributed, "true")) {
            psLaunchCmd = SubmarineUtils.getProperty(properties, "PS_LAUNCH_CMD", outLog, sbMessage);
        }
        String workerLaunchCmd = SubmarineUtils.getProperty(properties, "WORKER_LAUNCH_CMD", outLog, sbMessage);
        String submarineHadoopHome = SubmarineUtils.getProperty(properties, "SUBMARINE_HADOOP_HOME", outLog, sbMessage);
        File file = new File(submarineHadoopHome);
        if (!file.exists()) {
            sbMessage.append("SUBMARINE_HADOOP_HOME: " + submarineHadoopHome + " is not a valid file path!\n");
        }
        if (!(file = new File(submarineJar = SubmarineUtils.getProperty(properties, "HADOOP_YARN_SUBMARINE_JAR", outLog, sbMessage))).exists()) {
            sbMessage.append("HADOOP_YARN_SUBMARINE_JAR:" + submarineJar + " is not a valid file path!\n");
        }
        String submarineYarnQueue = SubmarineUtils.getProperty(properties, "submarine.yarn.queue", outLog, sbMessage);
        String containerNetwork = SubmarineUtils.getProperty(properties, "docker.container.network", outLog, sbMessage);
        String parameterServicesImage = SubmarineUtils.getProperty(properties, "tf.parameter.services.docker.image", outLog, sbMessage);
        String parameterServicesNum = SubmarineUtils.getProperty(properties, "tf.parameter.services.num", outLog, sbMessage);
        String parameterServicesGpu = SubmarineUtils.getProperty(properties, "tf.parameter.services.gpu", outLog, sbMessage);
        String parameterServicesCpu = SubmarineUtils.getProperty(properties, "tf.parameter.services.cpu", outLog, sbMessage);
        String parameterServicesMemory = SubmarineUtils.getProperty(properties, "tf.parameter.services.memory", outLog, sbMessage);
        String workerServicesImage = SubmarineUtils.getProperty(properties, "tf.worker.services.docker.image", outLog, sbMessage);
        String workerServicesNum = SubmarineUtils.getProperty(properties, "tf.worker.services.num", outLog, sbMessage);
        String workerServicesGpu = SubmarineUtils.getProperty(properties, "tf.worker.services.gpu", outLog, sbMessage);
        String workerServicesCpu = SubmarineUtils.getProperty(properties, "tf.worker.services.cpu", outLog, sbMessage);
        String workerServicesMemory = SubmarineUtils.getProperty(properties, "tf.worker.services.memory", outLog, sbMessage);
        String algorithmUploadPath = SubmarineUtils.getProperty(properties, "submarine.algorithm.hdfs.path", outLog, sbMessage);
        String submarineHadoopKeytab = SubmarineUtils.getProperty(properties, "SUBMARINE_HADOOP_KEYTAB", outLog, sbMessage);
        file = new File(submarineHadoopKeytab);
        if (!file.exists()) {
            sbMessage.append("SUBMARINE_HADOOP_KEYTAB:" + submarineHadoopKeytab + " is not a valid file path!\n");
        }
        String submarineHadoopPrincipal = SubmarineUtils.getProperty(properties, "SUBMARINE_HADOOP_PRINCIPAL", outLog, sbMessage);
        String dockerHadoopHdfsHome = SubmarineUtils.getProperty(properties, "DOCKER_HADOOP_HDFS_HOME", outLog, sbMessage);
        String dockerJavaHome = SubmarineUtils.getProperty(properties, "DOCKER_JAVA_HOME", outLog, sbMessage);
        String intpLaunchMode = SubmarineUtils.getProperty(properties, "INTERPRETER_LAUNCH_MODE", outLog, sbMessage);
        if (StringUtils.isEmpty(intpLaunchMode)) {
            intpLaunchMode = "local";
        }
        if (StringUtils.isEmpty(tensorboardEnable = SubmarineUtils.getProperty(properties, "tf.tensorboard.enable", outLog, sbMessage))) {
            tensorboardEnable = "false";
        }
        String tensorboardCheckpoint = SubmarineUtils.getProperty(properties, "tf.checkpoint.path", outLog, sbMessage);
        if (StringUtils.equals(tensorboardEnable, "true") && StringUtils.isEmpty(tensorboardCheckpoint)) {
            sbMessage.append("Tensorboard checkpoint path cannot be empty!\n");
        }
        if ((chkpntPath = new Path(userTensorboardCheckpoint = submarineJob.getUserTensorboardPath())).depth() <= 3) {
            sbMessage.append("Checkpoint path depth must be greater than 3!\n");
        }
        String sumbarineHadoopConfDir = SubmarineUtils.getProperty(properties, "SUBMARINE_HADOOP_CONF_DIR", outLog, sbMessage);
        String dockerContainerTimezone = SubmarineUtils.getProperty(properties, "DOCKER_CONTAINER_TIME_ZONE", outLog, sbMessage);
        String notePath = algorithmUploadPath + File.separator + noteId;
        ArrayList<String> arrayHdfsFiles = new ArrayList<String>();
        List<Path> hdfsFiles = submarineJob.getHdfsClient().list(new Path(notePath + "/*"));
        if (hdfsFiles.size() == 0) {
            sbMessage.append("EXECUTE_SUBMARINE_ERROR: The " + notePath + " file directory was is empty in HDFS!\n");
        } else if (outLog) {
            StringBuffer sbCommitFiles = new StringBuffer();
            sbCommitFiles.append("INFO: You commit total of " + hdfsFiles.size() + " algorithm files.\n");
            for (int i = 0; i < hdfsFiles.size(); ++i) {
                String filePath = hdfsFiles.get(i).toUri().toString();
                arrayHdfsFiles.add(filePath);
                sbCommitFiles.append("INFO: [" + hdfsFiles.get(i).getName() + "] -> " + filePath + "\n");
            }
            submarineJob.getSubmarineUI().outputLog("Execution information", sbCommitFiles.toString());
        }
        if (!StringUtils.isEmpty(sbMessage.toString()) && outLog) {
            throw new RuntimeException(sbMessage.toString());
        }
        String jobName = SubmarineUtils.getJobName(submarineJob.getUserName(), submarineJob.getNoteId());
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(SubmarineUtils.unifyKey("INTERPRETER_LAUNCH_MODE"), intpLaunchMode);
        mapParams.put(SubmarineUtils.unifyKey("SUBMARINE_HADOOP_HOME"), submarineHadoopHome);
        mapParams.put(SubmarineUtils.unifyKey("SUBMARINE_HADOOP_CONF_DIR"), sumbarineHadoopConfDir);
        mapParams.put(SubmarineUtils.unifyKey("DOCKER_HADOOP_HDFS_HOME"), dockerHadoopHdfsHome);
        mapParams.put(SubmarineUtils.unifyKey("DOCKER_JAVA_HOME"), dockerJavaHome);
        mapParams.put(SubmarineUtils.unifyKey("DOCKER_CONTAINER_TIME_ZONE"), dockerContainerTimezone);
        mapParams.put(SubmarineUtils.unifyKey("HADOOP_YARN_SUBMARINE_JAR"), submarineJar);
        mapParams.put(SubmarineUtils.unifyKey("JOB_NAME"), jobName);
        mapParams.put(SubmarineUtils.unifyKey("docker.container.network"), containerNetwork);
        mapParams.put(SubmarineUtils.unifyKey("submarine.yarn.queue"), submarineYarnQueue);
        mapParams.put(SubmarineUtils.unifyKey("SUBMARINE_HADOOP_KEYTAB"), submarineHadoopKeytab);
        mapParams.put(SubmarineUtils.unifyKey("SUBMARINE_HADOOP_PRINCIPAL"), submarineHadoopPrincipal);
        mapParams.put(SubmarineUtils.unifyKey("machinelearning.distributed.enable"), machinelearingDistributed);
        mapParams.put(SubmarineUtils.unifyKey("submarine.algorithm.hdfs.path"), notePath);
        mapParams.put(SubmarineUtils.unifyKey("submarine.algorithm.hdfs.files"), arrayHdfsFiles);
        mapParams.put(SubmarineUtils.unifyKey("INPUT_PATH"), inputPath);
        mapParams.put(SubmarineUtils.unifyKey("CHECKPOINT_PATH"), checkPointPath);
        mapParams.put(SubmarineUtils.unifyKey("PS_LAUNCH_CMD"), psLaunchCmd);
        mapParams.put(SubmarineUtils.unifyKey("WORKER_LAUNCH_CMD"), workerLaunchCmd);
        mapParams.put(SubmarineUtils.unifyKey("tf.parameter.services.docker.image"), parameterServicesImage);
        mapParams.put(SubmarineUtils.unifyKey("tf.parameter.services.num"), parameterServicesNum);
        mapParams.put(SubmarineUtils.unifyKey("tf.parameter.services.gpu"), parameterServicesGpu);
        mapParams.put(SubmarineUtils.unifyKey("tf.parameter.services.cpu"), parameterServicesCpu);
        mapParams.put(SubmarineUtils.unifyKey("tf.parameter.services.memory"), parameterServicesMemory);
        mapParams.put(SubmarineUtils.unifyKey("tf.worker.services.docker.image"), workerServicesImage);
        mapParams.put(SubmarineUtils.unifyKey("tf.worker.services.num"), workerServicesNum);
        mapParams.put(SubmarineUtils.unifyKey("tf.worker.services.gpu"), workerServicesGpu);
        mapParams.put(SubmarineUtils.unifyKey("tf.worker.services.cpu"), workerServicesCpu);
        mapParams.put(SubmarineUtils.unifyKey("tf.worker.services.memory"), workerServicesMemory);
        mapParams.put(SubmarineUtils.unifyKey("tf.tensorboard.enable"), tensorboardEnable);
        mapParams.put(SubmarineUtils.unifyKey("tf.checkpoint.path"), userTensorboardCheckpoint);
        return mapParams;
    }
}

