/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.job;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.submarine.commons.SubmarineCommand;
import org.apache.zeppelin.submarine.commons.SubmarineUI;
import org.apache.zeppelin.submarine.commons.SubmarineUtils;
import org.apache.zeppelin.submarine.hadoop.FinalApplicationStatus;
import org.apache.zeppelin.submarine.hadoop.HdfsClient;
import org.apache.zeppelin.submarine.hadoop.YarnApplicationState;
import org.apache.zeppelin.submarine.hadoop.YarnClient;
import org.apache.zeppelin.submarine.job.SubmarineJobStatus;
import org.apache.zeppelin.submarine.job.thread.JobRunThread;
import org.apache.zeppelin.submarine.job.thread.TensorboardRunThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineJob
extends Thread {
    private Logger LOGGER = LoggerFactory.getLogger(SubmarineJob.class);
    private AtomicBoolean running = new AtomicBoolean(true);
    private static final long SYNC_SUBMARINE_RUNTIME_CYCLE = 3000L;
    private YarnClient yarnClient = null;
    private SubmarineUI submarineUI = null;
    private Properties properties = null;
    private HdfsClient hdfsClient = null;
    private File pythonWorkDir = null;
    private String noteId = null;
    private String noteName = null;
    private String userName = null;
    private String applicationId = null;
    private YarnApplicationState yarnApplicationState = null;
    private FinalApplicationStatus finalApplicationStatus = null;
    private long startTime = 0L;
    private long launchTime = 0L;
    private long finishTime = 0L;
    private float progress = 0.0f;
    private SubmarineJobStatus currentJobStatus = SubmarineJobStatus.EXECUTE_SUBMARINE;
    private InterpreterContext intpContext = null;
    JobRunThread jobRunThread = null;
    TensorboardRunThread tensorboardRunThread = null;
    public static final String DIRECTORY_USER_HOME = "shell.working.directory.userName.home";
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    public static final String shell = isWindows ? "cmd /c" : "bash -c";
    public static final String TIMEOUT_PROPERTY = "submarine.command.timeout.millisecond";
    public static final String defaultTimeout = "100000";
    public static final String SUBMARINE_JOBRUN_TF_JINJA = "jinja_templates/submarine-job-run-tf.jinja";
    public static final String SUBMARINE_COMMAND_JINJA = "jinja_templates/submarine-command.jinja";
    public static final String SUBMARINE_TENSORBOARD_JINJA = "jinja_templates/submarine-tensorboard.jinja";

    public SubmarineJob(InterpreterContext context, Properties properties) {
        this.intpContext = context;
        this.properties = properties;
        this.noteId = context.getNoteId();
        this.noteName = context.getNoteName();
        this.userName = context.getAuthenticationInfo().getUser();
        this.yarnClient = new YarnClient(properties);
        this.hdfsClient = new HdfsClient(properties);
        this.submarineUI = new SubmarineUI(this.intpContext);
        this.start();
    }

    @Override
    public void run() {
        while (this.running.get()) {
            String jobName = SubmarineUtils.getJobName(this.userName, this.noteId);
            this.updateJobStateByYarn(jobName);
            this.getTensorboardStatus();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    @VisibleForTesting
    public boolean getRunning() {
        return this.running.get();
    }

    public void stopRunning() {
        this.running.set(false);
        if (null != this.jobRunThread && this.jobRunThread.isAlive()) {
            this.jobRunThread.stopRunning();
        }
        if (null != this.tensorboardRunThread && this.tensorboardRunThread.isAlive()) {
            this.tensorboardRunThread.stopRunning();
        }
    }

    public String getUserTensorboardPath() {
        String tfCheckpointPath = this.properties.getProperty("tf.checkpoint.path", "");
        return tfCheckpointPath;
    }

    public String getJobDefaultCheckpointPath() {
        String userTensorboardPath = this.getUserTensorboardPath();
        return userTensorboardPath + "/" + this.noteId;
    }

    public void cleanJobDefaultCheckpointPath() {
        String jobCheckpointPath = this.getJobDefaultCheckpointPath();
        Path notePath = new Path(jobCheckpointPath);
        if (notePath.depth() <= 3) {
            this.submarineUI.outputLog("ERROR", "Checkpoint path depth must be greater than 3");
            return;
        }
        try {
            String message = "Clean up the checkpoint directory: " + jobCheckpointPath;
            this.submarineUI.outputLog("", message);
            this.hdfsClient.delete(notePath);
        }
        catch (IOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public HdfsClient getHdfsClient() {
        return this.hdfsClient;
    }

    public SubmarineUI getSubmarineUI() {
        return this.submarineUI;
    }

    public void setPythonWorkDir(File pythonWorkDir) {
        this.pythonWorkDir = pythonWorkDir;
    }

    public File getPythonWorkDir() {
        return this.pythonWorkDir;
    }

    public void onDashboard() {
        this.submarineUI.createSubmarineUI(SubmarineCommand.DASHBOARD);
    }

    public void runJob() {
        this.submarineUI.createSubmarineUI(SubmarineCommand.JOB_RUN);
        this.submarineUI.createLogHeadUI();
        String jobName = SubmarineUtils.getJobName(this.userName, this.noteId);
        Map<String, Object> mapAppStatus = this.getJobStateByYarn(jobName);
        if (mapAppStatus.size() == 0) {
            if (null == this.jobRunThread || !this.jobRunThread.isAlive()) {
                this.jobRunThread = new JobRunThread(this);
                this.jobRunThread.start();
            } else {
                this.submarineUI.outputLog("INFO", "JOB " + jobName + " being start up.");
            }
        } else {
            this.submarineUI.outputLog("INFO", "JOB " + jobName + " already running.");
        }
    }

    public void deleteJob(String serviceName) {
        this.submarineUI.createSubmarineUI(SubmarineCommand.JOB_STOP);
        this.yarnClient.deleteService(serviceName);
    }

    public void runTensorBoard() {
        this.submarineUI.createSubmarineUI(SubmarineCommand.TENSORBOARD_RUN);
        this.submarineUI.createLogHeadUI();
        String tensorboardName = SubmarineUtils.getTensorboardName(this.userName);
        Map<String, Object> mapAppStatus = this.getJobStateByYarn(tensorboardName);
        if (mapAppStatus.size() == 0) {
            if (null == this.tensorboardRunThread || !this.tensorboardRunThread.isAlive()) {
                this.tensorboardRunThread = new TensorboardRunThread(this);
                this.tensorboardRunThread.start();
            } else {
                this.submarineUI.outputLog("INFO", "Tensorboard being start up.");
            }
        } else {
            this.submarineUI.outputLog("INFO", "Tensorboard already running.");
        }
    }

    public boolean getTensorboardStatus() {
        String enableTensorboard = this.properties.getProperty("tf.tensorboard.enable", "false");
        boolean tensorboardExist = false;
        if (StringUtils.equals(enableTensorboard, "true")) {
            String tensorboardName = SubmarineUtils.getTensorboardName(this.userName);
            Map<String, Object> mapAppStatus = this.getJobStateByYarn(tensorboardName);
            String appId = "";
            if (mapAppStatus.containsKey("YARN_APPLICATION_ID")) {
                appId = mapAppStatus.get("YARN_APPLICATION_ID").toString();
                StringBuffer sbUrl = new StringBuffer();
                String yarnBaseUrl = this.properties.getProperty("yarn.webapp.http.address", "");
                sbUrl.append(yarnBaseUrl).append("/ui2/#/yarn-app/").append(appId);
                sbUrl.append("/components?service=").append(tensorboardName);
                SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_TENSORBOARD_URL", sbUrl.toString());
                List<Map<String, Object>> listExportPorts = this.yarnClient.getAppExportPorts(tensorboardName);
                for (Map<String, Object> exportPorts : listExportPorts) {
                    if (!exportPorts.containsKey("HOST_IP") || !exportPorts.containsKey("HOST_PORT") || !exportPorts.containsKey("CONTAINER_PORT")) continue;
                    String intpAppHostIp = (String)exportPorts.get("HOST_IP");
                    String intpAppHostPort = (String)exportPorts.get("HOST_PORT");
                    String intpAppContainerPort = (String)exportPorts.get("CONTAINER_PORT");
                    if (!StringUtils.equals("6006", intpAppContainerPort)) continue;
                    tensorboardExist = true;
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Detection tensorboard Container hostIp:{}, hostPort:{}, containerPort:{}.", intpAppHostIp, intpAppHostPort, intpAppContainerPort);
                    }
                    String tensorboardUrl = "http://" + intpAppHostIp + ":" + intpAppHostPort;
                    SubmarineUtils.setAgulObjValue(this.intpContext, "TENSORBOARD_URL", tensorboardUrl);
                    break;
                }
            } else {
                SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_TENSORBOARD_URL");
            }
            if (!tensorboardExist) {
                SubmarineUtils.removeAgulObjValue(this.intpContext, "TENSORBOARD_URL");
            }
        }
        return tensorboardExist;
    }

    public void showUsage() {
        this.submarineUI.createSubmarineUI(SubmarineCommand.USAGE);
    }

    public void cleanRuntimeCache() {
        this.intpContext.getAngularObjectRegistry().removeAll(this.noteId, this.intpContext.getParagraphId());
        this.submarineUI.createSubmarineUI(SubmarineCommand.DASHBOARD);
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setCurrentJobState(SubmarineJobStatus toStatus) {
        SubmarineUtils.setAgulObjValue(this.intpContext, "JOB_STATUS", toStatus.getStatus());
        this.currentJobStatus = toStatus;
    }

    public Map<String, Object> getJobStateByYarn(String jobName) {
        Map<String, Object> mapAppStatus = new HashMap<String, Object>();
        Map<String, Object> mapStatus = this.yarnClient.getAppServices(jobName);
        if (mapStatus.containsKey("YARN_APPLICATION_ID") && mapStatus.containsKey("YARN_APPLICATION_NAME")) {
            String appId = mapStatus.get("YARN_APPLICATION_ID").toString();
            mapAppStatus = this.yarnClient.getClusterApps(appId);
            mapAppStatus.putAll(mapStatus);
        }
        return mapAppStatus;
    }

    public void updateJobStateByYarn(String appName) {
        Map<String, Object> mapAppStatus = this.getJobStateByYarn(appName);
        if (mapAppStatus.size() == 0) {
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APPLICATION_ID");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APPLICATION_STATUS");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APPLICATION_URL");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APP_STARTED_TIME");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APP_LAUNCH_TIME");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APP_FINISHED_TIME");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "YARN_APP_ELAPSED_TIME");
            SubmarineUtils.removeAgulObjValue(this.intpContext, "JOB_STATUS");
        } else {
            String state = "";
            String finalStatus = "";
            String appId = "";
            if (mapAppStatus.containsKey("YARN_APPLICATION_ID")) {
                appId = mapAppStatus.get("YARN_APPLICATION_ID").toString();
            }
            if (mapAppStatus.containsKey("state")) {
                state = mapAppStatus.get("state").toString();
                SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APPLICATION_STATUS", state);
            }
            if (mapAppStatus.containsKey("finalStatus")) {
                finalStatus = mapAppStatus.get("finalStatus").toString();
                SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APPLICATION_FINAL_STATUS", finalStatus);
            }
            SubmarineJobStatus jobStatus = this.convertYarnState(state, finalStatus);
            this.setCurrentJobState(jobStatus);
            try {
                String elapsedTime;
                long lElapsedTime;
                Object finishedDate;
                String finishedTime;
                long lFinishedTime;
                String launchTime;
                long lLaunchTime;
                String startedTime;
                long lStartedTime;
                if (mapAppStatus.containsKey("startedTime") && (lStartedTime = Long.parseLong(startedTime = mapAppStatus.get("startedTime").toString())) > 0L) {
                    Date startedDate = new Date(lStartedTime);
                    SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APP_STARTED_TIME", startedDate.toString());
                }
                if (mapAppStatus.containsKey("launchTime") && (lLaunchTime = Long.parseLong(launchTime = mapAppStatus.get("launchTime").toString())) > 0L) {
                    Date launchDate = new Date(lLaunchTime);
                    SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APP_LAUNCH_TIME", launchDate.toString());
                }
                if (mapAppStatus.containsKey("finishedTime") && (lFinishedTime = Long.parseLong(finishedTime = mapAppStatus.get("finishedTime").toString())) > 0L) {
                    finishedDate = new Date(lFinishedTime);
                    SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APP_FINISHED_TIME", ((Date)finishedDate).toString());
                }
                if (mapAppStatus.containsKey("elapsedTime") && (lElapsedTime = Long.parseLong(elapsedTime = mapAppStatus.get("elapsedTime").toString())) > 0L) {
                    finishedDate = org.apache.hadoop.util.StringUtils.formatTime((long)lElapsedTime);
                    SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APP_ELAPSED_TIME", finishedDate);
                }
            }
            catch (NumberFormatException e) {
                this.LOGGER.error(e.getMessage());
            }
            StringBuffer sbUrl = new StringBuffer();
            String yarnBaseUrl = this.properties.getProperty("yarn.webapp.http.address", "");
            sbUrl.append(yarnBaseUrl).append("/ui2/#/yarn-app/").append(appId);
            sbUrl.append("/components?service=").append(appName);
            SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APPLICATION_ID", appId);
            SubmarineUtils.setAgulObjValue(this.intpContext, "YARN_APPLICATION_URL", sbUrl.toString());
        }
    }

    private SubmarineJobStatus convertYarnState(String status, String finalStatus) {
        SubmarineJobStatus submarineJobStatus = SubmarineJobStatus.UNKNOWN;
        switch (status) {
            case "NEW": {
                submarineJobStatus = SubmarineJobStatus.YARN_NEW;
                break;
            }
            case "NEW_SAVING": {
                submarineJobStatus = SubmarineJobStatus.YARN_NEW_SAVING;
                break;
            }
            case "SUBMITTED": {
                submarineJobStatus = SubmarineJobStatus.YARN_SUBMITTED;
                break;
            }
            case "ACCEPTED": {
                submarineJobStatus = SubmarineJobStatus.YARN_ACCEPTED;
                break;
            }
            case "RUNNING": {
                submarineJobStatus = SubmarineJobStatus.YARN_RUNNING;
                break;
            }
            case "FINISHED": {
                submarineJobStatus = SubmarineJobStatus.YARN_FINISHED;
                break;
            }
            case "FAILED": {
                submarineJobStatus = SubmarineJobStatus.YARN_FAILED;
                break;
            }
            case "KILLED": {
                submarineJobStatus = SubmarineJobStatus.YARN_KILLED;
                break;
            }
            case "STOPPED": {
                submarineJobStatus = SubmarineJobStatus.YARN_STOPPED;
            }
        }
        switch (finalStatus) {
            case "NEW": {
                submarineJobStatus = SubmarineJobStatus.YARN_NEW;
                break;
            }
            case "NEW_SAVING": {
                submarineJobStatus = SubmarineJobStatus.YARN_NEW_SAVING;
                break;
            }
            case "SUBMITTED": {
                submarineJobStatus = SubmarineJobStatus.YARN_SUBMITTED;
                break;
            }
            case "ACCEPTED": {
                submarineJobStatus = SubmarineJobStatus.YARN_ACCEPTED;
                break;
            }
            case "RUNNING": {
                submarineJobStatus = SubmarineJobStatus.YARN_RUNNING;
                break;
            }
            case "FINISHED": {
                submarineJobStatus = SubmarineJobStatus.YARN_FINISHED;
                break;
            }
            case "FAILED": {
                submarineJobStatus = SubmarineJobStatus.YARN_FAILED;
                break;
            }
            case "KILLED": {
                submarineJobStatus = SubmarineJobStatus.YARN_KILLED;
                break;
            }
            case "STOPPED": {
                submarineJobStatus = SubmarineJobStatus.YARN_STOPPED;
                break;
            }
        }
        return submarineJobStatus;
    }

    public InterpreterContext getIntpContext() {
        return this.intpContext;
    }

    public void setIntpContext(InterpreterContext intpContext) {
        this.intpContext = intpContext;
        this.submarineUI = new SubmarineUI(intpContext);
    }
}

