/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class ByteDecoder
extends AbstractDecoder
implements Decoder.Text<Byte> {
    public static final ByteDecoder INSTANCE = new ByteDecoder();

    @Override
    public Byte decode(String s2) throws DecodeException {
        try {
            return Byte.parseByte(s2);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse Byte", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Byte.parseByte(s2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

