/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Arrays;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TokeniserState {
    Data{

        void read(Tokeniser t2, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t2.advanceTransition(CharacterReferenceInData);
                    break;
                }
                case '<': {
                    t2.advanceTransition(TagOpen);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.emit(r.consume());
                    break;
                }
                case '\uffff': {
                    t2.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeData();
                    t2.emit(data);
                }
            }
        }
    }
    ,
    CharacterReferenceInData{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readCharRef(t2, 2.Data);
        }
    }
    ,
    Rcdata{

        void read(Tokeniser t2, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t2.advanceTransition(CharacterReferenceInRcdata);
                    break;
                }
                case '<': {
                    t2.advanceTransition(RcdataLessthanSign);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    r.advance();
                    t2.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeToAny('&', '<', '\u0000');
                    t2.emit(data);
                }
            }
        }
    }
    ,
    CharacterReferenceInRcdata{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readCharRef(t2, 4.Rcdata);
        }
    }
    ,
    Rawtext{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readData(t2, r, (TokeniserState)this, 5.RawtextLessthanSign);
        }
    }
    ,
    ScriptData{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readData(t2, r, (TokeniserState)this, 6.ScriptDataLessthanSign);
        }
    }
    ,
    PLAINTEXT{

        void read(Tokeniser t2, CharacterReader r) {
            switch (r.current()) {
                case '\u0000': {
                    t2.error(this);
                    r.advance();
                    t2.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeTo('\u0000');
                    t2.emit(data);
                }
            }
        }
    }
    ,
    TagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            switch (r.current()) {
                case '!': {
                    t2.advanceTransition(MarkupDeclarationOpen);
                    break;
                }
                case '/': {
                    t2.advanceTransition(EndTagOpen);
                    break;
                }
                case '?': {
                    t2.advanceTransition(BogusComment);
                    break;
                }
                default: {
                    if (r.matchesLetter()) {
                        t2.createTagPending(true);
                        t2.transition(TagName);
                        break;
                    }
                    t2.error(this);
                    t2.emit('<');
                    t2.transition(Data);
                }
            }
        }
    }
    ,
    EndTagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.isEmpty()) {
                t2.eofError(this);
                t2.emit("</");
                t2.transition(Data);
            } else if (r.matchesLetter()) {
                t2.createTagPending(false);
                t2.transition(TagName);
            } else if (r.matches('>')) {
                t2.error(this);
                t2.advanceTransition(Data);
            } else {
                t2.error(this);
                t2.advanceTransition(BogusComment);
            }
        }
    }
    ,
    TagName{

        void read(Tokeniser t2, CharacterReader r) {
            String tagName = r.consumeTagName();
            t2.tagPending.appendTagName(tagName);
            switch (r.consume()) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.tagPending.appendTagName(replacementStr);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                }
            }
        }
    }
    ,
    RcdataLessthanSign{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matches('/')) {
                t2.createTempBuffer();
                t2.advanceTransition(RCDATAEndTagOpen);
            } else if (r.matchesLetter() && t2.appropriateEndTagName() != null && !r.containsIgnoreCase("</" + t2.appropriateEndTagName())) {
                t2.tagPending = t2.createTagPending(false).name(t2.appropriateEndTagName());
                t2.emitTagPending();
                r.unconsume();
                t2.transition(Data);
            } else {
                t2.emit("<");
                t2.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                t2.createTagPending(false);
                t2.tagPending.appendTagName(r.current());
                t2.dataBuffer.append(r.current());
                t2.advanceTransition(RCDATAEndTagName);
            } else {
                t2.emit("</");
                t2.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagName{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                String name = r.consumeLetterSequence();
                t2.tagPending.appendTagName(name);
                t2.dataBuffer.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (t2.isAppropriateEndTagToken()) {
                        t2.transition(BeforeAttributeName);
                        break;
                    }
                    this.anythingElse(t2, r);
                    break;
                }
                case '/': {
                    if (t2.isAppropriateEndTagToken()) {
                        t2.transition(SelfClosingStartTag);
                        break;
                    }
                    this.anythingElse(t2, r);
                    break;
                }
                case '>': {
                    if (t2.isAppropriateEndTagToken()) {
                        t2.emitTagPending();
                        t2.transition(Data);
                        break;
                    }
                    this.anythingElse(t2, r);
                    break;
                }
                default: {
                    this.anythingElse(t2, r);
                }
            }
        }

        private void anythingElse(Tokeniser t2, CharacterReader r) {
            t2.emit("</" + t2.dataBuffer.toString());
            r.unconsume();
            t2.transition(Rcdata);
        }
    }
    ,
    RawtextLessthanSign{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matches('/')) {
                t2.createTempBuffer();
                t2.advanceTransition(RawtextEndTagOpen);
            } else {
                t2.emit('<');
                t2.transition(Rawtext);
            }
        }
    }
    ,
    RawtextEndTagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readEndTag(t2, r, 15.RawtextEndTagName, 15.Rawtext);
        }
    }
    ,
    RawtextEndTagName{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.handleDataEndTag(t2, r, 16.Rawtext);
        }
    }
    ,
    ScriptDataLessthanSign{

        void read(Tokeniser t2, CharacterReader r) {
            switch (r.consume()) {
                case '/': {
                    t2.createTempBuffer();
                    t2.transition(ScriptDataEndTagOpen);
                    break;
                }
                case '!': {
                    t2.emit("<!");
                    t2.transition(ScriptDataEscapeStart);
                    break;
                }
                default: {
                    t2.emit("<");
                    r.unconsume();
                    t2.transition(ScriptData);
                }
            }
        }
    }
    ,
    ScriptDataEndTagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.readEndTag(t2, r, 18.ScriptDataEndTagName, 18.ScriptData);
        }
    }
    ,
    ScriptDataEndTagName{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.handleDataEndTag(t2, r, 19.ScriptData);
        }
    }
    ,
    ScriptDataEscapeStart{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matches('-')) {
                t2.emit('-');
                t2.advanceTransition(ScriptDataEscapeStartDash);
            } else {
                t2.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscapeStartDash{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matches('-')) {
                t2.emit('-');
                t2.advanceTransition(ScriptDataEscapedDashDash);
            } else {
                t2.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscaped{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.isEmpty()) {
                t2.eofError(this);
                t2.transition(Data);
                return;
            }
            switch (r.current()) {
                case '-': {
                    t2.emit('-');
                    t2.advanceTransition(ScriptDataEscapedDash);
                    break;
                }
                case '<': {
                    t2.advanceTransition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    r.advance();
                    t2.emit('\ufffd');
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t2.emit(data);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDash{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.isEmpty()) {
                t2.eofError(this);
                t2.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.emit(c);
                    t2.transition(ScriptDataEscapedDashDash);
                    break;
                }
                case '<': {
                    t2.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.emit('\ufffd');
                    t2.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t2.emit(c);
                    t2.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDashDash{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.isEmpty()) {
                t2.eofError(this);
                t2.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.emit(c);
                    break;
                }
                case '<': {
                    t2.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t2.emit(c);
                    t2.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.emit('\ufffd');
                    t2.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t2.emit(c);
                    t2.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedLessthanSign{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                t2.createTempBuffer();
                t2.dataBuffer.append(r.current());
                t2.emit("<" + r.current());
                t2.advanceTransition(ScriptDataDoubleEscapeStart);
            } else if (r.matches('/')) {
                t2.createTempBuffer();
                t2.advanceTransition(ScriptDataEscapedEndTagOpen);
            } else {
                t2.emit('<');
                t2.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagOpen{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                t2.createTagPending(false);
                t2.tagPending.appendTagName(r.current());
                t2.dataBuffer.append(r.current());
                t2.advanceTransition(ScriptDataEscapedEndTagName);
            } else {
                t2.emit("</");
                t2.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagName{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.handleDataEndTag(t2, r, 27.ScriptDataEscaped);
        }
    }
    ,
    ScriptDataDoubleEscapeStart{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t2, r, 28.ScriptDataDoubleEscaped, 28.ScriptDataEscaped);
        }
    }
    ,
    ScriptDataDoubleEscaped{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t2.emit(c);
                    t2.advanceTransition(ScriptDataDoubleEscapedDash);
                    break;
                }
                case '<': {
                    t2.emit(c);
                    t2.advanceTransition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    r.advance();
                    t2.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t2.emit(data);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDash{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.emit(c);
                    t2.transition(ScriptDataDoubleEscapedDashDash);
                    break;
                }
                case '<': {
                    t2.emit(c);
                    t2.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.emit('\ufffd');
                    t2.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.emit(c);
                    t2.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDashDash{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.emit(c);
                    break;
                }
                case '<': {
                    t2.emit(c);
                    t2.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t2.emit(c);
                    t2.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.emit('\ufffd');
                    t2.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.emit(c);
                    t2.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedLessthanSign{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matches('/')) {
                t2.emit('/');
                t2.createTempBuffer();
                t2.advanceTransition(ScriptDataDoubleEscapeEnd);
            } else {
                t2.transition(ScriptDataDoubleEscaped);
            }
        }
    }
    ,
    ScriptDataDoubleEscapeEnd{

        void read(Tokeniser t2, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t2, r, 33.ScriptDataEscaped, 33.ScriptDataDoubleEscaped);
        }
    }
    ,
    BeforeAttributeName{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.newAttribute();
                    r.unconsume();
                    t2.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': {
                    t2.error(this);
                    t2.tagPending.newAttribute();
                    t2.tagPending.appendAttributeName(c);
                    t2.transition(AttributeName);
                    break;
                }
                default: {
                    t2.tagPending.newAttribute();
                    r.unconsume();
                    t2.transition(AttributeName);
                }
            }
        }
    }
    ,
    AttributeName{

        void read(Tokeniser t2, CharacterReader r) {
            String name = r.consumeToAnySorted(attributeNameCharsSorted);
            t2.tagPending.appendAttributeName(name);
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(AfterAttributeName);
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t2.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeName('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t2.error(this);
                    t2.tagPending.appendAttributeName(c);
                }
            }
        }
    }
    ,
    AfterAttributeName{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t2.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeName('\ufffd');
                    t2.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t2.error(this);
                    t2.tagPending.newAttribute();
                    t2.tagPending.appendAttributeName(c);
                    t2.transition(AttributeName);
                    break;
                }
                default: {
                    t2.tagPending.newAttribute();
                    r.unconsume();
                    t2.transition(AttributeName);
                }
            }
        }
    }
    ,
    BeforeAttributeValue{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t2.transition(AttributeValue_doubleQuoted);
                    break;
                }
                case '&': {
                    r.unconsume();
                    t2.transition(AttributeValue_unquoted);
                    break;
                }
                case '\'': {
                    t2.transition(AttributeValue_singleQuoted);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue('\ufffd');
                    t2.transition(AttributeValue_unquoted);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '<': 
                case '=': 
                case '`': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue(c);
                    t2.transition(AttributeValue_unquoted);
                    break;
                }
                default: {
                    r.unconsume();
                    t2.transition(AttributeValue_unquoted);
                }
            }
        }
    }
    ,
    AttributeValue_doubleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            String value = r.consumeToAny(attributeDoubleValueCharsSorted);
            if (value.length() > 0) {
                t2.tagPending.appendAttributeValue(value);
            } else {
                t2.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t2.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] ref = t2.consumeCharacterReference(Character.valueOf('\"'), true);
                    if (ref != null) {
                        t2.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t2.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                }
            }
        }
    }
    ,
    AttributeValue_singleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            String value = r.consumeToAny(attributeSingleValueCharsSorted);
            if (value.length() > 0) {
                t2.tagPending.appendAttributeValue(value);
            } else {
                t2.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t2.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] ref = t2.consumeCharacterReference(Character.valueOf('\''), true);
                    if (ref != null) {
                        t2.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t2.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                }
            }
        }
    }
    ,
    AttributeValue_unquoted{

        void read(Tokeniser t2, CharacterReader r) {
            String value = r.consumeToAnySorted(attributeValueUnquoted);
            if (value.length() > 0) {
                t2.tagPending.appendAttributeValue(value);
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeAttributeName);
                    break;
                }
                case '&': {
                    int[] ref = t2.consumeCharacterReference(Character.valueOf('>'), true);
                    if (ref != null) {
                        t2.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t2.tagPending.appendAttributeValue('&');
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '`': {
                    t2.error(this);
                    t2.tagPending.appendAttributeValue(c);
                }
            }
        }
    }
    ,
    AfterAttributeValue_quoted{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    r.unconsume();
                    t2.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    SelfClosingStartTag{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t2.tagPending.selfClosing = true;
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    r.unconsume();
                    t2.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    BogusComment{

        void read(Tokeniser t2, CharacterReader r) {
            r.unconsume();
            Token.Comment comment = new Token.Comment();
            comment.bogus = true;
            comment.data.append(r.consumeTo('>'));
            t2.emit(comment);
            t2.advanceTransition(Data);
        }
    }
    ,
    MarkupDeclarationOpen{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchConsume("--")) {
                t2.createCommentPending();
                t2.transition(CommentStart);
            } else if (r.matchConsumeIgnoreCase("DOCTYPE")) {
                t2.transition(Doctype);
            } else if (r.matchConsume("[CDATA[")) {
                t2.transition(CdataSection);
            } else {
                t2.error(this);
                t2.advanceTransition(BogusComment);
            }
        }
    }
    ,
    CommentStart{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.commentPending.data.append('\ufffd');
                    t2.transition(Comment);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.commentPending.data.append(c);
                    t2.transition(Comment);
                }
            }
        }
    }
    ,
    CommentStartDash{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.commentPending.data.append('\ufffd');
                    t2.transition(Comment);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.commentPending.data.append(c);
                    t2.transition(Comment);
                }
            }
        }
    }
    ,
    Comment{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t2.advanceTransition(CommentEndDash);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    r.advance();
                    t2.commentPending.data.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.commentPending.data.append(r.consumeToAny('-', '\u0000'));
                }
            }
        }
    }
    ,
    CommentEndDash{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.transition(CommentEnd);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.commentPending.data.append('-').append('\ufffd');
                    t2.transition(Comment);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.commentPending.data.append('-').append(c);
                    t2.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEnd{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.commentPending.data.append("--").append('\ufffd');
                    t2.transition(Comment);
                    break;
                }
                case '!': {
                    t2.error(this);
                    t2.transition(CommentEndBang);
                    break;
                }
                case '-': {
                    t2.error(this);
                    t2.commentPending.data.append('-');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.commentPending.data.append("--").append(c);
                    t2.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEndBang{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t2.commentPending.data.append("--!");
                    t2.transition(CommentEndDash);
                    break;
                }
                case '>': {
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.commentPending.data.append("--!").append('\ufffd');
                    t2.transition(Comment);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.emitCommentPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.commentPending.data.append("--!").append(c);
                    t2.transition(Comment);
                }
            }
        }
    }
    ,
    Doctype{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeDoctypeName);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                }
                case '>': {
                    t2.error(this);
                    t2.createDoctypePending();
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.transition(BeforeDoctypeName);
                }
            }
        }
    }
    ,
    BeforeDoctypeName{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                t2.createDoctypePending();
                t2.transition(DoctypeName);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.createDoctypePending();
                    t2.doctypePending.name.append('\ufffd');
                    t2.transition(DoctypeName);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.createDoctypePending();
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.createDoctypePending();
                    t2.doctypePending.name.append(c);
                    t2.transition(DoctypeName);
                }
            }
        }
    }
    ,
    DoctypeName{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.matchesLetter()) {
                String name = r.consumeLetterSequence();
                t2.doctypePending.name.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '>': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(AfterDoctypeName);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.doctypePending.name.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.doctypePending.name.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeName{

        void read(Tokeniser t2, CharacterReader r) {
            if (r.isEmpty()) {
                t2.eofError(this);
                t2.doctypePending.forceQuirks = true;
                t2.emitDoctypePending();
                t2.transition(Data);
                return;
            }
            if (r.matchesAny('\t', '\n', '\r', '\f', ' ')) {
                r.advance();
            } else if (r.matches('>')) {
                t2.emitDoctypePending();
                t2.advanceTransition(Data);
            } else if (r.matchConsumeIgnoreCase("PUBLIC")) {
                t2.doctypePending.pubSysKey = "PUBLIC";
                t2.transition(AfterDoctypePublicKeyword);
            } else if (r.matchConsumeIgnoreCase("SYSTEM")) {
                t2.doctypePending.pubSysKey = "SYSTEM";
                t2.transition(AfterDoctypeSystemKeyword);
            } else {
                t2.error(this);
                t2.doctypePending.forceQuirks = true;
                t2.advanceTransition(BogusDoctype);
            }
        }
    }
    ,
    AfterDoctypePublicKeyword{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeDoctypePublicIdentifier);
                    break;
                }
                case '\"': {
                    t2.error(this);
                    t2.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.error(this);
                    t2.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BeforeDoctypePublicIdentifier{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t2.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_doubleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t2.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_singleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t2.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypePublicIdentifier{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BetweenDoctypePublicAndSystemIdentifiers);
                    break;
                }
                case '>': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\"': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BetweenDoctypePublicAndSystemIdentifiers{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\"': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemKeyword{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\"': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.error(this);
                    t2.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                }
            }
        }
    }
    ,
    BeforeDoctypeSystemIdentifier{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t2.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t2.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_doubleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t2.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_singleQuoted{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t2.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    t2.error(this);
                    t2.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t2.error(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemIdentifier{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.eofError(this);
                    t2.doctypePending.forceQuirks = true;
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.error(this);
                    t2.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BogusDoctype{

        void read(Tokeniser t2, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
                case '\uffff': {
                    t2.emitDoctypePending();
                    t2.transition(Data);
                    break;
                }
            }
        }
    }
    ,
    CdataSection{

        void read(Tokeniser t2, CharacterReader r) {
            String data = r.consumeTo("]]>");
            t2.emit(data);
            r.matchConsume("]]>");
            t2.transition(Data);
        }
    };

    static final char nullChar = '\u0000';
    private static final char[] attributeSingleValueCharsSorted;
    private static final char[] attributeDoubleValueCharsSorted;
    private static final char[] attributeNameCharsSorted;
    private static final char[] attributeValueUnquoted;
    private static final char replacementChar = '\ufffd';
    private static final String replacementStr;
    private static final char eof = '\uffff';

    abstract void read(Tokeniser var1, CharacterReader var2);

    private static void handleDataEndTag(Tokeniser t2, CharacterReader r, TokeniserState elseTransition) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t2.tagPending.appendTagName(name);
            t2.dataBuffer.append(name);
            return;
        }
        boolean needsExitTransition = false;
        if (t2.isAppropriateEndTagToken() && !r.isEmpty()) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t2.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t2.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t2.emitTagPending();
                    t2.transition(Data);
                    break;
                }
                default: {
                    t2.dataBuffer.append(c);
                    needsExitTransition = true;
                    break;
                }
            }
        } else {
            needsExitTransition = true;
        }
        if (needsExitTransition) {
            t2.emit("</" + t2.dataBuffer.toString());
            t2.transition(elseTransition);
        }
    }

    private static void readData(Tokeniser t2, CharacterReader r, TokeniserState current, TokeniserState advance) {
        switch (r.current()) {
            case '<': {
                t2.advanceTransition(advance);
                break;
            }
            case '\u0000': {
                t2.error(current);
                r.advance();
                t2.emit('\ufffd');
                break;
            }
            case '\uffff': {
                t2.emit(new Token.EOF());
                break;
            }
            default: {
                String data = r.consumeToAny('<', '\u0000');
                t2.emit(data);
            }
        }
    }

    private static void readCharRef(Tokeniser t2, TokeniserState advance) {
        int[] c = t2.consumeCharacterReference(null, false);
        if (c == null) {
            t2.emit('&');
        } else {
            t2.emit(c);
        }
        t2.transition(advance);
    }

    private static void readEndTag(Tokeniser t2, CharacterReader r, TokeniserState a, TokeniserState b) {
        if (r.matchesLetter()) {
            t2.createTagPending(false);
            t2.transition(a);
        } else {
            t2.emit("</");
            t2.transition(b);
        }
    }

    private static void handleDataDoubleEscapeTag(Tokeniser t2, CharacterReader r, TokeniserState primary, TokeniserState fallback) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t2.dataBuffer.append(name);
            t2.emit(name);
            return;
        }
        char c = r.consume();
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '/': 
            case '>': {
                if (t2.dataBuffer.toString().equals("script")) {
                    t2.transition(primary);
                } else {
                    t2.transition(fallback);
                }
                t2.emit(c);
                break;
            }
            default: {
                r.unconsume();
                t2.transition(fallback);
            }
        }
    }

    static {
        attributeSingleValueCharsSorted = new char[]{'\'', '&', '\u0000'};
        attributeDoubleValueCharsSorted = new char[]{'\"', '&', '\u0000'};
        attributeNameCharsSorted = new char[]{'\t', '\n', '\r', '\f', ' ', '/', '=', '>', '\u0000', '\"', '\'', '<'};
        attributeValueUnquoted = new char[]{'\t', '\n', '\r', '\f', ' ', '&', '>', '\u0000', '\"', '\'', '<', '=', '`'};
        replacementStr = String.valueOf('\ufffd');
        Arrays.sort(attributeSingleValueCharsSorted);
        Arrays.sort(attributeDoubleValueCharsSorted);
        Arrays.sort(attributeNameCharsSorted);
        Arrays.sort(attributeValueUnquoted);
    }
}

