/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import java.io.Serializable;
import java.time.Duration;
import org.apache.zeppelin.cassandra.DisplaySystem$AggregateDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$ClusterDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$FunctionDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$HelpDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$KeyspaceDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$MaterializedViewDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$NoResultDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$TableDisplay$;
import org.apache.zeppelin.cassandra.DisplaySystem$UDTDisplay$;
import org.apache.zeppelin.cassandra.EnhancedSession$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}h\u0001\u0002\u001f>\u0001\u0019C\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t?\u0002\u0011\t\u0011)A\u0005\u001f\")\u0001\r\u0001C\u0001C\"9Q\r\u0001b\u0001\n\u00031\u0007B\u00028\u0001A\u0003%q\rC\u0004p\u0001\t\u0007I\u0011\u00019\t\rQ\u0004\u0001\u0015!\u0003r\u0011\u001d)\bA1A\u0005\u0002YDaA\u001f\u0001!\u0002\u00139\bbB>\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\n\u0011%\tY\u0002\u0001b\u0001\n\u0003\ti\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0010\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0016\u0011%\t\u0019\u0004\u0001b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001c\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\"\u0011%\tY\u0005\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA\"\u0011%\ty\u0005\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA*\u0011%\t)\u0007\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA5\u0011%\t9\b\u0001b\u0001\n\u0003\tI\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA>\u0011%\tI\t\u0001b\u0001\n\u0003\tY\t\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAG\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a/\u0001\t\u0013\ti\fC\u0004\u0002<\u0002!I!!9\t\u000f\u0005m\u0006\u0001\"\u0003\u0002n\"9\u00111\u0018\u0001\u0005\n\u0005e\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0003w\u0003A\u0011\u0002B\u0006\u0011\u001d\tY\f\u0001C\u0005\u0005/Aq!a/\u0001\t\u0013\u0011\u0019\u0003C\u0004\u0002<\u0002!IAa\f\t\u000f\u0005m\u0006\u0001\"\u0003\u0003<!9\u00111\u0018\u0001\u0005\n\t\u001d\u0003bBA^\u0001\u0011%!1\u000b\u0005\b\u0003w\u0003A\u0011\u0002B0\u0011\u001d\tY\f\u0001C\u0005\u0005WBq!a/\u0001\t\u0013\u00119\bC\u0004\u0003\u0004\u0002!IA!\"\t\u000f\u0005m\u0006\u0001\"\u0001\u0003*\u001e9!qW\u001f\t\u0002\tefA\u0002\u001f>\u0011\u0003\u0011Y\f\u0003\u0004ak\u0011\u0005!Q\u0018\u0005\n\u0005\u007f+$\u0019!C\u0005\u0005\u0003D\u0001Ba56A\u0003%!1\u0019\u0005\b\u0005+,D\u0011\u0001Bl\u0011\u001d\u0011).\u000eC\u0001\u0005CDqAa<6\t\u0003\u0011\tPA\bF]\"\fgnY3e'\u0016\u001c8/[8o\u0015\tqt(A\u0005dCN\u001c\u0018M\u001c3sC*\u0011\u0001)Q\u0001\tu\u0016\u0004\b/\u001a7j]*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019Xm]:j_:,\u0012a\u0014\t\u0003!vk\u0011!\u0015\u0006\u0003%N\u000bAaY8sK*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u0019!'/\u001b<fe*\u0011\u0001,W\u0001\u0004_N\u001c(B\u0001.\\\u0003!!\u0017\r^1ti\u0006D(\"\u0001/\u0002\u0007\r|W.\u0003\u0002_#\nQ1)\u001d7TKN\u001c\u0018n\u001c8\u0002\u0011M,7o]5p]\u0002\na\u0001P5oSRtDC\u00012e!\t\u0019\u0007!D\u0001>\u0011\u0015i5\u00011\u0001P\u00039\u0019G.^:uKJ$\u0015n\u001d9mCf,\u0012a\u001a\b\u0003Q.t!aY5\n\u0005)l\u0014!\u0004#jgBd\u0017-_*zgR,W.\u0003\u0002m[\u0006q1\t\\;ti\u0016\u0014H)[:qY\u0006L(B\u00016>\u0003=\u0019G.^:uKJ$\u0015n\u001d9mCf\u0004\u0013aD6fsN\u0004\u0018mY3ESN\u0004H.Y=\u0016\u0003Et!\u0001\u001b:\n\u0005Ml\u0017aD&fsN\u0004\u0018mY3ESN\u0004H.Y=\u0002!-,\u0017p\u001d9bG\u0016$\u0015n\u001d9mCf\u0004\u0013\u0001\u0004;bE2,G)[:qY\u0006LX#A<\u000f\u0005!D\u0018BA=n\u00031!\u0016M\u00197f\t&\u001c\b\u000f\\1z\u00035!\u0018M\u00197f\t&\u001c\b\u000f\\1zA\u0005QQ\u000f\u001a;ESN\u0004H.Y=\u0016\u0003ut!\u0001\u001b@\n\u0005}l\u0017AC+E)\u0012K7\u000f\u001d7bs\u0006YQ\u000f\u001a;ESN\u0004H.Y=!\u0003=1WO\\2uS>tG)[:qY\u0006LXCAA\u0004\u001d\rA\u0017\u0011B\u0005\u0004\u0003\u0017i\u0017a\u0004$v]\u000e$\u0018n\u001c8ESN\u0004H.Y=\u0002!\u0019,hn\u0019;j_:$\u0015n\u001d9mCf\u0004\u0013\u0001E1hOJ,w-\u0019;f\t&\u001c\b\u000f\\1z+\t\t\u0019BD\u0002i\u0003+I1!a\u0006n\u0003A\tum\u001a:fO\u0006$X\rR5ta2\f\u00170A\tbO\u001e\u0014XmZ1uK\u0012K7\u000f\u001d7bs\u0002\nq#\\1uKJL\u0017\r\\5{K\u00124\u0016.Z<ESN\u0004H.Y=\u0016\u0005\u0005}ab\u00015\u0002\"%\u0019\u00111E7\u0002/5\u000bG/\u001a:jC2L'0\u001a3WS\u0016<H)[:qY\u0006L\u0018\u0001G7bi\u0016\u0014\u0018.\u00197ju\u0016$g+[3x\t&\u001c\b\u000f\\1zA\u0005Y\u0001.\u001a7q\t&\u001c\b\u000f\\1z+\t\tYCD\u0002i\u0003[I1!a\fn\u0003-AU\r\u001c9ESN\u0004H.Y=\u0002\u0019!,G\u000e\u001d#jgBd\u0017-\u001f\u0011\u0002\u001f9|'+Z:vYR$\u0015n\u001d9mCf,\"!a\u000e\u000f\u0007!\fI$C\u0002\u0002<5\fqBT8SKN,H\u000e\u001e#jgBd\u0017-_\u0001\u0011]>\u0014Vm];mi\u0012K7\u000f\u001d7bs\u0002\n!\u0003R#G\u0003VcEkX\"I\u000b\u000e[u\fV%N\u000bV\u0011\u00111\t\t\u0004\u0011\u0006\u0015\u0013bAA$\u0013\n\u0019\u0011J\u001c;\u0002'\u0011+e)Q+M)~\u001b\u0005*R\"L?RKU*\u0012\u0011\u000235\u000b\u0005lX*D\u0011\u0016k\u0015iX!H%\u0016+U*\u0012(U?^\u000b\u0015\nV\u0001\u001b\u001b\u0006CvlU\"I\u000b6\u000bu,Q$S\u000b\u0016kUI\u0014+`/\u0006KE\u000bI\u0001\u0012I\u00164\u0017-\u001e7u\t\u0012cE+[7f_V$XCAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\nA\u0001^5nK*\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005]#\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002%\u0011,g-Y;mi\u0012#E\nV5nK>,H\u000fI\u0001\u0007\u0019>;u)\u0012*\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=4)A\u0003tY\u001a$$.\u0003\u0003\u0002t\u00055$A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0002\u0015!#V\nT0N\u0003\u001eK5)\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006m\u0013\u0001\u00027b]\u001eLA!!\"\u0002\u0000\t11\u000b\u001e:j]\u001e\f1\u0002\u0013+N\u0019~k\u0015iR%DA\u0005yA-[:qY\u0006Lhj\u001c*fgVdG/\u0006\u0002\u0002\u000eB!\u0011qRAO\u001d\u0011\t\t*!'\u0011\u0007\u0005M\u0015*\u0004\u0002\u0002\u0016*\u0019\u0011qS#\u0002\rq\u0012xn\u001c;?\u0013\r\tY*S\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0015q\u0014\u0006\u0004\u00037K\u0015\u0001\u00053jgBd\u0017-\u001f(p%\u0016\u001cX\u000f\u001c;!\u0003i!\u0017n\u001d9mCf,\u00050Z2vi&|gn\u0015;bi&\u001cH/[2t)\u0019\ti)a*\u0002,\"9\u0011\u0011\u0016\u0012A\u0002\u00055\u0015!B9vKJL\bbBAWE\u0001\u0007\u0011qV\u0001\tKb,7-\u00138g_B!\u0011\u0011WA\\\u001b\t\t\u0019LC\u0002\u00026F\u000b1aY9m\u0013\u0011\tI,a-\u0003\u001b\u0015CXmY;uS>t\u0017J\u001c4p\u0003\u001d)\u00070Z2vi\u0016$B!!$\u0002@\"9\u0011\u0011Y\u0012A\u0002\u0005\r\u0017a\u00043fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:\u0011\t\u0005\u0015\u00171\u001c\b\u0005\u0003\u000f\f9N\u0004\u0003\u0002J\u0006Ug\u0002BAf\u0003'tA!!4\u0002R:!\u00111SAh\u0013\u0005!\u0015B\u0001\"D\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019\u0011\u0011\\\u001f\u0002%Q+\u0007\u0010\u001e\"m_\u000e\\\u0007*[3sCJ\u001c\u0007._\u0005\u0005\u0003;\fyN\u0001\nEKN\u001c'/\u001b2f\u00072,8\u000f^3s\u00076$'bAAm{Q!\u0011QRAr\u0011\u001d\t)\u000f\na\u0001\u0003O\f\u0011\u0003Z3tGJL'-Z&fsN\u0004\u0018mY3t!\u0011\t)-!;\n\t\u0005-\u0018q\u001c\u0002\u0015\t\u0016\u001c8M]5cK.+\u0017p\u001d9bG\u0016\u001c8)\u001c3\u0015\t\u00055\u0015q\u001e\u0005\b\u0003c,\u0003\u0019AAz\u00039!Wm]2sS\n,G+\u00192mKN\u0004B!!2\u0002v&!\u0011q_Ap\u0005E!Um]2sS\n,G+\u00192mKN\u001cU\u000e\u001a\u000b\u0005\u0003\u001b\u000bY\u0010C\u0004\u0002~\u001a\u0002\r!a@\u0002!\u0011,7o\u0019:jE\u0016\\U-_:qC\u000e,\u0007\u0003BAc\u0005\u0003IAAa\u0001\u0002`\n\u0019B)Z:de&\u0014WmS3zgB\f7-Z\"nI\u0006Yq-\u001a;LKf\u001c\u0006/Y2f)\u0011\tiI!\u0003\t\u000b5;\u0003\u0019A(\u0015\t\u00055%Q\u0002\u0005\b\u0005\u001fA\u0003\u0019\u0001B\t\u00035!Wm]2sS\n,G+\u00192mKB!\u0011Q\u0019B\n\u0013\u0011\u0011)\"a8\u0003!\u0011+7o\u0019:jE\u0016$\u0016M\u00197f\u00076$G\u0003BAG\u00053AqAa\u0007*\u0001\u0004\u0011i\"A\u0006eKN\u001c'/\u001b2f+\u0012#\u0006\u0003BAc\u0005?IAA!\t\u0002`\nyA)Z:de&\u0014W\rV=qK\u000ekG\r\u0006\u0003\u0002\u000e\n\u0015\u0002b\u0002B\u0014U\u0001\u0007!\u0011F\u0001\rI\u0016\u001c8M]5cKV#Ek\u001d\t\u0005\u0003\u000b\u0014Y#\u0003\u0003\u0003.\u0005}'\u0001\u0005#fg\u000e\u0014\u0018NY3UsB,7oQ7e)\u0011\tiI!\r\t\u000f\tM2\u00061\u0001\u00036\u0005\u0001B-Z:de&\u0014WMR;oGRLwN\u001c\t\u0005\u0003\u000b\u00149$\u0003\u0003\u0003:\u0005}'a\u0005#fg\u000e\u0014\u0018NY3Gk:\u001cG/[8o\u00076$G\u0003BAG\u0005{AqAa\u0010-\u0001\u0004\u0011\t%A\teKN\u001c'/\u001b2f\rVt7\r^5p]N\u0004B!!2\u0003D%!!QIAp\u0005Q!Um]2sS\n,g)\u001e8di&|gn]\"nIR!\u0011Q\u0012B%\u0011\u001d\u0011Y%\fa\u0001\u0005\u001b\n\u0011\u0003Z3tGJL'-Z!hOJ,w-\u0019;f!\u0011\t)Ma\u0014\n\t\tE\u0013q\u001c\u0002\u0015\t\u0016\u001c8M]5cK\u0006;wM]3hCR,7)\u001c3\u0015\t\u00055%Q\u000b\u0005\b\u0005/r\u0003\u0019\u0001B-\u0003I!Wm]2sS\n,\u0017iZ4sK\u001e\fG/Z:\u0011\t\u0005\u0015'1L\u0005\u0005\u0005;\nyNA\u000bEKN\u001c'/\u001b2f\u0003\u001e<'/Z4bi\u0016\u001c8)\u001c3\u0015\t\u00055%\u0011\r\u0005\b\u0005Gz\u0003\u0019\u0001B3\u0003)!Wm]2sS\n,WJ\u0016\t\u0005\u0003\u000b\u00149'\u0003\u0003\u0003j\u0005}'a\u0007#fg\u000e\u0014\u0018NY3NCR,'/[1mSj,GMV5fo\u000ekG\r\u0006\u0003\u0002\u000e\n5\u0004b\u0002B8a\u0001\u0007!\u0011O\u0001\fI\u0016\u001c8M]5cK636\u000f\u0005\u0003\u0002F\nM\u0014\u0002\u0002B;\u0003?\u0014A\u0004R3tGJL'-Z'bi\u0016\u0014\u0018.\u00197ju\u0016$g+[3xg\u000ekG\r\u0006\u0003\u0002\u000e\ne\u0004b\u0002B>c\u0001\u0007!QP\u0001\bQ\u0016d\u0007oQ7e!\u0011\t)Ma \n\t\t\u0005\u0015q\u001c\u0002\b\u0011\u0016d\u0007oQ7e\u0003A)\u00070Z2vi\u0016\u001cF/\u0019;f[\u0016tG/\u0006\u0003\u0003\b\n]E\u0003\u0002BE\u0005\u001f\u00032\u0001\u0013BF\u0013\r\u0011i)\u0013\u0002\u0004\u0003:L\bb\u0002BIe\u0001\u0007!1S\u0001\u0003gR\u0004BA!&\u0003\u00182\u0001Aa\u0002BMe\t\u0007!1\u0014\u0002\u000b'R\fG/Z7f]R$\u0016\u0003\u0002BO\u0005G\u00032\u0001\u0013BP\u0013\r\u0011\t+\u0013\u0002\b\u001d>$\b.\u001b8h!\u0019\t\tL!*\u0003\u0014&!!qUAZ\u0005%\u0019F/\u0019;f[\u0016tG/\u0006\u0003\u0003,\n=F\u0003\u0002BE\u0005[CqA!%4\u0001\u0004\u0011I\tB\u0004\u0003\u001aN\u0012\rA!-\u0012\t\tu%1\u0017\t\u0007\u0003c\u0013)K!.\u0011\t\tU%qV\u0001\u0010\u000b:D\u0017M\\2fIN+7o]5p]B\u00111-N\n\u0003k\u001d#\"A!/\u0002\u0013\u0011#Ej\u0018*F\u000f\u0016CVC\u0001Bb!\u0011\u0011)Ma4\u000e\u0005\t\u001d'\u0002\u0002Be\u0005\u0017\fQA]3hKbTAA!4\u0002\\\u0005!Q\u000f^5m\u0013\u0011\u0011\tNa2\u0003\u000fA\u000bG\u000f^3s]\u0006QA\t\u0012'`%\u0016;U\t\u0017\u0011\u0002\u001d%\u001cH\t\u0012'Ti\u0006$X-\\3oiR!!\u0011\u001cBp!\rA%1\\\u0005\u0004\u0005;L%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003SK\u0004\u0019AAG+\u0011\u0011\u0019O!;\u0015\t\te'Q\u001d\u0005\b\u0005#S\u0004\u0019\u0001Bt!\u0011\u0011)J!;\u0005\u000f\te%H1\u0001\u0003lF!!Q\u0014Bw!\u0019\t\tL!*\u0003h\u0006yq-\u001a;Dc2\u001cF/\u0019;f[\u0016tG/\u0006\u0003\u0003t\neH\u0003BAG\u0005kDqA!%<\u0001\u0004\u00119\u0010\u0005\u0003\u0003\u0016\neHa\u0002BMw\t\u0007!1`\t\u0005\u0005;\u0013i\u0010\u0005\u0004\u00022\n\u0015&q\u001f")
public class EnhancedSession {
    private final CqlSession session;
    private final DisplaySystem$ClusterDisplay$ clusterDisplay;
    private final DisplaySystem$KeyspaceDisplay$ keyspaceDisplay;
    private final DisplaySystem$TableDisplay$ tableDisplay;
    private final DisplaySystem$UDTDisplay$ udtDisplay;
    private final DisplaySystem$FunctionDisplay$ functionDisplay;
    private final DisplaySystem$AggregateDisplay$ aggregateDisplay;
    private final DisplaySystem$MaterializedViewDisplay$ materializedViewDisplay;
    private final DisplaySystem$HelpDisplay$ helpDisplay;
    private final DisplaySystem$NoResultDisplay$ noResultDisplay;
    private final int DEFAULT_CHECK_TIME;
    private final int MAX_SCHEMA_AGREEMENT_WAIT;
    private final Duration defaultDDLTimeout;
    private final Logger LOGGER;
    private final String HTML_MAGIC;
    private final String displayNoResult;

    public static <StatementT extends Statement<StatementT>> String getCqlStatement(StatementT StatementT) {
        return EnhancedSession$.MODULE$.getCqlStatement(StatementT);
    }

    public static <StatementT extends Statement<StatementT>> boolean isDDLStatement(StatementT StatementT) {
        return EnhancedSession$.MODULE$.isDDLStatement(StatementT);
    }

    public static boolean isDDLStatement(String string) {
        return EnhancedSession$.MODULE$.isDDLStatement(string);
    }

    public CqlSession session() {
        return this.session;
    }

    public DisplaySystem$ClusterDisplay$ clusterDisplay() {
        return this.clusterDisplay;
    }

    public DisplaySystem$KeyspaceDisplay$ keyspaceDisplay() {
        return this.keyspaceDisplay;
    }

    public DisplaySystem$TableDisplay$ tableDisplay() {
        return this.tableDisplay;
    }

    public DisplaySystem$UDTDisplay$ udtDisplay() {
        return this.udtDisplay;
    }

    public DisplaySystem$FunctionDisplay$ functionDisplay() {
        return this.functionDisplay;
    }

    public DisplaySystem$AggregateDisplay$ aggregateDisplay() {
        return this.aggregateDisplay;
    }

    public DisplaySystem$MaterializedViewDisplay$ materializedViewDisplay() {
        return this.materializedViewDisplay;
    }

    public DisplaySystem$HelpDisplay$ helpDisplay() {
        return this.helpDisplay;
    }

    private DisplaySystem$NoResultDisplay$ noResultDisplay() {
        return this.noResultDisplay;
    }

    private int DEFAULT_CHECK_TIME() {
        return this.DEFAULT_CHECK_TIME;
    }

    private int MAX_SCHEMA_AGREEMENT_WAIT() {
        return this.MAX_SCHEMA_AGREEMENT_WAIT;
    }

    private Duration defaultDDLTimeout() {
        return this.defaultDDLTimeout;
    }

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public String HTML_MAGIC() {
        return this.HTML_MAGIC;
    }

    public String displayNoResult() {
        return this.displayNoResult;
    }

    public String displayExecutionStatistics(String query, ExecutionInfo execInfo) {
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.noResultDisplay().noResultWithExecutionInfo(query, execInfo)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeClusterCmd describeCluster) {
        Metadata metaData = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatClusterOnly(describeCluster.statement(), metaData, this.clusterDisplay().formatClusterOnly$default$3())).toString();
    }

    private String execute(TextBlockHierarchy.DescribeKeyspacesCmd describeKeyspaces) {
        Metadata metaData = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatClusterContent(describeKeyspaces.statement(), metaData)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeTablesCmd describeTables) {
        Metadata metadata = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatAllTables(describeTables.statement(), metadata)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeKeyspaceCmd describeKeyspace) {
        String keyspace = describeKeyspace.keyspace();
        Option<KeyspaceMetadata> metadata = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.session().getMetadata().getKeyspace(keyspace)));
        Option<KeyspaceMetadata> option = metadata;
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyspaceMetadata ksMeta = (KeyspaceMetadata)some.value();
            return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.keyspaceDisplay().formatKeyspaceContent(describeKeyspace.statement(), ksMeta, this.session().getContext().getCodecRegistry())).toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(21).append("Cannot find keyspace ").append(keyspace).toString());
        }
        throw new MatchError(option);
    }

    private String getKeySpace(CqlSession session) {
        return (String)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(session.getKeyspace())).map((Function1<CqlIdentifier, String> & Serializable & scala.Serializable)x$1 -> x$1.asCql(true)).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "system");
    }

    private String execute(TextBlockHierarchy.DescribeTableCmd describeTable) {
        Metadata metaData = this.session().getMetadata();
        String tableName = describeTable.table();
        String keyspace = (String)describeTable.keyspace().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.getKeySpace(this.session()));
        Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(metaData.getKeyspace(keyspace))).flatMap((Function1<KeyspaceMetadata, Option> & Serializable & scala.Serializable)ks -> OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(ks.getTable(tableName))));
        if (option instanceof Some) {
            Some some = (Some)option;
            TableMetadata tableMeta = (TableMetadata)some.value();
            return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.tableDisplay().format(describeTable.statement(), tableMeta, true)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(19).append("Cannot find table ").append(keyspace).append(".").append(tableName).toString());
        }
        throw new MatchError(option);
    }

    private String execute(TextBlockHierarchy.DescribeTypeCmd describeUDT) {
        Metadata metaData = this.session().getMetadata();
        String keyspace = (String)describeUDT.keyspace().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.getKeySpace(this.session()));
        String udtName = describeUDT.udtName();
        Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(metaData.getKeyspace(keyspace))).flatMap((Function1<KeyspaceMetadata, Option> & Serializable & scala.Serializable)ks -> OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(ks.getUserDefinedType(udtName))));
        if (option instanceof Some) {
            Some some = (Some)option;
            UserDefinedType userType = (UserDefinedType)some.value();
            return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.udtDisplay().format(describeUDT.statement(), userType, true)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(18).append("Cannot find type ").append(keyspace).append(".").append(udtName).toString());
        }
        throw new MatchError(option);
    }

    private String execute(TextBlockHierarchy.DescribeTypesCmd describeUDTs) {
        Metadata metadata = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatAllUDTs(describeUDTs.statement(), metadata)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeFunctionCmd describeFunction) {
        Metadata metaData = this.session().getMetadata();
        String keyspaceName = (String)describeFunction.keyspace().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.getKeySpace(this.session()));
        String functionName = describeFunction.function();
        Option<KeyspaceMetadata> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(metaData.getKeyspace(keyspaceName)));
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyspaceMetadata keyspace = (KeyspaceMetadata)some.value();
            Seq<FunctionMetadata> functionMetas = ((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getFunctions()).asScala()).toSeq().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(EnhancedSession.$anonfun$execute$6(functionName, x0$1)))).map((Function1<Tuple2, FunctionMetadata> & Serializable & scala.Serializable)x$2 -> (FunctionMetadata)x$2._2(), Seq$.MODULE$.canBuildFrom());
            if (functionMetas.isEmpty()) {
                throw new InterpreterException(new StringBuilder(22).append("Cannot find function ").append(keyspaceName).append(".").append(functionName).toString());
            }
            return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.functionDisplay().format(describeFunction.statement(), functionMetas, true)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(22).append("Cannot find function ").append(keyspaceName).append(".").append(functionName).toString());
        }
        throw new MatchError(option);
    }

    private String execute(TextBlockHierarchy.DescribeFunctionsCmd describeFunctions) {
        Metadata metadata = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatAllFunctions(describeFunctions.statement(), metadata)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeAggregateCmd describeAggregate) {
        Metadata metaData = this.session().getMetadata();
        String keyspaceName = (String)describeAggregate.keyspace().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.getKeySpace(this.session()));
        String aggregateName = describeAggregate.aggregate();
        Option<KeyspaceMetadata> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(metaData.getKeyspace(keyspaceName)));
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyspaceMetadata keyspace = (KeyspaceMetadata)some.value();
            Seq<AggregateMetadata> aggMetas = ((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getAggregates()).asScala()).toSeq().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(EnhancedSession.$anonfun$execute$9(aggregateName, x0$1)))).map((Function1<Tuple2, AggregateMetadata> & Serializable & scala.Serializable)x$3 -> (AggregateMetadata)x$3._2(), Seq$.MODULE$.canBuildFrom());
            if (aggMetas.isEmpty()) {
                throw new InterpreterException(new StringBuilder(23).append("Cannot find aggregate ").append(keyspaceName).append(".").append(aggregateName).toString());
            }
            return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.aggregateDisplay().format(describeAggregate.statement(), aggMetas, true, this.session().getContext().getCodecRegistry())).toString();
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(23).append("Cannot find aggregate ").append(keyspaceName).append(".").append(aggregateName).toString());
        }
        throw new MatchError(option);
    }

    private String execute(TextBlockHierarchy.DescribeAggregatesCmd describeAggregates) {
        Metadata metadata = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatAllAggregates(describeAggregates.statement(), metadata)).toString();
    }

    private String execute(TextBlockHierarchy.DescribeMaterializedViewCmd describeMV) {
        Metadata metaData = this.session().getMetadata();
        String keyspaceName = (String)describeMV.keyspace().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.getKeySpace(this.session()));
        String viewName = describeMV.view();
        Option<KeyspaceMetadata> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(metaData.getKeyspace(keyspaceName)));
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyspaceMetadata keyspace = (KeyspaceMetadata)some.value();
            Option<ViewMetadata> viewMeta = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keyspace.getView(viewName)));
            Option<ViewMetadata> option2 = viewMeta;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                ViewMetadata vMeta = (ViewMetadata)some2.value();
                return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.materializedViewDisplay().format(describeMV.statement(), vMeta, true)).toString();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new InterpreterException(new StringBuilder(31).append("Cannot find materialized view ").append(keyspaceName).append(".").append(viewName).toString());
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new StringBuilder(31).append("Cannot find materialized view ").append(keyspaceName).append(".").append(viewName).toString());
        }
        throw new MatchError(option);
    }

    private String execute(TextBlockHierarchy.DescribeMaterializedViewsCmd describeMVs) {
        Metadata metadata = this.session().getMetadata();
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.clusterDisplay().formatAllMaterializedViews(describeMVs.statement(), metadata)).toString();
    }

    private String execute(TextBlockHierarchy.HelpCmd helpCmd) {
        return new StringBuilder(0).append(this.HTML_MAGIC()).append(this.helpDisplay().formatHelp()).toString();
    }

    private <StatementT extends Statement<StatementT>> Object executeStatement(StatementT st) {
        boolean isDDL = EnhancedSession$.MODULE$.isDDLStatement(st);
        StatementT newSt = isDDL ? st.setTimeout(this.defaultDDLTimeout()) : st;
        ResultSet rs = this.session().execute(newSt);
        if (isDDL && !rs.getExecutionInfo().isSchemaInAgreement()) {
            long startTime = System.currentTimeMillis();
            while (!this.session().checkSchemaAgreement()) {
                long sinceStart;
                Serializable serializable;
                this.LOGGER().info("Schema is still not in agreement, waiting...");
                try {
                    Thread.sleep(this.DEFAULT_CHECK_TIME());
                    serializable = BoxedUnit.UNIT;
                }
                catch (InterruptedException interruptedException) {
                    serializable = None$.MODULE$;
                }
                if ((sinceStart = (System.currentTimeMillis() - startTime) / 1000L) <= (long)this.MAX_SCHEMA_AGREEMENT_WAIT()) continue;
                throw new RuntimeException(new StringBuilder(45).append("Can't achieve schema agreement after ").append(sinceStart).append(" seconds").toString());
            }
        }
        return rs;
    }

    public <StatementT extends Statement<StatementT>> Object execute(Object st) {
        Object object = st;
        if (object instanceof TextBlockHierarchy.DescribeClusterCmd) {
            TextBlockHierarchy.DescribeClusterCmd describeClusterCmd = (TextBlockHierarchy.DescribeClusterCmd)object;
            return this.execute(describeClusterCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeKeyspaceCmd) {
            TextBlockHierarchy.DescribeKeyspaceCmd describeKeyspaceCmd = (TextBlockHierarchy.DescribeKeyspaceCmd)object;
            return this.execute(describeKeyspaceCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeKeyspacesCmd) {
            TextBlockHierarchy.DescribeKeyspacesCmd describeKeyspacesCmd = (TextBlockHierarchy.DescribeKeyspacesCmd)object;
            return this.execute(describeKeyspacesCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeTableCmd) {
            TextBlockHierarchy.DescribeTableCmd describeTableCmd = (TextBlockHierarchy.DescribeTableCmd)object;
            return this.execute(describeTableCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeTablesCmd) {
            TextBlockHierarchy.DescribeTablesCmd describeTablesCmd = (TextBlockHierarchy.DescribeTablesCmd)object;
            return this.execute(describeTablesCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeTypeCmd) {
            TextBlockHierarchy.DescribeTypeCmd describeTypeCmd = (TextBlockHierarchy.DescribeTypeCmd)object;
            return this.execute(describeTypeCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeTypesCmd) {
            TextBlockHierarchy.DescribeTypesCmd describeTypesCmd = (TextBlockHierarchy.DescribeTypesCmd)object;
            return this.execute(describeTypesCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeFunctionCmd) {
            TextBlockHierarchy.DescribeFunctionCmd describeFunctionCmd = (TextBlockHierarchy.DescribeFunctionCmd)object;
            return this.execute(describeFunctionCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeFunctionsCmd) {
            TextBlockHierarchy.DescribeFunctionsCmd describeFunctionsCmd = (TextBlockHierarchy.DescribeFunctionsCmd)object;
            return this.execute(describeFunctionsCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeAggregateCmd) {
            TextBlockHierarchy.DescribeAggregateCmd describeAggregateCmd = (TextBlockHierarchy.DescribeAggregateCmd)object;
            return this.execute(describeAggregateCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeAggregatesCmd) {
            TextBlockHierarchy.DescribeAggregatesCmd describeAggregatesCmd = (TextBlockHierarchy.DescribeAggregatesCmd)object;
            return this.execute(describeAggregatesCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeMaterializedViewCmd) {
            TextBlockHierarchy.DescribeMaterializedViewCmd describeMaterializedViewCmd = (TextBlockHierarchy.DescribeMaterializedViewCmd)object;
            return this.execute(describeMaterializedViewCmd);
        }
        if (object instanceof TextBlockHierarchy.DescribeMaterializedViewsCmd) {
            TextBlockHierarchy.DescribeMaterializedViewsCmd describeMaterializedViewsCmd = (TextBlockHierarchy.DescribeMaterializedViewsCmd)object;
            return this.execute(describeMaterializedViewsCmd);
        }
        if (object instanceof TextBlockHierarchy.HelpCmd) {
            TextBlockHierarchy.HelpCmd helpCmd = (TextBlockHierarchy.HelpCmd)object;
            return this.execute(helpCmd);
        }
        if (object instanceof Statement) {
            Statement statement = (Statement)object;
            return this.executeStatement(statement);
        }
        throw new InterpreterException(new StringBuilder(36).append("Cannot execute statement '").append(st).append("' of type ").append(st.getClass()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$execute$6(String functionName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FunctionSignature sig = (FunctionSignature)tuple2._1();
            String string = sig.getName().asCql(true).toLowerCase();
            String string2 = functionName$1.toLowerCase();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$execute$9(String aggregateName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FunctionSignature sig = (FunctionSignature)tuple2._1();
            String string = sig.getName().asCql(true).toLowerCase();
            String string2 = aggregateName$1.toLowerCase();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError(tuple2);
    }

    public EnhancedSession(CqlSession session) {
        this.session = session;
        this.clusterDisplay = DisplaySystem$ClusterDisplay$.MODULE$;
        this.keyspaceDisplay = DisplaySystem$KeyspaceDisplay$.MODULE$;
        this.tableDisplay = DisplaySystem$TableDisplay$.MODULE$;
        this.udtDisplay = DisplaySystem$UDTDisplay$.MODULE$;
        this.functionDisplay = DisplaySystem$FunctionDisplay$.MODULE$;
        this.aggregateDisplay = DisplaySystem$AggregateDisplay$.MODULE$;
        this.materializedViewDisplay = DisplaySystem$MaterializedViewDisplay$.MODULE$;
        this.helpDisplay = DisplaySystem$HelpDisplay$.MODULE$;
        this.noResultDisplay = DisplaySystem$NoResultDisplay$.MODULE$;
        this.DEFAULT_CHECK_TIME = 200;
        this.MAX_SCHEMA_AGREEMENT_WAIT = 120000;
        this.defaultDDLTimeout = Duration.ofSeconds(this.MAX_SCHEMA_AGREEMENT_WAIT() / 10000);
        this.LOGGER = LoggerFactory.getLogger(EnhancedSession.class);
        this.HTML_MAGIC = "%html \n";
        this.displayNoResult = new StringBuilder(0).append(this.HTML_MAGIC()).append(this.noResultDisplay().formatNoResult()).toString();
    }
}

