/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb;

import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Arguments {
    private static final Pattern DURATION_PATTERN = Pattern.compile("([-+]?)([0-9]+(\\.[0-9]*)?[a-z]+)+", 2);
    private static final String DURATION_MESSAGE = "Expecting a duration string for %s. But got: %s";
    private static final EnumSet<ChronoUnit> ALLOWED_PRECISION = EnumSet.of(ChronoUnit.NANOS, ChronoUnit.MICROS, ChronoUnit.MILLIS, ChronoUnit.SECONDS);

    private Arguments() {
    }

    public static String checkNonEmpty(String string, String name) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Expecting a non-empty string for " + name);
        }
        return string;
    }

    public static String checkOneCharString(String string, String name) throws IllegalArgumentException {
        if (string == null || string.length() != 1) {
            throw new IllegalArgumentException("Expecting a one char string for " + name);
        }
        return string;
    }

    public static String checkDuration(String string, String name) throws IllegalArgumentException {
        if (string == null || string.isEmpty() || !DURATION_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format(DURATION_MESSAGE, name, string));
        }
        return string;
    }

    public static String checkDurationNotRequired(String string, String name) throws IllegalArgumentException {
        if (string != null && !string.isEmpty() && !DURATION_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format(DURATION_MESSAGE, name, string));
        }
        return string;
    }

    public static void checkPositiveNumber(Number number, String name) throws IllegalArgumentException {
        if (number == null || number.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Expecting a positive number for " + name);
        }
    }

    public static void checkNotNegativeNumber(Number number, String name) throws IllegalArgumentException {
        if (number == null || number.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Expecting a positive or zero number for " + name);
        }
    }

    public static void checkNotNull(Object obj, String name) throws NullPointerException {
        Objects.requireNonNull(obj, () -> "Expecting a not null reference for " + name);
    }

    public static void checkPrecision(@Nullable ChronoUnit precision) throws IllegalArgumentException {
        if (!ALLOWED_PRECISION.contains(precision)) {
            throw new IllegalArgumentException("Precision must be one of: " + ALLOWED_PRECISION);
        }
    }
}

