/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.kyuubi;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.jdbc.JDBCInterpreter;
import org.apache.zeppelin.jdbc.kyuubi.ProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyuubiUtils.class);
    private static final int DEFAULT_QUERY_PROGRESS_INTERVAL = 1000;

    public static void startMonitorThread(Connection conn, Statement stmt, InterpreterContext context, boolean displayLog, JDBCInterpreter jdbcInterpreter) {
        KyuubiConnection kyuubiConn = (KyuubiConnection)((DelegatingConnection)((DelegatingConnection)conn).getDelegate()).getDelegate();
        KyuubiStatement kyuubiStmt = (KyuubiStatement)((DelegatingStatement)((DelegatingStatement)stmt).getDelegate()).getDelegate();
        ProgressBar progressBar = new ProgressBar();
        long queryInterval = Long.parseLong(jdbcInterpreter.getProperty("zeppelin.jdbc.kyuubi.monitor.query_interval", "1000"));
        Thread thread = new Thread(() -> {
            String jobUrlTemplate = jdbcInterpreter.getProperty("zeppelin.jdbc.kyuubi.jobUrl.template");
            boolean jobUrlExtracted = false;
            try {
                while (kyuubiStmt.hasMoreLogs() && !kyuubiStmt.isClosed() && !Thread.interrupted()) {
                    Thread.sleep(queryInterval);
                    List logs = kyuubiStmt.getExecLog();
                    String logsOutput = StringUtils.join(logs, System.lineSeparator());
                    LOGGER.debug("Kyuubi job output: {}", (Object)logsOutput);
                    boolean displayLogProperty = context.getBooleanLocalProperty("displayLog", displayLog);
                    if (displayLogProperty && !StringUtils.isBlank(logsOutput)) {
                        context.out.write(logsOutput + "\n");
                        context.out.flush();
                        progressBar.operationLogShowedToUser();
                    }
                    if (jobUrlExtracted) continue;
                    String appId = kyuubiConn.getEngineId();
                    String appUrl = kyuubiConn.getEngineUrl();
                    String jobUrl = null;
                    if (StringUtils.isNotBlank(jobUrlTemplate) && StringUtils.isNotBlank(appId)) {
                        jobUrl = jobUrlTemplate.replace("{{applicationId}}", appId);
                    } else if (StringUtils.isNotBlank(appUrl)) {
                        jobUrl = appUrl;
                    }
                    if (jobUrl == null) continue;
                    LOGGER.info("Detected Kyuubi engine URL: {}", (Object)jobUrl);
                    HashMap<String, String> infos = new HashMap<String, String>();
                    infos.put("jobUrl", jobUrl);
                    infos.put("label", "KYUUBI JOB");
                    infos.put("tooltip", "View Application Web UI");
                    infos.put("noteId", context.getNoteId());
                    infos.put("paraId", context.getParagraphId());
                    context.getIntpEventClient().onParaInfosReceived(infos);
                    jobUrlExtracted = true;
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Kyuubi monitor thread is interrupted", e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("Fail to monitor KyuubiStatement", e);
            }
            LOGGER.info("KyuubiMonitor-Thread is finished");
        });
        thread.setName("KyuubiMonitor-Thread");
        thread.setDaemon(true);
        thread.start();
        LOGGER.info("Start KyuubiMonitor-Thread for sql: {}", (Object)kyuubiStmt);
        progressBar.setInPlaceUpdateStream(kyuubiStmt, (OutputStream)context.out);
    }
}

