/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.Searcher;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.ErrorHandler;
import com.thoughtworks.qdox.library.SortedClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectBuilder {
    private final ClassLibraryBuilder classLibraryBuilder;

    public JavaProjectBuilder() {
        this.classLibraryBuilder = new SortedClassLibraryBuilder();
        this.classLibraryBuilder.appendDefaultClassLoaders();
    }

    public JavaProjectBuilder(ClassLibraryBuilder classLibraryBuilder) {
        this.classLibraryBuilder = classLibraryBuilder;
    }

    public JavaProjectBuilder setDebugLexer(boolean debugLexer) {
        this.classLibraryBuilder.setDebugLexer(debugLexer);
        return this;
    }

    public JavaProjectBuilder setDebugParser(boolean debugParser) {
        this.classLibraryBuilder.setDebugParser(debugParser);
        return this;
    }

    public JavaProjectBuilder setEncoding(String encoding) {
        this.classLibraryBuilder.setEncoding(encoding);
        return this;
    }

    public JavaProjectBuilder setErrorHandler(ErrorHandler errorHandler) {
        this.classLibraryBuilder.setErrorHander(errorHandler);
        return this;
    }

    public JavaSource addSource(File file) throws IOException {
        return this.classLibraryBuilder.addSource(file);
    }

    public JavaSource addSource(URL url) throws IOException {
        return this.classLibraryBuilder.addSource(url);
    }

    public JavaSource addSource(Reader reader) {
        return this.classLibraryBuilder.addSource(reader);
    }

    public void addSourceFolder(File sourceFolder) {
        this.classLibraryBuilder.appendSourceFolder(sourceFolder);
    }

    public void addSourceTree(File directory) {
        FileVisitor visitor = new FileVisitor(){

            public void visitFile(File badFile) {
                throw new RuntimeException("Cannot read file : " + badFile.getName());
            }
        };
        this.addSourceTree(directory, visitor);
    }

    public void addSourceTree(File directory, final FileVisitor errorHandler) {
        DirectoryScanner scanner = new DirectoryScanner(directory);
        scanner.addFilter(new SuffixFilter(".java"));
        scanner.scan(new FileVisitor(){

            public void visitFile(File currentFile) {
                try {
                    JavaProjectBuilder.this.addSource(currentFile);
                }
                catch (IOException e) {
                    errorHandler.visitFile(currentFile);
                }
            }
        });
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLibraryBuilder.appendClassLoader(classLoader);
    }

    public JavaClass getClassByName(String name) {
        return this.classLibraryBuilder.getClassLibrary().getJavaClass(name);
    }

    public Collection<JavaSource> getSources() {
        return this.classLibraryBuilder.getClassLibrary().getJavaSources();
    }

    public Collection<JavaClass> getClasses() {
        return this.classLibraryBuilder.getClassLibrary().getJavaClasses();
    }

    public JavaPackage getPackageByName(String name) {
        return this.classLibraryBuilder.getClassLibrary().getJavaPackage(name);
    }

    public Collection<JavaPackage> getPackages() {
        return this.classLibraryBuilder.getClassLibrary().getJavaPackages();
    }

    public Collection<JavaClass> search(Searcher searcher) {
        LinkedList<JavaClass> result = new LinkedList<JavaClass>();
        Collection<JavaClass> classArray = this.classLibraryBuilder.getClassLibrary().getJavaClasses();
        for (JavaClass cls : classArray) {
            if (!searcher.eval(cls)) continue;
            result.add(cls);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        try {
            out.writeObject(this.classLibraryBuilder);
        }
        finally {
            out.close();
            fos.close();
        }
    }

    public static JavaProjectBuilder load(File file) throws IOException {
        JavaProjectBuilder builder;
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        try {
            ClassLibraryBuilder libraryBuilder = (ClassLibraryBuilder)in.readObject();
            builder = new JavaProjectBuilder(libraryBuilder);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Couldn't load class : " + e.getMessage());
        }
        finally {
            in.close();
            fis.close();
        }
        return builder;
    }
}

