/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.java;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.zeppelin.java.JavaSourceFromString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticRepl {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticRepl.class);

    public static String execute(String generatedClassName, String code) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaProjectBuilder builder = new JavaProjectBuilder();
        JavaSource src = builder.addSource(new StringReader(code));
        List<JavaClass> classes = src.getClasses();
        String mainClassName = null;
        for (int i = 0; i < classes.size(); ++i) {
            boolean hasMain = false;
            for (int j = 0; j < classes.get(i).getMethods().size(); ++j) {
                if (!classes.get(i).getMethods().get(j).getName().equals("main") || !classes.get(i).getMethods().get(j).isStatic()) continue;
                mainClassName = classes.get(i).getName();
                hasMain = true;
                break;
            }
            if (hasMain) break;
        }
        if (mainClassName == null) {
            LOGGER.error("Exception for Main method", (Object)"There isn't any class containing static main method.");
            throw new Exception("There isn't any class containing static main method.");
        }
        code = code.replace(mainClassName, generatedClassName);
        JavaSourceFromString file = new JavaSourceFromString(generatedClassName, code.toString());
        List<JavaFileObject> compilationUnits = Arrays.asList(file);
        ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
        ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(baosOut);
        PrintStream newErr = new PrintStream(baosErr);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(newOut);
        System.setErr(newErr);
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, diagnostics, null, null, compilationUnits);
        boolean success = task.call();
        if (!success) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getLineNumber() == -1L) continue;
                System.err.println("line " + diagnostic.getLineNumber() + " : " + diagnostic.getMessage(null));
            }
            System.out.flush();
            System.err.flush();
            System.setOut(oldOut);
            System.setErr(oldErr);
            LOGGER.error("Exception in Interpreter while compilation", (Object)baosErr.toString());
            throw new Exception(baosErr.toString());
        }
        try {
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{new File("").toURI().toURL()});
            Class.forName(generatedClassName, true, classLoader).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{null});
            System.out.flush();
            System.err.flush();
            System.setOut(oldOut);
            System.setErr(oldErr);
            String string = baosOut.toString();
            return string;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Exception in Interpreter while execution", e);
            System.err.println(e);
            e.printStackTrace(newErr);
            throw new Exception(baosErr.toString(), e);
        }
        finally {
            System.out.flush();
            System.err.flush();
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
    }
}

