/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;
import org.apache.zeppelin.flink.FlinkScalaInterpreter;
import org.apache.zeppelin.flink.internal.FlinkILoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationModeStreamEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModeStreamEnvironment.class);
    private FlinkILoop flinkILoop;
    private FlinkScalaInterpreter flinkScalaInterpreter;

    public ApplicationModeStreamEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userClassloader, FlinkILoop flinkILoop, FlinkScalaInterpreter flinkScalaInterpreter) {
        super(executorServiceLoader, configuration, userClassloader);
        this.flinkILoop = flinkILoop;
        this.flinkScalaInterpreter = flinkScalaInterpreter;
    }

    public JobExecutionResult execute() throws Exception {
        this.updateDependencies();
        return super.execute();
    }

    public JobClient executeAsync(String jobName) throws Exception {
        this.updateDependencies();
        return super.executeAsync(jobName);
    }

    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        this.updateDependencies();
        return super.execute(streamGraph);
    }

    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        this.updateDependencies();
        return super.executeAsync(streamGraph);
    }

    private void updateDependencies() throws Exception {
        Configuration configuration = (Configuration)this.getFlinkConfiguration();
        Preconditions.checkState((boolean)configuration.getBoolean(DeploymentOptions.ATTACHED), (Object)"Only ATTACHED mode is supported by the scala shell.");
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    public Object getFlinkConfiguration() {
        if (this.flinkScalaInterpreter.getFlinkVersion().isAfterFlink114()) {
            try {
                Field configurationField = StreamExecutionEnvironment.class.getDeclaredField("configuration");
                configurationField.setAccessible(true);
                return configurationField.get((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to get configuration from StreamExecutionEnvironment", e);
            }
        }
        return super.getConfiguration();
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>();
        allJarFiles.add(jarUrl);
        for (String jar : this.flinkScalaInterpreter.getUserJars()) {
            allJarFiles.add(new File(jar).toURI().toURL());
        }
        return allJarFiles;
    }
}

