/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.IOException;
import java.util.Properties;
import org.apache.zeppelin.flink.FlinkSqlContext;
import org.apache.zeppelin.flink.FlinkSqlInterpreter;
import org.apache.zeppelin.flink.sql.AppendStreamSqlJob;
import org.apache.zeppelin.flink.sql.SingleRowStreamSqlJob;
import org.apache.zeppelin.flink.sql.UpdateStreamSqlJob;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class FlinkStreamSqlInterpreter
extends FlinkSqlInterpreter {
    public FlinkStreamSqlInterpreter(Properties properties) {
        super(properties);
    }

    @Override
    public void open() throws InterpreterException {
        super.open();
        FlinkSqlContext flinkSqlContext = new FlinkSqlContext(this.flinkInterpreter.getExecutionEnvironment().getJavaEnv(), this.flinkInterpreter.getStreamExecutionEnvironment().getJavaEnv(), this.flinkInterpreter.getJavaBatchTableEnvironment("blink"), this.flinkInterpreter.getJavaStreamTableEnvironment(), this.flinkInterpreter.getZeppelinContext(), sql -> this.callInnerSelect((String)sql));
        this.flinkInterpreter.getFlinkShims().initInnerStreamSqlInterpreter(flinkSqlContext);
    }

    public void callInnerSelect(String sql) {
        InterpreterContext context = InterpreterContext.get();
        String streamType = context.getLocalProperties().getOrDefault("type", "update");
        if (streamType.equalsIgnoreCase("single")) {
            SingleRowStreamSqlJob streamJob = new SingleRowStreamSqlJob(this.flinkInterpreter.getStreamExecutionEnvironment(), this.flinkInterpreter.getJavaStreamTableEnvironment(), this.flinkInterpreter.getJobManager(), context, this.flinkInterpreter.getDefaultParallelism(), this.flinkInterpreter.getFlinkShims());
            try {
                streamJob.run(sql);
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to run single type stream job", e);
            }
        } else if (streamType.equalsIgnoreCase("append")) {
            AppendStreamSqlJob streamJob = new AppendStreamSqlJob(this.flinkInterpreter.getStreamExecutionEnvironment(), this.flinkInterpreter.getStreamTableEnvironment(), this.flinkInterpreter.getJobManager(), context, this.flinkInterpreter.getDefaultParallelism(), this.flinkInterpreter.getFlinkShims());
            try {
                streamJob.run(sql);
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to run append type stream job", e);
            }
        } else if (streamType.equalsIgnoreCase("update")) {
            UpdateStreamSqlJob streamJob = new UpdateStreamSqlJob(this.flinkInterpreter.getStreamExecutionEnvironment(), this.flinkInterpreter.getStreamTableEnvironment(), this.flinkInterpreter.getJobManager(), context, this.flinkInterpreter.getDefaultParallelism(), this.flinkInterpreter.getFlinkShims());
            try {
                streamJob.run(sql);
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to run update type stream job", e);
            }
        } else {
            throw new RuntimeException("Unrecognized stream type: " + streamType);
        }
    }

    @Override
    public InterpreterResult runSqlList(String st, InterpreterContext context) {
        return this.flinkShims.runSqlList(st, context, false);
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    public Scheduler getScheduler() {
        int maxConcurrency = Integer.parseInt(this.getProperty("zeppelin.flink.concurrentStreamSql.max", "10"));
        return SchedulerFactory.singleton().createOrGetParallelScheduler(FlinkStreamSqlInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), maxConcurrency);
    }
}

