/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;
import org.apache.zeppelin.flink.internal.FlinkILoop;

public class ScalaShellEnvironment
extends ExecutionEnvironment {
    private final List<URL> jarFiles;
    private final FlinkILoop flinkILoop;

    public ScalaShellEnvironment(Configuration configuration, FlinkILoop flinkILoop, String ... jarFiles) {
        super(configuration);
        this.flinkILoop = (FlinkILoop)((Object)Preconditions.checkNotNull((Object)((Object)flinkILoop)));
        this.jarFiles = (List)Preconditions.checkNotNull((Object)JarUtils.getJarFiles((String[])jarFiles));
    }

    public JobClient executeAsync(String jobName) throws Exception {
        this.updateDependencies();
        return super.executeAsync(jobName);
    }

    private void updateDependencies() throws Exception {
        Configuration configuration = this.getConfiguration();
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>(this.jarFiles);
        allJarFiles.add(jarUrl);
        return allJarFiles;
    }

    public static void resetContextEnvironments() {
        ExecutionEnvironment.resetContextEnvironment();
    }
}

