/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64Dialect;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.util.collection.CharObjectMap;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;
    private final ChannelHandler http2MultiplexHandler;

    public Http2ClientUpgradeCodec(Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(null, frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(handlerName, frameCodec, upgradeToHandler, null);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this((String)null, connectionHandler);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this((String)null, connectionHandler, http2MultiplexHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this(handlerName, connectionHandler, connectionHandler, null);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this(handlerName, connectionHandler, connectionHandler, http2MultiplexHandler);
    }

    private Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler upgradeToHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this.handlerName = handlerName;
        this.connectionHandler = ObjectUtil.checkNotNull(connectionHandler, "connectionHandler");
        this.upgradeToHandler = ObjectUtil.checkNotNull(upgradeToHandler, "upgradeToHandler");
        this.http2MultiplexHandler = http2MultiplexHandler;
    }

    @Override
    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        CharSequence settingsValue = this.getSettingsHeaderValue(ctx);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)settingsValue);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        try {
            ctx.pipeline().addAfter(ctx.name(), this.handlerName, this.upgradeToHandler);
            if (this.http2MultiplexHandler != null) {
                String name = ctx.pipeline().context(this.connectionHandler).name();
                ctx.pipeline().addAfter(name, null, this.http2MultiplexHandler);
            }
            this.connectionHandler.onHttpClientUpgrade();
        }
        catch (Http2Exception e) {
            ctx.fireExceptionCaught(e);
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getSettingsHeaderValue(ChannelHandlerContext ctx) {
        String string;
        ByteBuf buf = null;
        ByteBuf encodedBuf = null;
        try {
            Http2Settings settings = this.connectionHandler.decoder().localSettings();
            int payloadLength = 6 * settings.size();
            buf = ctx.alloc().buffer(payloadLength);
            for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
                buf.writeChar(entry.key());
                buf.writeInt(((Long)entry.value()).intValue());
            }
            encodedBuf = Base64.encode(buf, Base64Dialect.URL_SAFE);
            string = encodedBuf.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            ReferenceCountUtil.release(encodedBuf);
            throw throwable;
        }
        ReferenceCountUtil.release(buf);
        ReferenceCountUtil.release(encodedBuf);
        return string;
    }
}

