/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.standard;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.InternalParseException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.ast.Assign;
import org.springframework.expression.spel.ast.BeanReference;
import org.springframework.expression.spel.ast.BooleanLiteral;
import org.springframework.expression.spel.ast.CompoundExpression;
import org.springframework.expression.spel.ast.ConstructorReference;
import org.springframework.expression.spel.ast.Elvis;
import org.springframework.expression.spel.ast.FunctionReference;
import org.springframework.expression.spel.ast.Identifier;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.InlineMap;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.MethodReference;
import org.springframework.expression.spel.ast.NullLiteral;
import org.springframework.expression.spel.ast.OpAnd;
import org.springframework.expression.spel.ast.OpDec;
import org.springframework.expression.spel.ast.OpDivide;
import org.springframework.expression.spel.ast.OpEQ;
import org.springframework.expression.spel.ast.OpGE;
import org.springframework.expression.spel.ast.OpGT;
import org.springframework.expression.spel.ast.OpInc;
import org.springframework.expression.spel.ast.OpLE;
import org.springframework.expression.spel.ast.OpLT;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.OpModulus;
import org.springframework.expression.spel.ast.OpMultiply;
import org.springframework.expression.spel.ast.OpNE;
import org.springframework.expression.spel.ast.OpOr;
import org.springframework.expression.spel.ast.OpPlus;
import org.springframework.expression.spel.ast.OperatorBetween;
import org.springframework.expression.spel.ast.OperatorInstanceof;
import org.springframework.expression.spel.ast.OperatorMatches;
import org.springframework.expression.spel.ast.OperatorNot;
import org.springframework.expression.spel.ast.OperatorPower;
import org.springframework.expression.spel.ast.Projection;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.QualifiedIdentifier;
import org.springframework.expression.spel.ast.Selection;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.expression.spel.ast.Ternary;
import org.springframework.expression.spel.ast.TypeReference;
import org.springframework.expression.spel.ast.VariableReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.Token;
import org.springframework.expression.spel.standard.TokenKind;
import org.springframework.expression.spel.standard.Tokenizer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class InternalSpelExpressionParser
extends TemplateAwareExpressionParser {
    private static final Pattern VALID_QUALIFIED_ID_PATTERN = Pattern.compile("[\\p{L}\\p{N}_$]+");
    private final SpelParserConfiguration configuration;
    private final Stack<SpelNodeImpl> constructedNodes = new Stack();
    private String expressionString;
    private List<Token> tokenStream;
    private int tokenStreamLength;
    private int tokenStreamPointer;

    public InternalSpelExpressionParser(SpelParserConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected SpelExpression doParseExpression(String expressionString, ParserContext context) throws ParseException {
        try {
            this.expressionString = expressionString;
            Tokenizer tokenizer = new Tokenizer(expressionString);
            tokenizer.process();
            this.tokenStream = tokenizer.getTokens();
            this.tokenStreamLength = this.tokenStream.size();
            this.tokenStreamPointer = 0;
            this.constructedNodes.clear();
            SpelNodeImpl ast = this.eatExpression();
            if (this.moreTokens()) {
                throw new SpelParseException(this.peekToken().startPos, SpelMessage.MORE_INPUT, this.toString(this.nextToken()));
            }
            Assert.isTrue(this.constructedNodes.isEmpty());
            return new SpelExpression(expressionString, ast, this.configuration);
        }
        catch (InternalParseException ex) {
            throw ex.getCause();
        }
    }

    private SpelNodeImpl eatExpression() {
        SpelNodeImpl expr = this.eatLogicalOrExpression();
        if (this.moreTokens()) {
            Token t = this.peekToken();
            if (t.kind == TokenKind.ASSIGN) {
                if (expr == null) {
                    expr = new NullLiteral(this.toPos(t.startPos - 1, t.endPos - 1));
                }
                this.nextToken();
                SpelNodeImpl assignedValue = this.eatLogicalOrExpression();
                return new Assign(this.toPos(t), expr, assignedValue);
            }
            if (t.kind == TokenKind.ELVIS) {
                if (expr == null) {
                    expr = new NullLiteral(this.toPos(t.startPos - 1, t.endPos - 2));
                }
                this.nextToken();
                SpelNodeImpl valueIfNull = this.eatExpression();
                if (valueIfNull == null) {
                    valueIfNull = new NullLiteral(this.toPos(t.startPos + 1, t.endPos + 1));
                }
                return new Elvis(this.toPos(t), expr, valueIfNull);
            }
            if (t.kind == TokenKind.QMARK) {
                if (expr == null) {
                    expr = new NullLiteral(this.toPos(t.startPos - 1, t.endPos - 1));
                }
                this.nextToken();
                SpelNodeImpl ifTrueExprValue = this.eatExpression();
                this.eatToken(TokenKind.COLON);
                SpelNodeImpl ifFalseExprValue = this.eatExpression();
                return new Ternary(this.toPos(t), expr, ifTrueExprValue, ifFalseExprValue);
            }
        }
        return expr;
    }

    private SpelNodeImpl eatLogicalOrExpression() {
        SpelNodeImpl expr = this.eatLogicalAndExpression();
        while (this.peekIdentifierToken("or") || this.peekToken(TokenKind.SYMBOLIC_OR)) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatLogicalAndExpression();
            this.checkOperands(t, expr, rhExpr);
            expr = new OpOr(this.toPos(t), expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatLogicalAndExpression() {
        SpelNodeImpl expr = this.eatRelationalExpression();
        while (this.peekIdentifierToken("and") || this.peekToken(TokenKind.SYMBOLIC_AND)) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatRelationalExpression();
            this.checkOperands(t, expr, rhExpr);
            expr = new OpAnd(this.toPos(t), expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatRelationalExpression() {
        SpelNodeImpl expr = this.eatSumExpression();
        Token relationalOperatorToken = this.maybeEatRelationalOperator();
        if (relationalOperatorToken != null) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatSumExpression();
            this.checkOperands(t, expr, rhExpr);
            TokenKind tk = relationalOperatorToken.kind;
            if (relationalOperatorToken.isNumericRelationalOperator()) {
                int pos = this.toPos(t);
                if (tk == TokenKind.GT) {
                    return new OpGT(pos, expr, rhExpr);
                }
                if (tk == TokenKind.LT) {
                    return new OpLT(pos, expr, rhExpr);
                }
                if (tk == TokenKind.LE) {
                    return new OpLE(pos, expr, rhExpr);
                }
                if (tk == TokenKind.GE) {
                    return new OpGE(pos, expr, rhExpr);
                }
                if (tk == TokenKind.EQ) {
                    return new OpEQ(pos, expr, rhExpr);
                }
                Assert.isTrue(tk == TokenKind.NE);
                return new OpNE(pos, expr, rhExpr);
            }
            if (tk == TokenKind.INSTANCEOF) {
                return new OperatorInstanceof(this.toPos(t), expr, rhExpr);
            }
            if (tk == TokenKind.MATCHES) {
                return new OperatorMatches(this.toPos(t), expr, rhExpr);
            }
            Assert.isTrue(tk == TokenKind.BETWEEN);
            return new OperatorBetween(this.toPos(t), expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatSumExpression() {
        SpelNodeImpl expr = this.eatProductExpression();
        while (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.INC)) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatProductExpression();
            this.checkRightOperand(t, rhExpr);
            if (t.kind == TokenKind.PLUS) {
                expr = new OpPlus(this.toPos(t), expr, rhExpr);
                continue;
            }
            if (t.kind != TokenKind.MINUS) continue;
            expr = new OpMinus(this.toPos(t), expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatProductExpression() {
        SpelNodeImpl expr = this.eatPowerIncDecExpression();
        while (this.peekToken(TokenKind.STAR, TokenKind.DIV, TokenKind.MOD)) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatPowerIncDecExpression();
            this.checkOperands(t, expr, rhExpr);
            if (t.kind == TokenKind.STAR) {
                expr = new OpMultiply(this.toPos(t), expr, rhExpr);
                continue;
            }
            if (t.kind == TokenKind.DIV) {
                expr = new OpDivide(this.toPos(t), expr, rhExpr);
                continue;
            }
            Assert.isTrue(t.kind == TokenKind.MOD);
            expr = new OpModulus(this.toPos(t), expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatPowerIncDecExpression() {
        SpelNodeImpl expr = this.eatUnaryExpression();
        if (this.peekToken(TokenKind.POWER)) {
            Token t = this.nextToken();
            SpelNodeImpl rhExpr = this.eatUnaryExpression();
            this.checkRightOperand(t, rhExpr);
            return new OperatorPower(this.toPos(t), expr, rhExpr);
        }
        if (expr != null && this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token t = this.nextToken();
            if (t.getKind() == TokenKind.INC) {
                return new OpInc(this.toPos(t), true, expr);
            }
            return new OpDec(this.toPos(t), true, expr);
        }
        return expr;
    }

    private SpelNodeImpl eatUnaryExpression() {
        if (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.NOT)) {
            Token t = this.nextToken();
            SpelNodeImpl expr = this.eatUnaryExpression();
            if (t.kind == TokenKind.NOT) {
                return new OperatorNot(this.toPos(t), expr);
            }
            if (t.kind == TokenKind.PLUS) {
                return new OpPlus(this.toPos(t), expr);
            }
            Assert.isTrue(t.kind == TokenKind.MINUS);
            return new OpMinus(this.toPos(t), expr);
        }
        if (this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token t = this.nextToken();
            SpelNodeImpl expr = this.eatUnaryExpression();
            if (t.getKind() == TokenKind.INC) {
                return new OpInc(this.toPos(t), false, expr);
            }
            return new OpDec(this.toPos(t), false, expr);
        }
        return this.eatPrimaryExpression();
    }

    private SpelNodeImpl eatPrimaryExpression() {
        ArrayList<SpelNodeImpl> nodes = new ArrayList<SpelNodeImpl>();
        SpelNodeImpl start = this.eatStartNode();
        nodes.add(start);
        while (this.maybeEatNode()) {
            nodes.add(this.pop());
        }
        if (nodes.size() == 1) {
            return (SpelNodeImpl)nodes.get(0);
        }
        return new CompoundExpression(this.toPos(start.getStartPosition(), ((SpelNodeImpl)nodes.get(nodes.size() - 1)).getEndPosition()), nodes.toArray(new SpelNodeImpl[nodes.size()]));
    }

    private boolean maybeEatNode() {
        SpelNodeImpl expr = null;
        expr = this.peekToken(TokenKind.DOT, TokenKind.SAFE_NAVI) ? this.eatDottedNode() : this.maybeEatNonDottedNode();
        if (expr == null) {
            return false;
        }
        this.push(expr);
        return true;
    }

    private SpelNodeImpl maybeEatNonDottedNode() {
        if (this.peekToken(TokenKind.LSQUARE) && this.maybeEatIndexer()) {
            return this.pop();
        }
        return null;
    }

    private SpelNodeImpl eatDottedNode() {
        boolean nullSafeNavigation;
        Token t = this.nextToken();
        boolean bl = nullSafeNavigation = t.kind == TokenKind.SAFE_NAVI;
        if (this.maybeEatMethodOrProperty(nullSafeNavigation) || this.maybeEatFunctionOrVar() || this.maybeEatProjection(nullSafeNavigation) || this.maybeEatSelection(nullSafeNavigation)) {
            return this.pop();
        }
        if (this.peekToken() == null) {
            this.raiseInternalException(t.startPos, SpelMessage.OOD, new Object[0]);
        } else {
            this.raiseInternalException(t.startPos, SpelMessage.UNEXPECTED_DATA_AFTER_DOT, this.toString(this.peekToken()));
        }
        return null;
    }

    private boolean maybeEatFunctionOrVar() {
        if (!this.peekToken(TokenKind.HASH)) {
            return false;
        }
        Token t = this.nextToken();
        Token functionOrVariableName = this.eatToken(TokenKind.IDENTIFIER);
        SpelNodeImpl[] args = this.maybeEatMethodArgs();
        if (args == null) {
            this.push(new VariableReference(functionOrVariableName.data, this.toPos(t.startPos, functionOrVariableName.endPos)));
            return true;
        }
        this.push(new FunctionReference(functionOrVariableName.data, this.toPos(t.startPos, functionOrVariableName.endPos), args));
        return true;
    }

    private SpelNodeImpl[] maybeEatMethodArgs() {
        if (!this.peekToken(TokenKind.LPAREN)) {
            return null;
        }
        ArrayList<SpelNodeImpl> args = new ArrayList<SpelNodeImpl>();
        this.consumeArguments(args);
        this.eatToken(TokenKind.RPAREN);
        return args.toArray(new SpelNodeImpl[args.size()]);
    }

    private void eatConstructorArgs(List<SpelNodeImpl> accumulatedArguments) {
        if (!this.peekToken(TokenKind.LPAREN)) {
            throw new InternalParseException(new SpelParseException(this.expressionString, this.positionOf(this.peekToken()), SpelMessage.MISSING_CONSTRUCTOR_ARGS, new Object[0]));
        }
        this.consumeArguments(accumulatedArguments);
        this.eatToken(TokenKind.RPAREN);
    }

    private void consumeArguments(List<SpelNodeImpl> accumulatedArguments) {
        Token next;
        int pos = this.peekToken().startPos;
        do {
            this.nextToken();
            Token t = this.peekToken();
            if (t == null) {
                this.raiseInternalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
            }
            if (t.kind == TokenKind.RPAREN) continue;
            accumulatedArguments.add(this.eatExpression());
        } while ((next = this.peekToken()) != null && next.kind == TokenKind.COMMA);
        if (next == null) {
            this.raiseInternalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
        }
    }

    private int positionOf(Token t) {
        if (t == null) {
            return this.expressionString.length();
        }
        return t.startPos;
    }

    private SpelNodeImpl eatStartNode() {
        if (this.maybeEatLiteral()) {
            return this.pop();
        }
        if (this.maybeEatParenExpression()) {
            return this.pop();
        }
        if (this.maybeEatTypeReference() || this.maybeEatNullReference() || this.maybeEatConstructorReference() || this.maybeEatMethodOrProperty(false) || this.maybeEatFunctionOrVar()) {
            return this.pop();
        }
        if (this.maybeEatBeanReference()) {
            return this.pop();
        }
        if (this.maybeEatProjection(false) || this.maybeEatSelection(false) || this.maybeEatIndexer()) {
            return this.pop();
        }
        if (this.maybeEatInlineListOrMap()) {
            return this.pop();
        }
        return null;
    }

    private boolean maybeEatBeanReference() {
        if (this.peekToken(TokenKind.BEAN_REF) || this.peekToken(TokenKind.FACTORY_BEAN_REF)) {
            Token beanRefToken = this.nextToken();
            Token beanNameToken = null;
            String beanName = null;
            if (this.peekToken(TokenKind.IDENTIFIER)) {
                beanNameToken = this.eatToken(TokenKind.IDENTIFIER);
                beanName = beanNameToken.data;
            } else if (this.peekToken(TokenKind.LITERAL_STRING)) {
                beanNameToken = this.eatToken(TokenKind.LITERAL_STRING);
                beanName = beanNameToken.stringValue();
                beanName = beanName.substring(1, beanName.length() - 1);
            } else {
                this.raiseInternalException(beanRefToken.startPos, SpelMessage.INVALID_BEAN_REFERENCE, new Object[0]);
            }
            BeanReference beanReference = null;
            if (beanRefToken.getKind() == TokenKind.FACTORY_BEAN_REF) {
                String beanNameString = TokenKind.FACTORY_BEAN_REF.tokenChars + beanName;
                beanReference = new BeanReference(this.toPos(beanRefToken.startPos, beanNameToken.endPos), beanNameString);
            } else {
                beanReference = new BeanReference(this.toPos(beanNameToken), beanName);
            }
            this.constructedNodes.push(beanReference);
            return true;
        }
        return false;
    }

    private boolean maybeEatTypeReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token typeName = this.peekToken();
            if (!typeName.stringValue().equals("T")) {
                return false;
            }
            Token t = this.nextToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, t.data, this.toPos(t)));
                return true;
            }
            this.eatToken(TokenKind.LPAREN);
            SpelNodeImpl node = this.eatPossiblyQualifiedId();
            int dims = 0;
            while (this.peekToken(TokenKind.LSQUARE, true)) {
                this.eatToken(TokenKind.RSQUARE);
                ++dims;
            }
            this.eatToken(TokenKind.RPAREN);
            this.constructedNodes.push(new TypeReference(this.toPos(typeName), node, dims));
            return true;
        }
        return false;
    }

    private boolean maybeEatNullReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token nullToken = this.peekToken();
            if (!nullToken.stringValue().equalsIgnoreCase("null")) {
                return false;
            }
            this.nextToken();
            this.constructedNodes.push(new NullLiteral(this.toPos(nullToken)));
            return true;
        }
        return false;
    }

    private boolean maybeEatProjection(boolean nullSafeNavigation) {
        Token t = this.peekToken();
        if (!this.peekToken(TokenKind.PROJECT, true)) {
            return false;
        }
        SpelNodeImpl expr = this.eatExpression();
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Projection(nullSafeNavigation, this.toPos(t), expr));
        return true;
    }

    private boolean maybeEatInlineListOrMap() {
        Token t = this.peekToken();
        if (!this.peekToken(TokenKind.LCURLY, true)) {
            return false;
        }
        SpelNodeImpl expr = null;
        Token closingCurly = this.peekToken();
        if (this.peekToken(TokenKind.RCURLY, true)) {
            expr = new InlineList(this.toPos(t.startPos, closingCurly.endPos), new SpelNodeImpl[0]);
        } else if (this.peekToken(TokenKind.COLON, true)) {
            closingCurly = this.eatToken(TokenKind.RCURLY);
            expr = new InlineMap(this.toPos(t.startPos, closingCurly.endPos), new SpelNodeImpl[0]);
        } else {
            SpelNodeImpl firstExpression = this.eatExpression();
            if (this.peekToken(TokenKind.RCURLY)) {
                ArrayList<SpelNodeImpl> listElements = new ArrayList<SpelNodeImpl>();
                listElements.add(firstExpression);
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineList(this.toPos(t.startPos, closingCurly.endPos), listElements.toArray(new SpelNodeImpl[listElements.size()]));
            } else if (this.peekToken(TokenKind.COMMA, true)) {
                ArrayList<SpelNodeImpl> listElements = new ArrayList<SpelNodeImpl>();
                listElements.add(firstExpression);
                do {
                    listElements.add(this.eatExpression());
                } while (this.peekToken(TokenKind.COMMA, true));
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineList(this.toPos(t.startPos, closingCurly.endPos), listElements.toArray(new SpelNodeImpl[listElements.size()]));
            } else if (this.peekToken(TokenKind.COLON, true)) {
                ArrayList<SpelNodeImpl> mapElements = new ArrayList<SpelNodeImpl>();
                mapElements.add(firstExpression);
                mapElements.add(this.eatExpression());
                while (this.peekToken(TokenKind.COMMA, true)) {
                    mapElements.add(this.eatExpression());
                    this.eatToken(TokenKind.COLON);
                    mapElements.add(this.eatExpression());
                }
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineMap(this.toPos(t.startPos, closingCurly.endPos), mapElements.toArray(new SpelNodeImpl[mapElements.size()]));
            } else {
                this.raiseInternalException(t.startPos, SpelMessage.OOD, new Object[0]);
            }
        }
        this.constructedNodes.push(expr);
        return true;
    }

    private boolean maybeEatIndexer() {
        Token t = this.peekToken();
        if (!this.peekToken(TokenKind.LSQUARE, true)) {
            return false;
        }
        SpelNodeImpl expr = this.eatExpression();
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Indexer(this.toPos(t), expr));
        return true;
    }

    private boolean maybeEatSelection(boolean nullSafeNavigation) {
        Token t = this.peekToken();
        if (!this.peekSelectToken()) {
            return false;
        }
        this.nextToken();
        SpelNodeImpl expr = this.eatExpression();
        if (expr == null) {
            this.raiseInternalException(this.toPos(t), SpelMessage.MISSING_SELECTION_EXPRESSION, new Object[0]);
        }
        this.eatToken(TokenKind.RSQUARE);
        if (t.kind == TokenKind.SELECT_FIRST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 1, this.toPos(t), expr));
        } else if (t.kind == TokenKind.SELECT_LAST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 2, this.toPos(t), expr));
        } else {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 0, this.toPos(t), expr));
        }
        return true;
    }

    private SpelNodeImpl eatPossiblyQualifiedId() {
        LinkedList<Identifier> qualifiedIdPieces = new LinkedList<Identifier>();
        Token node = this.peekToken();
        while (this.isValidQualifiedId(node)) {
            this.nextToken();
            if (node.kind != TokenKind.DOT) {
                qualifiedIdPieces.add(new Identifier(node.stringValue(), this.toPos(node)));
            }
            node = this.peekToken();
        }
        if (qualifiedIdPieces.isEmpty()) {
            if (node == null) {
                this.raiseInternalException(this.expressionString.length(), SpelMessage.OOD, new Object[0]);
            }
            this.raiseInternalException(node.startPos, SpelMessage.NOT_EXPECTED_TOKEN, "qualified ID", node.getKind().toString().toLowerCase());
        }
        int pos = this.toPos(((SpelNodeImpl)qualifiedIdPieces.getFirst()).getStartPosition(), ((SpelNodeImpl)qualifiedIdPieces.getLast()).getEndPosition());
        return new QualifiedIdentifier(pos, qualifiedIdPieces.toArray(new SpelNodeImpl[qualifiedIdPieces.size()]));
    }

    private boolean isValidQualifiedId(Token node) {
        if (node == null || node.kind == TokenKind.LITERAL_STRING) {
            return false;
        }
        if (node.kind == TokenKind.DOT || node.kind == TokenKind.IDENTIFIER) {
            return true;
        }
        String value = node.stringValue();
        return StringUtils.hasLength(value) && VALID_QUALIFIED_ID_PATTERN.matcher(value).matches();
    }

    private boolean maybeEatMethodOrProperty(boolean nullSafeNavigation) {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token methodOrPropertyName = this.nextToken();
            SpelNodeImpl[] args = this.maybeEatMethodArgs();
            if (args == null) {
                this.push(new PropertyOrFieldReference(nullSafeNavigation, methodOrPropertyName.data, this.toPos(methodOrPropertyName)));
                return true;
            }
            this.push(new MethodReference(nullSafeNavigation, methodOrPropertyName.data, this.toPos(methodOrPropertyName), args));
            return true;
        }
        return false;
    }

    private boolean maybeEatConstructorReference() {
        if (this.peekIdentifierToken("new")) {
            Token newToken = this.nextToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, newToken.data, this.toPos(newToken)));
                return true;
            }
            SpelNodeImpl possiblyQualifiedConstructorName = this.eatPossiblyQualifiedId();
            ArrayList<SpelNodeImpl> nodes = new ArrayList<SpelNodeImpl>();
            nodes.add(possiblyQualifiedConstructorName);
            if (this.peekToken(TokenKind.LSQUARE)) {
                ArrayList<SpelNodeImpl> dimensions = new ArrayList<SpelNodeImpl>();
                while (this.peekToken(TokenKind.LSQUARE, true)) {
                    if (!this.peekToken(TokenKind.RSQUARE)) {
                        dimensions.add(this.eatExpression());
                    } else {
                        dimensions.add(null);
                    }
                    this.eatToken(TokenKind.RSQUARE);
                }
                if (this.maybeEatInlineListOrMap()) {
                    nodes.add(this.pop());
                }
                this.push(new ConstructorReference(this.toPos(newToken), dimensions.toArray(new SpelNodeImpl[dimensions.size()]), nodes.toArray(new SpelNodeImpl[nodes.size()])));
            } else {
                this.eatConstructorArgs(nodes);
                this.push(new ConstructorReference(this.toPos(newToken), nodes.toArray(new SpelNodeImpl[nodes.size()])));
            }
            return true;
        }
        return false;
    }

    private void push(SpelNodeImpl newNode) {
        this.constructedNodes.push(newNode);
    }

    private SpelNodeImpl pop() {
        return this.constructedNodes.pop();
    }

    private boolean maybeEatLiteral() {
        Token t = this.peekToken();
        if (t == null) {
            return false;
        }
        if (t.kind == TokenKind.LITERAL_INT) {
            this.push(Literal.getIntLiteral(t.data, this.toPos(t), 10));
        } else if (t.kind == TokenKind.LITERAL_LONG) {
            this.push(Literal.getLongLiteral(t.data, this.toPos(t), 10));
        } else if (t.kind == TokenKind.LITERAL_HEXINT) {
            this.push(Literal.getIntLiteral(t.data, this.toPos(t), 16));
        } else if (t.kind == TokenKind.LITERAL_HEXLONG) {
            this.push(Literal.getLongLiteral(t.data, this.toPos(t), 16));
        } else if (t.kind == TokenKind.LITERAL_REAL) {
            this.push(Literal.getRealLiteral(t.data, this.toPos(t), false));
        } else if (t.kind == TokenKind.LITERAL_REAL_FLOAT) {
            this.push(Literal.getRealLiteral(t.data, this.toPos(t), true));
        } else if (this.peekIdentifierToken("true")) {
            this.push(new BooleanLiteral(t.data, this.toPos(t), true));
        } else if (this.peekIdentifierToken("false")) {
            this.push(new BooleanLiteral(t.data, this.toPos(t), false));
        } else if (t.kind == TokenKind.LITERAL_STRING) {
            this.push(new StringLiteral(t.data, this.toPos(t), t.data));
        } else {
            return false;
        }
        this.nextToken();
        return true;
    }

    private boolean maybeEatParenExpression() {
        if (this.peekToken(TokenKind.LPAREN)) {
            this.nextToken();
            SpelNodeImpl expr = this.eatExpression();
            this.eatToken(TokenKind.RPAREN);
            this.push(expr);
            return true;
        }
        return false;
    }

    private Token maybeEatRelationalOperator() {
        Token t = this.peekToken();
        if (t == null) {
            return null;
        }
        if (t.isNumericRelationalOperator()) {
            return t;
        }
        if (t.isIdentifier()) {
            String idString = t.stringValue();
            if (idString.equalsIgnoreCase("instanceof")) {
                return t.asInstanceOfToken();
            }
            if (idString.equalsIgnoreCase("matches")) {
                return t.asMatchesToken();
            }
            if (idString.equalsIgnoreCase("between")) {
                return t.asBetweenToken();
            }
        }
        return null;
    }

    private Token eatToken(TokenKind expectedKind) {
        Token t = this.nextToken();
        if (t == null) {
            this.raiseInternalException(this.expressionString.length(), SpelMessage.OOD, new Object[0]);
        }
        if (t.kind != expectedKind) {
            this.raiseInternalException(t.startPos, SpelMessage.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t.getKind().toString().toLowerCase());
        }
        return t;
    }

    private boolean peekToken(TokenKind desiredTokenKind) {
        return this.peekToken(desiredTokenKind, false);
    }

    private boolean peekToken(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        if (t.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.tokenStreamPointer;
            }
            return true;
        }
        return desiredTokenKind == TokenKind.IDENTIFIER && t.kind.ordinal() >= TokenKind.DIV.ordinal() && t.kind.ordinal() <= TokenKind.NOT.ordinal() && t.data != null;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        return t.kind == possible1 || t.kind == possible2;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2, TokenKind possible3) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        return t.kind == possible1 || t.kind == possible2 || t.kind == possible3;
    }

    private boolean peekIdentifierToken(String identifierString) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        return t.kind == TokenKind.IDENTIFIER && t.stringValue().equalsIgnoreCase(identifierString);
    }

    private boolean peekSelectToken() {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        return t.kind == TokenKind.SELECT || t.kind == TokenKind.SELECT_FIRST || t.kind == TokenKind.SELECT_LAST;
    }

    private boolean moreTokens() {
        return this.tokenStreamPointer < this.tokenStream.size();
    }

    private Token nextToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token peekToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer);
    }

    private void raiseInternalException(int pos, SpelMessage message, Object ... inserts) {
        throw new InternalParseException(new SpelParseException(this.expressionString, pos, message, inserts));
    }

    public String toString(Token t) {
        if (t.getKind().hasPayload()) {
            return t.stringValue();
        }
        return t.kind.toString().toLowerCase();
    }

    private void checkOperands(Token token, SpelNodeImpl left, SpelNodeImpl right) {
        this.checkLeftOperand(token, left);
        this.checkRightOperand(token, right);
    }

    private void checkLeftOperand(Token token, SpelNodeImpl operandExpression) {
        if (operandExpression == null) {
            this.raiseInternalException(token.startPos, SpelMessage.LEFT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private void checkRightOperand(Token token, SpelNodeImpl operandExpression) {
        if (operandExpression == null) {
            this.raiseInternalException(token.startPos, SpelMessage.RIGHT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private int toPos(Token t) {
        return (t.startPos << 16) + t.endPos;
    }

    private int toPos(int start, int end) {
        return (start << 16) + end;
    }
}

