/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.bigquery;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Joiner;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigQueryInterpreter.class);
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static Bigquery service = null;
    private static Object serviceLock = new Object();
    static final String PROJECT_ID = "zeppelin.bigquery.project_id";
    static final String WAIT_TIME = "zeppelin.bigquery.wait_time";
    static final String MAX_ROWS = "zeppelin.bigquery.max_no_of_rows";
    static final String SQL_DIALECT = "zeppelin.bigquery.sql_dialect";
    static final String REGION = "zeppelin.bigquery.region";
    private static String jobId = null;
    private static String projectId = null;
    private static final List NO_COMPLETION = new ArrayList();
    private Exception exceptionOnConnect;
    private static final Function<CharSequence, String> sequenceToStringTransformer = new Function<CharSequence, String>(){

        @Override
        public String apply(CharSequence seq) {
            return seq.toString();
        }
    };

    public BigQueryInterpreter(Properties property) {
        super(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        if (service == null) {
            Object object = serviceLock;
            synchronized (object) {
                if (service == null) {
                    try {
                        service = BigQueryInterpreter.createAuthorizedClient();
                        this.exceptionOnConnect = null;
                        LOGGER.info("Opened BigQuery SQL Connection");
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot open connection", e);
                        this.exceptionOnConnect = e;
                        this.close();
                    }
                }
            }
        }
    }

    private static Bigquery createAuthorizedClient() throws IOException {
        NetHttpTransport transport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleCredential credential = GoogleCredential.getApplicationDefault(transport, jsonFactory);
        if (credential.createScopedRequired()) {
            Set<String> bigqueryScopes = BigqueryScopes.all();
            credential = credential.createScoped(bigqueryScopes);
        }
        return new Bigquery.Builder(transport, jsonFactory, credential).setApplicationName("Zeppelin/1.0 (GPN:Apache Zeppelin;)").build();
    }

    public static String printRows(GetQueryResultsResponse response) {
        StringBuilder msg = new StringBuilder();
        try {
            ArrayList<String> schemNames = new ArrayList<String>();
            for (TableFieldSchema schem : response.getSchema().getFields()) {
                schemNames.add(schem.getName());
            }
            msg.append(Joiner.on('\t').join(schemNames));
            msg.append('\n');
            for (TableRow row : response.getRows()) {
                ArrayList<String> fieldValues = new ArrayList<String>();
                for (TableCell field : row.getF()) {
                    fieldValues.add(field.getV().toString());
                }
                msg.append(Joiner.on('\t').join(fieldValues));
                msg.append('\n');
            }
            return msg.toString();
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("SQL Execution returned an error!");
        }
    }

    public static Job pollJob(Bigquery.Jobs.Get request, long interval) throws IOException, InterruptedException {
        Job job = (Job)request.execute();
        while (!job.getStatus().getState().equals("DONE")) {
            System.out.println("Job is " + job.getStatus().getState() + " waiting " + interval + " milliseconds...");
            Thread.sleep(interval);
            job = (Job)request.execute();
        }
        return job;
    }

    public static <T extends GenericJson> Iterator<T> getPages(BigqueryRequest<T> requestTemplate) {
        class PageIterator
        implements Iterator<T> {
            private BigqueryRequest<T> request;
            private boolean hasNext = true;

            PageIterator(BigqueryRequest<T> requestTemplate) {
                this.request = requestTemplate;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                try {
                    GenericJson response = (GenericJson)this.request.execute();
                    if (response.containsKey("pageToken")) {
                        this.request = this.request.set("pageToken", response.get("pageToken"));
                    } else {
                        this.hasNext = false;
                    }
                    return response;
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public void remove() {
                this.next();
            }
        }
        return new PageIterator(requestTemplate);
    }

    private InterpreterResult executeSql(String sql) {
        Iterator<GetQueryResultsResponse> pages;
        Boolean useLegacySql;
        boolean counter = false;
        StringBuilder finalmessage = null;
        finalmessage = new StringBuilder("%table ");
        String projId = this.getProperty(PROJECT_ID);
        long wTime = Long.parseLong(this.getProperty(WAIT_TIME));
        long maxRows = Long.parseLong(this.getProperty(MAX_ROWS));
        String sqlDialect = this.getProperty(SQL_DIALECT, "").toLowerCase();
        String region = this.getProperty(REGION, null);
        switch (sqlDialect) {
            case "standardsql": {
                useLegacySql = false;
                break;
            }
            case "legacysql": {
                useLegacySql = true;
                break;
            }
            default: {
                useLegacySql = null;
            }
        }
        try {
            pages = BigQueryInterpreter.run(sql, projId, wTime, maxRows, useLegacySql, region);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage());
            return new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage());
        }
        try {
            while (pages.hasNext()) {
                finalmessage.append(BigQueryInterpreter.printRows(pages.next()));
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, finalmessage.toString());
        }
        catch (NullPointerException ex) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage());
        }
    }

    public static Iterator<GetQueryResultsResponse> run(String queryString, String projId, long wTime, long maxRows, Boolean useLegacySql, String region) throws IOException {
        LOGGER.info("Use legacy sql: {}", (Object)useLegacySql);
        QueryResponse query = (QueryResponse)service.jobs().query(projId, new QueryRequest().setTimeoutMs(wTime).setUseLegacySql(useLegacySql).setQuery(queryString).setMaxResults(maxRows)).execute();
        jobId = query.getJobReference().getJobId();
        projectId = query.getJobReference().getProjectId();
        Bigquery.Jobs.GetQueryResults getRequest = service.jobs().getQueryResults(projectId, jobId);
        if (StringUtils.isNotBlank(region)) {
            getRequest = getRequest.setLocation(region);
        }
        return BigQueryInterpreter.getPages(getRequest);
    }

    public void close() {
        LOGGER.info("Close bqsql connection!");
        service = null;
    }

    public InterpreterResult interpret(String sql, InterpreterContext contextInterpreter) {
        LOGGER.info("Run SQL command '{}'", (Object)sql);
        return this.executeSql(sql);
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(BigQueryInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public void cancel(InterpreterContext context) {
        LOGGER.info("Trying to Cancel current query statement.");
        if (service != null && jobId != null && projectId != null) {
            try {
                Bigquery.Jobs.Cancel request = service.jobs().cancel(projectId, jobId);
                JobCancelResponse response = (JobCancelResponse)request.execute();
                jobId = null;
                LOGGER.info("Query Execution cancelled");
            }
            catch (IOException ex) {
                LOGGER.error("Could not cancel the SQL execution");
            }
        } else {
            LOGGER.info("Query Execution was already cancelled");
        }
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return NO_COMPLETION;
    }
}

