/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.zeppelin.interpreter.remote.RemoteClientFactory;
import org.apache.zeppelin.interpreter.remote.SupplierWithIO;
import org.apache.zeppelin.interpreter.thrift.InterpreterRPCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.apache.commons.pool2.impl.DefaultEvictionPolicy;
import shaded.org.apache.zeppelin.org.apache.commons.pool2.impl.GenericObjectPool;
import shaded.org.apache.zeppelin.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import shaded.org.apache.zeppelin.org.apache.thrift.TException;
import shaded.org.apache.zeppelin.org.apache.thrift.TServiceClient;

public class PooledRemoteClient<T extends TServiceClient>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledRemoteClient.class);
    private static final int RETRY_COUNT = 3;
    private GenericObjectPool<T> clientPool;
    private RemoteClientFactory<T> remoteClientFactory;

    public PooledRemoteClient(SupplierWithIO<T> supplier, int connectionPoolSize) {
        this.remoteClientFactory = new RemoteClientFactory<T>(supplier);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(connectionPoolSize);
        poolConfig.setMaxIdle(connectionPoolSize);
        poolConfig.setEvictionPolicyClassName(DefaultEvictionPolicy.class.getName());
        this.clientPool = new GenericObjectPool<T>(this.remoteClientFactory, poolConfig);
    }

    public PooledRemoteClient(SupplierWithIO<T> supplier) {
        this(supplier, 10);
    }

    public synchronized T getClient() throws Exception {
        return (T)((TServiceClient)this.clientPool.borrowObject(5000L));
    }

    @Override
    public void close() {
        if (this.remoteClientFactory != null) {
            this.remoteClientFactory.close();
            this.remoteClientFactory = null;
        }
        if (this.clientPool != null) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    private void releaseClient(T client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject(client);
            }
            catch (Exception e) {
                LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
            }
        }
    }

    private void releaseBrokenClient(T client) {
        try {
            LOGGER.warn("release broken client");
            this.clientPool.invalidateObject(client);
        }
        catch (Exception e) {
            LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callRemoteFunction(RemoteFunction<R, T> func) {
        boolean broken = false;
        String errorCause = null;
        for (int i = 0; i < 3; ++i) {
            T client = null;
            broken = false;
            try {
                client = this.getClient();
                if (client == null) continue;
                R r = func.call(client);
                return r;
            }
            catch (InterpreterRPCException e) {
                broken = true;
                errorCause = e.getErrorMessage();
                break;
            }
            catch (Exception e1) {
                broken = true;
                continue;
            }
            finally {
                if (client != null) {
                    this.releaseClient(client, broken);
                }
            }
        }
        if (broken) {
            throw new RuntimeException(errorCause);
        }
        return null;
    }

    public static interface RemoteFunction<R, T> {
        public R call(T var1) throws InterpreterRPCException, TException;
    }
}

