/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import javax.inject.Provider;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;
import shaded.org.apache.zeppelin.com.google.inject.spi.TypeEncounter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.annotations.Configuration;

final class PlexusConfigurations {
    private final Provider<PlexusBeanConverter> converterProvider;

    PlexusConfigurations(TypeEncounter<?> encounter) {
        this.converterProvider = encounter.getProvider(PlexusBeanConverter.class);
    }

    public <T> Provider<T> lookup(Configuration configuration, BeanProperty<T> property) {
        return new ConfigurationProvider<T>(this.converterProvider, property.getType(), configuration.value());
    }

    private static final class ConfigurationProvider<T>
    implements Provider<T> {
        private final Provider<PlexusBeanConverter> converterProvider;
        private final TypeLiteral<T> type;
        private final String value;

        ConfigurationProvider(Provider<PlexusBeanConverter> converterProvider, TypeLiteral<T> type, String value) {
            this.converterProvider = converterProvider;
            this.type = type;
            this.value = value;
        }

        @Override
        public T get() {
            return this.converterProvider.get().convert(this.type, this.value);
        }
    }
}

