/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import javax.inject.Provider;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;
import org.eclipse.sisu.plexus.OptionalPropertyBinding;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusConfigurations;
import org.eclipse.sisu.plexus.PlexusRequirements;
import org.eclipse.sisu.plexus.ProvidedPropertyBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.TypeEncounter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.annotations.Configuration;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.annotations.Requirement;

final class PlexusPropertyBinder
implements PropertyBinder {
    private static final boolean OPTIONAL_SUPPORTED;
    private final BeanManager manager;
    private final PlexusBeanMetadata metadata;
    private final PlexusConfigurations configurations;
    private final PlexusRequirements requirements;

    static {
        boolean optionalSupported = true;
        try {
            Requirement.class.getDeclaredMethod("optional", new Class[0]);
        }
        catch (Exception exception) {
            optionalSupported = false;
        }
        catch (LinkageError linkageError) {
            optionalSupported = false;
        }
        OPTIONAL_SUPPORTED = optionalSupported;
    }

    PlexusPropertyBinder(BeanManager manager, TypeEncounter<?> encounter, PlexusBeanMetadata metadata) {
        this.manager = manager;
        this.metadata = metadata;
        this.configurations = new PlexusConfigurations(encounter);
        this.requirements = new PlexusRequirements(encounter);
    }

    @Override
    public <T> PropertyBinding bindProperty(BeanProperty<T> property) {
        if (this.metadata.isEmpty()) {
            return PropertyBinder.LAST_BINDING;
        }
        Configuration configuration = this.metadata.getConfiguration(property);
        if (configuration != null) {
            Provider<T> valueProvider = this.configurations.lookup(configuration, property);
            return new ProvidedPropertyBinding<T>(property, valueProvider);
        }
        Requirement requirement = this.metadata.getRequirement(property);
        if (requirement != null) {
            PropertyBinding managedBinding;
            if (this.manager != null && (managedBinding = this.manager.manage(property)) != null) {
                return managedBinding;
            }
            Provider<T> roleProvider = this.requirements.lookup(requirement, property);
            if (OPTIONAL_SUPPORTED && requirement.optional()) {
                return new OptionalPropertyBinding<T>(property, roleProvider);
            }
            return new ProvidedPropertyBinding<T>(property, roleProvider);
        }
        return null;
    }
}

