/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.apache.http.impl.io;

import java.io.IOException;
import shaded.org.apache.zeppelin.org.apache.http.Header;
import shaded.org.apache.zeppelin.org.apache.http.HeaderIterator;
import shaded.org.apache.zeppelin.org.apache.http.HttpException;
import shaded.org.apache.zeppelin.org.apache.http.HttpMessage;
import shaded.org.apache.zeppelin.org.apache.http.annotation.NotThreadSafe;
import shaded.org.apache.zeppelin.org.apache.http.io.HttpMessageWriter;
import shaded.org.apache.zeppelin.org.apache.http.io.SessionOutputBuffer;
import shaded.org.apache.zeppelin.org.apache.http.message.BasicLineFormatter;
import shaded.org.apache.zeppelin.org.apache.http.message.LineFormatter;
import shaded.org.apache.zeppelin.org.apache.http.params.HttpParams;
import shaded.org.apache.zeppelin.org.apache.http.util.Args;
import shaded.org.apache.zeppelin.org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

