/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.lookup;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sisu.inject.Weak;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.StringBuilderConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;

public final class DefaultConverterLookup
implements ConverterLookup {
    private static final ConfigurationConverter[] DEFAULT_CONVERTERS = new ConfigurationConverter[]{new FileConverter(), new BooleanConverter(), new StringConverter(), new IntConverter(), new CollectionConverter(), new ArrayConverter(), new MapConverter(), new PropertiesConverter(), new UrlConverter(), new UriConverter(), new DateConverter(), new EnumConverter(), new LongConverter(), new FloatConverter(), new DoubleConverter(), new CharConverter(), new ByteConverter(), new ShortConverter(), new PlexusConfigurationConverter(), new ClassRealmConverter(), new StringBufferConverter(), new StringBuilderConverter(), new ObjectWithFieldsConverter()};
    private final Map<Class<?>, ConfigurationConverter> lookupCache = Weak.concurrentKeys();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();

    @Override
    public void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookupCache.get(type);
        if (converter != null) {
            return converter;
        }
        int i = 0;
        while (i < this.customConverters.size()) {
            converter = this.customConverters.get(i);
            if (converter.canConvert(type)) {
                this.lookupCache.put(type, converter);
                return converter;
            }
            ++i;
        }
        i = 0;
        while (i < DEFAULT_CONVERTERS.length) {
            converter = DEFAULT_CONVERTERS[i];
            if (converter.canConvert(type)) {
                this.lookupCache.put(type, converter);
                return converter;
            }
            ++i;
        }
        throw new ComponentConfigurationException("Cannot find converter for type: " + type);
    }

    void setCustomConverters(List<ConfigurationConverter> converters) {
        this.customConverters.addAll(converters);
    }
}

