/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.eclipse.aether.RepositorySystemSession;
import shaded.org.apache.zeppelin.org.eclipse.aether.impl.RepositoryConnectorProvider;
import shaded.org.apache.zeppelin.org.eclipse.aether.internal.impl.PrioritizedComponent;
import shaded.org.apache.zeppelin.org.eclipse.aether.internal.impl.PrioritizedComponents;
import shaded.org.apache.zeppelin.org.eclipse.aether.internal.impl.Utils;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.Authentication;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.Proxy;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.connector.RepositoryConnector;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.locator.Service;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.apache.zeppelin.org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryConnectorProvider.class);
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    public DefaultRepositoryConnectorProvider() {
    }

    @Inject
    DefaultRepositoryConnectorProvider(Set<RepositoryConnectorFactory> connectorFactories) {
        this.setRepositoryConnectorFactories(connectorFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        this.connectorFactories.add(Objects.requireNonNull(factory, "repository connector factory cannot be null"));
        return this;
    }

    public DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<RepositoryConnectorFactory> factories = new PrioritizedComponents<RepositoryConnectorFactory>(session);
        for (RepositoryConnectorFactory factory : this.connectorFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                RepositoryConnector repositoryConnector = ((RepositoryConnectorFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(repositoryConnector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, repositoryConnector);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                return repositoryConnector;
            }
            catch (NoRepositoryConnectorException noRepositoryConnectorException) {
                errors.add(noRepositoryConnectorException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain connector factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No connector factories available");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available connector factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

