/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonUnflattener {
    private static final String arrayIndex = "\\[\\s*\\d+\\s*\\]";
    private static final String objectComplexKey = "\\[\\s*\".*\"\\s*\\]";
    private static final String objectKey = "[^\\.\\[\\]]+";
    private static final Pattern keyPartPattern = Pattern.compile("\\[\\s*\\d+\\s*\\]|\\[\\s*\".*\"\\s*\\]|[^\\.\\[\\]]+");

    private JsonUnflattener() {
    }

    public static String unflatten(String json) {
        JsonValue root = Json.parse(json);
        if (root.isArray()) {
            return root.asArray().toString();
        }
        JsonObject flattened = root.asObject();
        JsonObject unflattened = flattened.names().isEmpty() ? Json.object() : null;
        for (String key : flattened.names()) {
            JsonValue currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = keyPartPattern.matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (JsonUnflattener.isJsonArray(keyPart)) {
                        currentVal = JsonUnflattener.findOrCreateJsonArray(currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                    } else {
                        currentVal = JsonUnflattener.findOrCreateJsonObject(currentVal, objKey, aryIdx);
                        objKey = JsonUnflattener.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (JsonUnflattener.isJsonArray(keyPart)) {
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.array();
                        }
                    } else {
                        objKey = JsonUnflattener.extractKey(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.object();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            JsonUnflattener.setUnflattenedValue(flattened, key, currentVal, objKey, aryIdx);
        }
        return unflattened.toString();
    }

    private static String extractKey(String keyPart) {
        if (keyPart.matches(objectComplexKey)) {
            return keyPart.replaceAll("^\\[\\s*\"", "").replaceAll("\"\\s*\\]$", "");
        }
        return keyPart;
    }

    private static Integer extractIndex(String keyPart) {
        return Integer.valueOf(keyPart.replaceAll("[\\[\\]\\s]", ""));
    }

    private static boolean isJsonArray(String keyPart) {
        return keyPart.matches(arrayIndex);
    }

    private static JsonValue findOrCreateJsonArray(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonValue ary = Json.array();
                jsonObj.add(objKey, ary);
                return ary;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx).equals(Json.NULL)) {
            JsonValue ary = Json.array();
            JsonUnflattener.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set((int)aryIdx, ary);
            return ary;
        }
        return jsonAry.get(aryIdx);
    }

    private static JsonValue findOrCreateJsonObject(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonObject obj = Json.object();
                jsonObj.add(objKey, obj);
                return obj;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx).equals(Json.NULL)) {
            JsonObject obj = Json.object();
            JsonUnflattener.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set((int)aryIdx, obj);
            return obj;
        }
        return jsonAry.get(aryIdx);
    }

    private static void setUnflattenedValue(JsonObject flattened, String key, JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            currentVal.asObject().add(objKey, flattened.get(key));
        } else {
            JsonUnflattener.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set((int)aryIdx, flattened.get(key));
        }
    }

    private static void assureJsonArraySize(JsonArray jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add(Json.NULL);
        }
    }
}

