/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.HashFunction;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class IndexMetaData
implements Diffable<IndexMetaData>,
FromXContentBuilder<IndexMetaData>,
ToXContent {
    public static final IndexMetaData PROTO = IndexMetaData.builder("").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).build();
    public static Map<String, Custom> customPrototypes = new HashMap<String, Custom>();
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK;
    public static final ClusterBlock INDEX_READ_BLOCK;
    public static final ClusterBlock INDEX_WRITE_BLOCK;
    public static final ClusterBlock INDEX_METADATA_BLOCK;
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String SETTING_SHADOW_REPLICAS = "index.shadow_replicas";
    public static final String SETTING_SHARED_FILESYSTEM = "index.shared_filesystem";
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final String SETTING_READ_ONLY = "index.blocks.read_only";
    public static final String SETTING_BLOCKS_READ = "index.blocks.read";
    public static final String SETTING_BLOCKS_WRITE = "index.blocks.write";
    public static final String SETTING_BLOCKS_METADATA = "index.blocks.metadata";
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_VERSION_MINIMUM_COMPATIBLE = "index.version.minimum_compatible";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_LEGACY_ROUTING_HASH_FUNCTION = "index.legacy.routing.hash.type";
    public static final String SETTING_LEGACY_ROUTING_USE_TYPE = "index.legacy.routing.use_type";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final String SETTING_SHARED_FS_ALLOW_RECOVERY_ON_ANY_NODE = "index.shared_filesystem.recover_on_any_node";
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    private static final HashFunction MURMUR3_HASH_FUNCTION;
    private final String index;
    private final long version;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final Settings settings;
    private final ImmutableOpenMap<String, MappingMetaData> mappings;
    private final ImmutableOpenMap<String, Custom> customs;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final Version indexCreatedVersion;
    private final Version indexUpgradedVersion;
    private final org.apache.lucene.util.Version minimumCompatibleLuceneVersion;
    private final HashFunction routingHashFunction;
    private final boolean useTypeForRouting;

    public static void registerPrototype(String type, Custom proto) {
        customPrototypes.put(type, proto);
    }

    @Nullable
    public static <T extends Custom> T lookupPrototype(String type) {
        return (T)customPrototypes.get(type);
    }

    public static <T extends Custom> T lookupPrototypeSafe(String type) {
        Custom proto = customPrototypes.get(type);
        if (proto == null) {
            throw new IllegalArgumentException("No custom metadata prototype registered for type [" + type + "]");
        }
        return (T)proto;
    }

    private IndexMetaData(String index, long version, State state, Settings settings, ImmutableOpenMap<String, MappingMetaData> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, Custom> customs) {
        Integer maybeNumberOfShards = settings.getAsInt(SETTING_NUMBER_OF_SHARDS, null);
        if (maybeNumberOfShards == null) {
            throw new IllegalArgumentException("must specify numberOfShards for index [" + index + "]");
        }
        int numberOfShards = maybeNumberOfShards;
        if (numberOfShards <= 0) {
            throw new IllegalArgumentException("must specify positive number of shards for index [" + index + "]");
        }
        Integer maybeNumberOfReplicas = settings.getAsInt(SETTING_NUMBER_OF_REPLICAS, null);
        if (maybeNumberOfReplicas == null) {
            throw new IllegalArgumentException("must specify numberOfReplicas for index [" + index + "]");
        }
        int numberOfReplicas = maybeNumberOfReplicas;
        if (numberOfReplicas < 0) {
            throw new IllegalArgumentException("must specify non-negative number of shards for index [" + index + "]");
        }
        this.index = index;
        this.version = version;
        this.state = state;
        this.settings = settings;
        this.mappings = mappings;
        this.customs = customs;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.aliases = aliases;
        Map<String, String> requireMap = settings.getByPrefix("index.routing.allocation.require.").getAsMap();
        this.requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
        Map<String, String> includeMap = settings.getByPrefix("index.routing.allocation.include.").getAsMap();
        this.includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
        Map<String, String> excludeMap = settings.getByPrefix("index.routing.allocation.exclude.").getAsMap();
        this.excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
        this.indexCreatedVersion = Version.indexCreated(settings);
        this.indexUpgradedVersion = settings.getAsVersion(SETTING_VERSION_UPGRADED, this.indexCreatedVersion);
        String stringLuceneVersion = settings.get(SETTING_VERSION_MINIMUM_COMPATIBLE);
        if (stringLuceneVersion != null) {
            try {
                this.minimumCompatibleLuceneVersion = org.apache.lucene.util.Version.parse(stringLuceneVersion);
            }
            catch (ParseException ex) {
                throw new IllegalStateException("Cannot parse lucene version [" + stringLuceneVersion + "] in the [" + SETTING_VERSION_MINIMUM_COMPATIBLE + "] setting", ex);
            }
        } else {
            this.minimumCompatibleLuceneVersion = null;
        }
        String hashFunction = settings.get(SETTING_LEGACY_ROUTING_HASH_FUNCTION);
        if (hashFunction == null) {
            this.routingHashFunction = MURMUR3_HASH_FUNCTION;
        } else {
            Class<HashFunction> hashFunctionClass;
            try {
                hashFunctionClass = Class.forName(hashFunction).asSubclass(HashFunction.class);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new ElasticsearchException("failed to load custom hash function [" + hashFunction + "]", e, new Object[0]);
            }
            try {
                this.routingHashFunction = hashFunctionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate hash function", e);
            }
        }
        this.useTypeForRouting = settings.getAsBoolean(SETTING_LEGACY_ROUTING_USE_TYPE, (Boolean)false);
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.settings.get(SETTING_INDEX_UUID, INDEX_UUID_NA_VALUE);
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public Version getUpgradeVersion() {
        return this.indexUpgradedVersion;
    }

    public org.apache.lucene.util.Version getMinimumCompatibleVersion() {
        return this.minimumCompatibleLuceneVersion;
    }

    public HashFunction getRoutingHashFunction() {
        return this.routingHashFunction;
    }

    public boolean getRoutingUseType() {
        return this.useTypeForRouting;
    }

    public long getCreationDate() {
        return this.settings.getAsLong(SETTING_CREATION_DATE, (Long)-1L);
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, MappingMetaData> getMappings() {
        return this.mappings;
    }

    @Nullable
    public MappingMetaData mapping(String mappingType) {
        return this.mappings.get(mappingType);
    }

    @Nullable
    public MappingMetaData mappingOrDefault(String mappingType) {
        MappingMetaData mapping = this.mappings.get(mappingType);
        if (mapping != null) {
            return mapping;
        }
        return this.mappings.get("_default_");
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetaData that = (IndexMetaData)o;
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        return this.customs.equals(that.customs);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    @Override
    public Diff<IndexMetaData> diff(IndexMetaData previousState) {
        return new IndexMetaDataDiff(previousState, this);
    }

    @Override
    public Diff<IndexMetaData> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetaDataDiff(in);
    }

    @Override
    public IndexMetaData fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    @Override
    public IndexMetaData readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetaData mappingMd = MappingMetaData.PROTO.readFrom(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetaData aliasMd = AliasMetaData.Builder.readFrom(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            Custom customIndexMetaData = (Custom)IndexMetaData.lookupPrototypeSafe(type).readFrom(in);
            builder.putCustom(type, customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeLong(this.version);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
            ((MappingMetaData)objectCursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectCursor<AbstractDiffable> objectCursor : this.aliases.values()) {
            ((AliasMetaData)objectCursor.value).writeTo(out);
        }
        out.writeVInt(this.customs.size());
        for (ObjectObjectCursor objectObjectCursor : this.customs) {
            out.writeString((String)objectObjectCursor.key);
            ((Custom)objectObjectCursor.value).writeTo(out);
        }
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetaData indexMetaData) {
        return new Builder(indexMetaData);
    }

    public static boolean isOnSharedFilesystem(Settings settings) {
        return settings.getAsBoolean(SETTING_SHARED_FILESYSTEM, (Boolean)IndexMetaData.isIndexUsingShadowReplicas(settings));
    }

    public static boolean isIndexUsingShadowReplicas(Settings settings) {
        return settings.getAsBoolean(SETTING_SHADOW_REPLICAS, (Boolean)false);
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Version versionUpgraded;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = settings.getAsVersion(SETTING_VERSION_CREATED, null);
        if (version != null) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((versionUpgraded = settings.getAsVersion(SETTING_VERSION_UPGRADED, null)) != null) {
            builder.put(SETTING_VERSION_UPGRADED_STRING, versionUpgraded.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            DateTime creationDateTime = new DateTime((Object)creationDate, DateTimeZone.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    static {
        IndexMetaData.registerPrototype("warmers", IndexWarmersMetaData.PROTO);
        INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
        INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
        INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
        INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
        MURMUR3_HASH_FUNCTION = new Murmur3HashFunction();
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, MappingMetaData> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder(String index) {
            this.index = index;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(IndexMetaData indexMetaData) {
            this.index = indexMetaData.getIndex();
            this.state = indexMetaData.state;
            this.version = indexMetaData.version;
            this.settings = indexMetaData.getSettings();
            this.mappings = ImmutableOpenMap.builder(indexMetaData.mappings);
            this.aliases = ImmutableOpenMap.builder(indexMetaData.aliases);
            this.customs = ImmutableOpenMap.builder(indexMetaData.customs);
        }

        public String index() {
            return this.index;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, (Integer)-1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public int numberOfReplicas() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, (Integer)-1);
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public long creationDate() {
            return this.settings.getAsLong(IndexMetaData.SETTING_CREATION_DATE, (Long)-1L);
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetaData mapping(String type) {
            return this.mappings.get(type);
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(String type, String source) throws IOException {
            try (XContentParser parser = XContentFactory.xContent(source).createParser(source);){
                this.putMapping(new MappingMetaData(type, parser.mapOrdered()));
            }
            return this;
        }

        public Builder putMapping(MappingMetaData mappingMd) {
            this.mappings.put(mappingMd.type(), mappingMd);
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Custom customIndexMetaData) {
            this.customs.put(type, customIndexMetaData);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public IndexMetaData build() {
            ImmutableOpenMap.Builder<String, AliasMetaData> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            if (this.mappings.containsKey("_default_")) {
                MappingMetaData defaultMapping = this.mappings.get("_default_");
                for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
                    ((MappingMetaData)objectCursor.value).updateDefaultMapping(defaultMapping);
                }
            }
            return new IndexMetaData(this.index, this.version, this.state, tmpSettings, this.mappings.build(), tmpAliases.build(), this.customs.build());
        }

        public static void toXContent(IndexMetaData indexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetaData.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("version", indexMetaData.getVersion());
            builder.field("state", indexMetaData.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject("settings");
            for (Map.Entry<String, String> entry : indexMetaData.getSettings().getAsMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
            builder.startArray("mappings");
            for (ObjectObjectCursor objectObjectCursor : indexMetaData.getMappings()) {
                if (binary) {
                    builder.value(((MappingMetaData)objectObjectCursor.value).source().compressed());
                    continue;
                }
                byte[] data = ((MappingMetaData)objectObjectCursor.value).source().uncompressed();
                XContentParser parser = XContentFactory.xContent(data).createParser(data);
                Map<String, Object> mapping = parser.mapOrdered();
                parser.close();
                builder.map(mapping);
            }
            builder.endArray();
            for (ObjectObjectCursor objectObjectCursor : indexMetaData.getCustoms()) {
                builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                ((Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.startObject("aliases");
            for (ObjectCursor objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.settings(Settings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())));
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(new MappingMetaData(mappingType, mappingSource));
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    Object proto = IndexMetaData.lookupPrototype(currentFieldName);
                    if (proto == null) {
                        parser.skipChildren();
                        continue;
                    }
                    Custom custom = proto.fromXContent(parser);
                    builder.putCustom(custom.type(), custom);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                            builder.putMapping(new MappingMetaData(new CompressedXContent(parser.binaryValue())));
                            continue;
                        }
                        Map<String, Object> mapping = parser.mapOrdered();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        builder.putMapping(new MappingMetaData(mappingType, mapping));
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("state".equals(currentFieldName)) {
                    builder.state(State.fromString(parser.text()));
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.longValue());
            }
            return builder.build();
        }

        public static IndexMetaData readFrom(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }
    }

    private static class IndexMetaDataDiff
    implements Diff<IndexMetaData> {
        private final String index;
        private final long version;
        private final State state;
        private final Settings settings;
        private final Diff<ImmutableOpenMap<String, MappingMetaData>> mappings;
        private final Diff<ImmutableOpenMap<String, AliasMetaData>> aliases;
        private Diff<ImmutableOpenMap<String, Custom>> customs;

        public IndexMetaDataDiff(IndexMetaData before, IndexMetaData after) {
            this.index = after.index;
            this.version = after.version;
            this.state = after.state;
            this.settings = after.settings;
            this.mappings = DiffableUtils.diff(before.mappings, after.mappings);
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases);
            this.customs = DiffableUtils.diff(before.customs, after.customs);
        }

        public IndexMetaDataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.version = in.readLong();
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.mappings = DiffableUtils.readImmutableOpenMapDiff(in, MappingMetaData.PROTO);
            this.aliases = DiffableUtils.readImmutableOpenMapDiff(in, AliasMetaData.PROTO);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, new DiffableUtils.KeyedReader<Custom>(){

                @Override
                public Custom readFrom(StreamInput in, String key) throws IOException {
                    return (Custom)IndexMetaData.lookupPrototypeSafe(key).readFrom(in);
                }

                @Override
                public Diff<Custom> readDiffFrom(StreamInput in, String key) throws IOException {
                    return IndexMetaData.lookupPrototypeSafe(key).readDiffFrom(in);
                }
            });
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeLong(this.version);
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public IndexMetaData apply(IndexMetaData part) {
            Builder builder = IndexMetaData.builder(this.index);
            builder.version(this.version);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.mappings.putAll((Iterable)this.mappings.apply(part.mappings));
            builder.aliases.putAll((Iterable)this.aliases.apply(part.aliases));
            builder.customs.putAll((Iterable)this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }

    public static interface Custom
    extends Diffable<Custom>,
    ToXContent {
        public String type();

        public Custom fromMap(Map<String, Object> var1) throws IOException;

        public Custom fromXContent(XContentParser var1) throws IOException;

        public Custom mergeWith(Custom var1);
    }
}

