/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.IndexSearcherWrapper;
import org.elasticsearch.index.engine.IndexSearcherWrappingService;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShadowIndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.StoreRecoveryService;
import org.elasticsearch.index.termvectors.ShardTermVectorsService;
import org.elasticsearch.index.translog.TranslogService;

public class IndexShardModule
extends AbstractModule {
    private final ShardId shardId;
    private final Settings settings;
    private final boolean primary;
    Class<? extends EngineFactory> engineFactoryImpl = InternalEngineFactory.class;

    public IndexShardModule(ShardId shardId, boolean primary, Settings settings) {
        this.settings = settings;
        this.shardId = shardId;
        this.primary = primary;
        if (settings.get("index.translog.type") != null) {
            throw new IllegalStateException("a custom translog type is no longer supported. got [" + settings.get("index.translog.type") + "]");
        }
    }

    protected boolean useShadowEngine() {
        return !this.primary && IndexMetaData.isIndexUsingShadowReplicas(this.settings);
    }

    @Override
    protected void configure() {
        this.bind(ShardId.class).toInstance(this.shardId);
        if (this.useShadowEngine()) {
            this.bind(IndexShard.class).to(ShadowIndexShard.class).asEagerSingleton();
        } else {
            this.bind(IndexShard.class).asEagerSingleton();
            this.bind(TranslogService.class).asEagerSingleton();
        }
        this.bind(EngineFactory.class).to(this.engineFactoryImpl);
        this.bind(StoreRecoveryService.class).asEagerSingleton();
        this.bind(ShardPercolateService.class).asEagerSingleton();
        this.bind(ShardTermVectorsService.class).asEagerSingleton();
        this.bind(IndexSearcherWrappingService.class).asEagerSingleton();
        Multibinder<IndexSearcherWrapper> multibinder = Multibinder.newSetBinder(this.binder(), IndexSearcherWrapper.class);
    }
}

