/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

public abstract class LeafBucketCollector
implements LeafCollector {
    public static final LeafBucketCollector NO_OP_COLLECTOR = new LeafBucketCollector(){

        @Override
        public void setScorer(Scorer arg0) throws IOException {
        }

        @Override
        public void collect(int doc, long bucket) {
        }
    };

    public static LeafBucketCollector wrap(Iterable<LeafBucketCollector> collectors) {
        Iterable<LeafBucketCollector> actualCollectors = Iterables.filter(collectors, new Predicate<LeafBucketCollector>(){

            @Override
            public boolean apply(LeafBucketCollector c) {
                return c != NO_OP_COLLECTOR;
            }
        });
        final LeafBucketCollector[] colls = Iterables.toArray(actualCollectors, LeafBucketCollector.class);
        switch (colls.length) {
            case 0: {
                return NO_OP_COLLECTOR;
            }
            case 1: {
                return colls[0];
            }
        }
        return new LeafBucketCollector(){

            @Override
            public void setScorer(Scorer s) throws IOException {
                for (LeafBucketCollector c : colls) {
                    c.setScorer(s);
                }
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                for (LeafBucketCollector c : colls) {
                    c.collect(doc, bucket);
                }
            }
        };
    }

    public abstract void collect(int var1, long var2) throws IOException;

    @Override
    public final void collect(int doc) throws IOException {
        this.collect(doc, 0L);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }
}

