/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class SignificantStringTermsAggregator
extends StringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;

    public SignificantStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, valuesSource, null, bucketCountThresholds, includeExclude, aggregationContext, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST, false, pipelineAggregators, metaData);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                super.collect(doc, bucket);
                ++SignificantStringTermsAggregator.this.numCollectedDocs;
            }
        };
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.prepareBackground(this.context);
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            int docCount = this.bucketDocCount(i);
            if ((long)docCount >= this.bucketCountThresholds.getShardMinDocCount()) {
                if (spare == null) {
                    spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null);
                }
                this.bucketOrds.get(i, spare.termBytes);
                spare.subsetDf = docCount;
                spare.subsetSize = subsetSize;
                spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
                spare.supersetSize = supersetSize;
                spare.updateScore(this.termsAggFactory.getSignificanceHeuristic());
                spare.bucketOrd = i;
                spare = ordered.insertWithOverflow(spare);
            }
            ++i;
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new SignificantStringTerms(subsetSize, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Arrays.asList(list), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(0L, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Collections.emptyList(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds, this.termsAggFactory);
    }
}

