/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.hbase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseInterpreter
extends Interpreter {
    public static final String HBASE_HOME = "hbase.home";
    public static final String HBASE_RUBY_SRC = "hbase.ruby.sources";
    public static final String HBASE_TEST_MODE = "zeppelin.hbase.test.mode";
    private static final Logger LOGGER = LoggerFactory.getLogger(HbaseInterpreter.class);
    private ScriptingContainer scriptingContainer;
    private StringWriter writer;

    public HbaseInterpreter(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        this.scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETON);
        this.writer = new StringWriter();
        this.scriptingContainer.setOutput(this.writer);
        if (!Boolean.parseBoolean(this.getProperty(HBASE_TEST_MODE))) {
            String hbaseHome = this.getProperty(HBASE_HOME);
            String rubySrc = this.getProperty(HBASE_RUBY_SRC);
            Path absRubySrc = Paths.get(hbaseHome, rubySrc).toAbsolutePath();
            LOGGER.info("Home:" + hbaseHome);
            LOGGER.info("Ruby Src:" + rubySrc);
            File f = absRubySrc.toFile();
            if (!f.exists() || !f.isDirectory()) {
                throw new InterpreterException("HBase ruby sources is not available at '" + absRubySrc + "'");
            }
            LOGGER.info("Absolute Ruby Source:" + absRubySrc.toString());
            Properties sysProps = System.getProperties();
            sysProps.setProperty(HBASE_RUBY_SRC, absRubySrc.toString());
            Path absHirbPath = Paths.get(hbaseHome, "bin/hirb.rb");
            try {
                FileInputStream fis = new FileInputStream(absHirbPath.toFile());
                this.scriptingContainer.runScriptlet(fis, "hirb.rb");
                fis.close();
            }
            catch (IOException e) {
                throw new InterpreterException(e.getCause());
            }
        }
    }

    public void close() {
        if (this.scriptingContainer != null) {
            this.scriptingContainer.terminate();
        }
    }

    public InterpreterResult interpret(String cmd, InterpreterContext interpreterContext) {
        try {
            LOGGER.info(cmd);
            this.writer.getBuffer().setLength(0);
            this.scriptingContainer.runScriptlet(cmd);
            this.writer.flush();
            LOGGER.debug(this.writer.toString());
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, this.writer.getBuffer().toString());
        }
        catch (Throwable t) {
            LOGGER.error("Can not run '" + cmd + "'", t);
            return new InterpreterResult(InterpreterResult.Code.ERROR, t.getMessage());
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(HbaseInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    private static String getSystemDefault(String envName, String propertyName, String defaultValue) {
        String propValue;
        String envValue;
        if (envName != null && !envName.isEmpty() && (envValue = System.getenv().get(envName)) != null) {
            return envValue;
        }
        if (propertyName != null && !propertyName.isEmpty() && (propValue = System.getProperty(propertyName)) != null) {
            return propValue;
        }
        return defaultValue;
    }
}

