/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi;

import com.openhtmltopdf.bidi.BidiSplitter;
import com.openhtmltopdf.bidi.BidiTextRun;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.layout.LayoutContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ParagraphSplitter {
    private List<Paragraph> allParagraphs;
    private Map<Text, Paragraph> paragraphs;
    private Map<Element, Paragraph> blocks;

    public static byte convertDirectionIdent(IdentValue ident) {
        if (ident == IdentValue.RTL) {
            return 1;
        }
        return 0;
    }

    public Paragraph lookupParagraph(Text node) {
        return this.paragraphs.isEmpty() ? this.allParagraphs.get(0) : this.paragraphs.get(node);
    }

    public Paragraph lookupBlockElement(Element elem) {
        return this.blocks.isEmpty() ? this.allParagraphs.get(0) : this.blocks.get(elem);
    }

    public void splitRoot(LayoutContext c, Document doc) {
        Paragraph parent;
        boolean isLiveImplementation = c.getBidiReorderer().isLiveImplementation();
        CalculatedStyle style = c.getSharedContext().getStyle(doc.getDocumentElement());
        IdentValue direction = style.getDirection();
        Paragraph paragraph = parent = isLiveImplementation ? new Paragraph(direction) : new FakeParagraph(direction);
        if (isLiveImplementation) {
            this.allParagraphs = new ArrayList<Paragraph>();
            this.paragraphs = new HashMap<Text, Paragraph>();
            this.blocks = new HashMap<Element, Paragraph>();
            this.splitParagraphs(c, doc, parent);
        } else {
            this.allParagraphs = Collections.singletonList(parent);
            this.paragraphs = Collections.emptyMap();
            this.blocks = Collections.emptyMap();
        }
    }

    public void runBidiOnParagraphs(LayoutContext c) {
        for (Paragraph p : this.allParagraphs) {
            p.runBidiSplitter(c.getBidiSplitterFactory().createBidiSplitter(), c);
        }
    }

    private void splitParagraphs(LayoutContext c, Node parent, Paragraph nearestBlock) {
        ReplacedElementFactory reFactory = c.getReplacedElementFactory();
        Node node = parent.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            Element element;
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                String text = ((Text)node).getData();
                nearestBlock.add(text, (Text)node);
                this.paragraphs.put((Text)node, nearestBlock);
                continue;
            }
            if (node.getNodeType() != 1 || (element = (Element)node).getNodeName().equals("head") || reFactory.isReplacedElement(element)) continue;
            CalculatedStyle style = c.getSharedContext().getStyle(element);
            if (style.isParagraphContainerForBidi() || element.hasAttribute("dir") || element.getNodeName().equals("bdi")) {
                Paragraph para = new Paragraph(style.getDirection());
                this.allParagraphs.add(para);
                this.blocks.put(element, para);
                this.splitParagraphs(c, element, para);
                continue;
            }
            this.blocks.put(element, nearestBlock);
            this.splitParagraphs(c, element, nearestBlock);
        } while ((node = node.getNextSibling()) != null);
    }

    public static class FakeParagraph
    extends Paragraph {
        private FakeParagraph(IdentValue direction) {
            super(direction, false);
        }

        @Override
        protected void add(String text, Text textNode) {
        }

        @Override
        public byte getActualDirection() {
            return this.cssDirection == IdentValue.RTL ? (byte)1 : 0;
        }

        @Override
        public BidiTextRun nextSplit(int startIndexInParagraph) {
            return null;
        }

        @Override
        public BidiTextRun prevSplit(int startIndexInParagraph) {
            return null;
        }

        @Override
        protected void runBidiSplitter(BidiSplitter splitter, LayoutContext c) {
        }
    }

    public static class Paragraph {
        private final StringBuilder builder;
        private final TreeMap<Integer, BidiTextRun> splitPoints;
        protected final Map<Text, Integer> textRuns = new HashMap<Text, Integer>();
        protected final IdentValue cssDirection;
        private byte actualDirection = 0;

        private Paragraph(IdentValue direction) {
            this(direction, true);
        }

        private Paragraph(IdentValue direction, boolean isLiveImplementation) {
            this.builder = isLiveImplementation ? new StringBuilder() : null;
            this.splitPoints = isLiveImplementation ? new TreeMap() : null;
            this.cssDirection = direction;
        }

        protected void add(String text, Text textNode) {
            int startIndex = this.builder.length();
            this.builder.append(text);
            this.textRuns.put(textNode, startIndex);
        }

        protected void runBidiSplitter(BidiSplitter splitter, LayoutContext c) {
            int defaultDirection = 0;
            String para = this.builder.toString();
            if (this.cssDirection == IdentValue.RTL) {
                defaultDirection = 1;
            } else if (this.cssDirection == IdentValue.AUTO) {
                defaultDirection = splitter.getBaseDirection(para);
            }
            this.actualDirection = (byte)(defaultDirection == 3 ? 0 : defaultDirection);
            splitter.setParagraph(para, this.actualDirection);
            this.copySplitPointsFromBidiSplitter(splitter);
        }

        public int getFirstCharIndexInParagraph(Text text) {
            if (this.textRuns.isEmpty()) {
                return -1;
            }
            Integer trun = this.textRuns.get(text);
            return trun == null ? -1 : trun;
        }

        private void copySplitPointsFromBidiSplitter(BidiSplitter splitter) {
            int length = splitter.countTextRuns();
            for (int i = 0; i < length; ++i) {
                BidiTextRun run = splitter.getVisualRun(i);
                this.splitPoints.put(run.getStart(), run);
            }
        }

        public BidiTextRun nextSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.ceilingEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }

        public BidiTextRun prevSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.floorEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }

        public byte getActualDirection() {
            return this.actualDirection;
        }

        public IdentValue getCSSDirection() {
            return this.cssDirection;
        }
    }
}

