/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class PythonUtils {
    public static String sparkPythonPath() {
        ArrayList<Object> pythonPath = new ArrayList<Object>();
        String sparkHome = System.getenv("SPARK_HOME");
        String zeppelinHome = System.getenv("ZEPPELIN_HOME");
        if (zeppelinHome == null) {
            zeppelinHome = new File("..").getAbsolutePath();
        }
        if (sparkHome != null) {
            File pyspark = new File(sparkHome, "python/lib/pyspark.zip");
            if (!pyspark.exists()) {
                throw new RuntimeException("No pyspark.zip found under " + sparkHome + "/python/lib");
            }
            pythonPath.add(pyspark.getAbsolutePath());
            File[] py4j = new File(sparkHome + "/python/lib").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("py4j");
                }
            });
            if (py4j.length == 0) {
                throw new RuntimeException("No py4j files found under " + sparkHome + "/python/lib");
            }
            if (py4j.length > 1) {
                throw new RuntimeException("Multiple py4j files found under " + sparkHome + "/python/lib");
            }
            pythonPath.add(py4j[0].getAbsolutePath());
        } else {
            File pyspark = new File(zeppelinHome, "interpreter/spark/pyspark/pyspark.zip");
            if (!pyspark.exists()) {
                throw new RuntimeException("No pyspark.zip found: " + pyspark.getAbsolutePath());
            }
            pythonPath.add(pyspark.getAbsolutePath());
            File[] py4j = new File(zeppelinHome, "interpreter/spark/pyspark").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("py4j");
                }
            });
            if (py4j.length == 0) {
                throw new RuntimeException("No py4j files found under " + zeppelinHome + "/interpreter/spark/pyspark");
            }
            if (py4j.length > 1) {
                throw new RuntimeException("Multiple py4j files found under " + sparkHome + "/interpreter/spark/pyspark");
            }
            pythonPath.add(py4j[0].getAbsolutePath());
        }
        pythonPath.add(zeppelinHome + "/interpreter/lib/python");
        return StringUtils.join(pythonPath, ":");
    }
}

