/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.spark.AbstractSparkScalaInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkInterpreter.class);
    private static File scalaShellOutputDir;
    private static AtomicInteger SESSION_NUM;
    private static Class<?> innerInterpreterClazz;
    private AbstractSparkScalaInterpreter innerInterpreter;
    private Map<String, String> innerInterpreterClassMap = new HashMap<String, String>();
    private SparkContext sc;
    private JavaSparkContext jsc;
    private SQLContext sqlContext;
    private SparkSession sparkSession;
    private SparkVersion sparkVersion;
    private String scalaVersion;
    private boolean enableSupportedVersionCheck;

    public SparkInterpreter(Properties properties) {
        super(properties);
        if (Boolean.parseBoolean(properties.getProperty("zeppelin.spark.scala.color", "true"))) {
            System.setProperty("scala.color", "true");
        }
        this.enableSupportedVersionCheck = Boolean.parseBoolean(properties.getProperty("zeppelin.spark.enableSupportedVersionCheck", "true"));
        this.innerInterpreterClassMap.put("2.12", "org.apache.zeppelin.spark.SparkScala212Interpreter");
        this.innerInterpreterClassMap.put("2.13", "org.apache.zeppelin.spark.SparkScala213Interpreter");
    }

    public void open() throws InterpreterException {
        try {
            SparkConf conf = new SparkConf();
            for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
                if (!StringUtils.isBlank(entry.getValue().toString())) {
                    conf.set(entry.getKey().toString(), entry.getValue().toString());
                }
                if (entry.getKey().toString().equals("zeppelin.spark.useHiveContext")) {
                    conf.set("spark.useHiveContext", entry.getValue().toString());
                }
                if (!entry.getKey().toString().equals("zeppelin.spark.concurrentSQL") || !entry.getValue().toString().equals("true")) continue;
                conf.set("spark.scheduler.mode", "FAIR");
            }
            if (!conf.contains("spark.master")) {
                if (conf.contains("master")) {
                    conf.set("spark.master", conf.get("master"));
                } else {
                    String masterEnv = System.getenv("SPARK_MASTER");
                    conf.set("spark.master", masterEnv == null ? "local[*]" : masterEnv);
                }
            }
            this.innerInterpreter = this.loadSparkScalaInterpreter(conf);
            this.innerInterpreter.open();
            this.sc = this.innerInterpreter.getSparkContext();
            this.jsc = JavaSparkContext.fromSparkContext((SparkContext)this.sc);
            this.sparkVersion = SparkVersion.fromVersionString(this.sc.version());
            if (this.enableSupportedVersionCheck && this.sparkVersion.isUnsupportedVersion()) {
                throw new Exception("This is not officially supported spark version: " + this.sparkVersion + "\nYou can set zeppelin.spark.enableSupportedVersionCheck to false if you really want to try this version of spark.");
            }
            this.sqlContext = this.innerInterpreter.getSqlContext();
            this.sparkSession = this.innerInterpreter.getSparkSession();
            SESSION_NUM.incrementAndGet();
        }
        catch (Exception e) {
            LOGGER.error("Fail to open SparkInterpreter", e);
            throw new InterpreterException("Fail to open SparkInterpreter", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractSparkScalaInterpreter loadSparkScalaInterpreter(SparkConf conf) throws Exception {
        this.scalaVersion = this.extractScalaVersion(conf);
        if (innerInterpreterClazz != null) return (AbstractSparkScalaInterpreter)innerInterpreterClazz.getConstructor(SparkConf.class, List.class, Properties.class, InterpreterGroup.class, URLClassLoader.class, File.class).newInstance(conf, this.getDependencyFiles(), this.getProperties(), this.getInterpreterGroup(), innerInterpreterClazz.getClassLoader(), scalaShellOutputDir);
        Class<SparkInterpreter> clazz = SparkInterpreter.class;
        synchronized (SparkInterpreter.class) {
            if (innerInterpreterClazz != null) return (AbstractSparkScalaInterpreter)innerInterpreterClazz.getConstructor(SparkConf.class, List.class, Properties.class, InterpreterGroup.class, URLClassLoader.class, File.class).newInstance(conf, this.getDependencyFiles(), this.getProperties(), this.getInterpreterGroup(), innerInterpreterClazz.getClassLoader(), scalaShellOutputDir);
            LOGGER.debug("innerInterpreterClazz is null, thread:{}", (Object)Thread.currentThread().getName());
            ClassLoader scalaInterpreterClassLoader = Thread.currentThread().getContextClassLoader();
            String zeppelinHome = System.getenv("ZEPPELIN_HOME");
            if (zeppelinHome != null) {
                File scalaJarFolder = new File(zeppelinHome + "/interpreter/spark/scala-" + this.scalaVersion);
                ArrayList<URL> urls = new ArrayList<URL>();
                for (File file : scalaJarFolder.listFiles()) {
                    LOGGER.debug("Add file {} to classpath of spark scala interpreter: {}", (Object)file.getAbsolutePath(), (Object)scalaJarFolder);
                    urls.add(file.toURI().toURL());
                }
                scalaInterpreterClassLoader = new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            }
            String innerIntpClassName = this.innerInterpreterClassMap.get(this.scalaVersion);
            innerInterpreterClazz = scalaInterpreterClassLoader.loadClass(innerIntpClassName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (AbstractSparkScalaInterpreter)innerInterpreterClazz.getConstructor(SparkConf.class, List.class, Properties.class, InterpreterGroup.class, URLClassLoader.class, File.class).newInstance(conf, this.getDependencyFiles(), this.getProperties(), this.getInterpreterGroup(), innerInterpreterClazz.getClassLoader(), scalaShellOutputDir);
        }
    }

    public void close() throws InterpreterException {
        LOGGER.info("Close SparkInterpreter");
        if (SESSION_NUM.decrementAndGet() == 0 && this.innerInterpreter != null) {
            this.innerInterpreter.close();
            innerInterpreterClazz = null;
        }
        this.innerInterpreter = null;
    }

    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        context.out.clear();
        this.sc.setJobGroup(Utils.buildJobGroupId(context), Utils.buildJobDesc(context), false);
        this.sc.setLocalProperty("spark.scheduler.pool", (String)context.getLocalProperties().get("pool"));
        return this.innerInterpreter.interpret(st, context);
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.innerInterpreter.cancel(context);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return this.innerInterpreter.completion(buf, cursor, interpreterContext);
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.innerInterpreter.getProgress(context);
    }

    public ZeppelinContext getZeppelinContext() {
        if (this.innerInterpreter == null) {
            throw new RuntimeException("innerInterpreterContext is null");
        }
        return this.innerInterpreter.getZeppelinContext();
    }

    public SparkContext getSparkContext() {
        return this.sc;
    }

    public SQLContext getSQLContext() {
        return this.sqlContext;
    }

    public JavaSparkContext getJavaSparkContext() {
        return this.jsc;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public SparkVersion getSparkVersion() {
        return this.sparkVersion;
    }

    private String extractScalaVersion(SparkConf conf) throws InterpreterException {
        String scalaVersionString = conf.contains("zeppelin.spark.scala.version") ? conf.get("zeppelin.spark.scala.version") : scala.util.Properties.versionString();
        LOGGER.info("Using Scala: {}", (Object)scalaVersionString);
        if (StringUtils.isEmpty(scalaVersionString)) {
            throw new InterpreterException("Scala Version is empty");
        }
        if (scalaVersionString.contains("2.12")) {
            return "2.12";
        }
        if (scalaVersionString.contains("2.13")) {
            return "2.13";
        }
        throw new InterpreterException("Unsupported scala version: " + scalaVersionString);
    }

    public boolean isScala212() {
        return this.scalaVersion.equals("2.12");
    }

    public boolean isScala213() {
        return this.scalaVersion.equals("2.13");
    }

    private List<String> getDependencyFiles() throws InterpreterException {
        File[] files;
        File localRepoDir;
        ArrayList<String> depFiles = new ArrayList<String>();
        String localRepo = this.getProperty("zeppelin.interpreter.localRepo");
        if (localRepo != null && (localRepoDir = new File(localRepo)).exists() && (files = localRepoDir.listFiles()) != null) {
            for (File f : files) {
                depFiles.add(f.getAbsolutePath());
            }
        }
        return depFiles;
    }

    public ClassLoader getScalaShellClassLoader() {
        return this.innerInterpreter.getScalaShellClassLoader();
    }

    public boolean isUnsupportedSparkVersion() {
        return this.enableSupportedVersionCheck && this.sparkVersion.isUnsupportedVersion();
    }

    public AbstractSparkScalaInterpreter getInnerInterpreter() {
        return this.innerInterpreter;
    }

    static {
        try {
            scalaShellOutputDir = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), "spark", new FileAttribute[0]).toFile();
            scalaShellOutputDir.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to create scala shell output dir", e);
        }
        SESSION_NUM = new AtomicInteger(0);
    }
}

